<?php
/**
 * This class stands for XLDAPDirectoryFunction EnumType
 * @subpackage Enumerations
 */
class XLDAPDirectoryFunction
{
    /**
     * Constant for value 'DirSync'
     * @return string 'DirSync'
     */
    const VALUE_DIR_SYNC = 'DirSync';
    /**
     * Constant for value 'DN Alias Sync and Lookup'
     * @return string 'DN Alias Sync and Lookup'
     */
    const VALUE_DN_ALIAS_SYNC_AND_LOOKUP = 'DN Alias Sync and Lookup';
    /**
     * Constant for value 'Alias Sync only'
     * @return string 'Alias Sync only'
     */
    const VALUE_ALIAS_SYNC_ONLY = 'Alias Sync only';
    /**
     * Constant for value 'Lookup only'
     * @return string 'Lookup only'
     */
    const VALUE_LOOKUP_ONLY = 'Lookup only';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DIR_SYNC
     * @uses self::VALUE_DN_ALIAS_SYNC_AND_LOOKUP
     * @uses self::VALUE_ALIAS_SYNC_ONLY
     * @uses self::VALUE_LOOKUP_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DIR_SYNC,
            self::VALUE_DN_ALIAS_SYNC_AND_LOOKUP,
            self::VALUE_ALIAS_SYNC_ONLY,
            self::VALUE_LOOKUP_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
