<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeClient StructType
 * @subpackage Structs
 */
class XImeClient extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $domain;
    /**
     * The sipTrunkName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $sipTrunkName;
    /**
     * The primaryImeServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $primaryImeServerName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isActivated
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The secondaryImeServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $secondaryImeServerName;
    /**
     * The learnedRouteFilterGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $learnedRouteFilterGroupName;
    /**
     * The exclusionNumberGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $exclusionNumberGroupName;
    /**
     * The firewallName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $firewallName;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The ccmExternalIpMaps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var CcmExternalIpMaps
     */
    public $ccmExternalIpMaps;
    /**
     * Constructor method for XImeClient
     * @uses XImeClient::setName()
     * @uses XImeClient::setDomain()
     * @uses XImeClient::setSipTrunkName()
     * @uses XImeClient::setPrimaryImeServerName()
     * @uses XImeClient::setDescription()
     * @uses XImeClient::setIsActivated()
     * @uses XImeClient::setSecondaryImeServerName()
     * @uses XImeClient::setLearnedRouteFilterGroupName()
     * @uses XImeClient::setExclusionNumberGroupName()
     * @uses XImeClient::setFirewallName()
     * @uses XImeClient::setMembers()
     * @uses XImeClient::setCcmExternalIpMaps()
     * @param string $name
     * @param string $domain
     * @param XFkType $sipTrunkName
     * @param XFkType $primaryImeServerName
     * @param string $description
     * @param string $isActivated
     * @param XFkType $secondaryImeServerName
     * @param XFkType $learnedRouteFilterGroupName
     * @param XFkType $exclusionNumberGroupName
     * @param XFkType $firewallName
     * @param Members $members
     * @param CcmExternalIpMaps $ccmExternalIpMaps
     */
    public function __construct($name = null, $domain = null, XFkType $sipTrunkName = null, XFkType $primaryImeServerName = null, $description = null, $isActivated = false, XFkType $secondaryImeServerName = null, XFkType $learnedRouteFilterGroupName = null, XFkType $exclusionNumberGroupName = null, XFkType $firewallName = null, Members $members = null, CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        $this
            ->setName($name)
            ->setDomain($domain)
            ->setSipTrunkName($sipTrunkName)
            ->setPrimaryImeServerName($primaryImeServerName)
            ->setDescription($description)
            ->setIsActivated($isActivated)
            ->setSecondaryImeServerName($secondaryImeServerName)
            ->setLearnedRouteFilterGroupName($learnedRouteFilterGroupName)
            ->setExclusionNumberGroupName($exclusionNumberGroupName)
            ->setFirewallName($firewallName)
            ->setMembers($members)
            ->setCcmExternalIpMaps($ccmExternalIpMaps);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XImeClient
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get domain value
     * @return string
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return XImeClient
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($domain) && strlen($domain) > 255) || (is_array($domain) && count($domain) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($domain) ? strlen($domain) : count($domain)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return XFkType
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param XFkType $sipTrunkName
     * @return XImeClient
     */
    public function setSipTrunkName(XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get primaryImeServerName value
     * @return XFkType
     */
    public function getPrimaryImeServerName()
    {
        return $this->primaryImeServerName;
    }
    /**
     * Set primaryImeServerName value
     * @param XFkType $primaryImeServerName
     * @return XImeClient
     */
    public function setPrimaryImeServerName(XFkType $primaryImeServerName = null)
    {
        $this->primaryImeServerName = $primaryImeServerName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XImeClient
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return XImeClient
     */
    public function setIsActivated($isActivated = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActivated, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get secondaryImeServerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSecondaryImeServerName()
    {
        return isset($this->secondaryImeServerName) ? $this->secondaryImeServerName : null;
    }
    /**
     * Set secondaryImeServerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $secondaryImeServerName
     * @return XImeClient
     */
    public function setSecondaryImeServerName(XFkType $secondaryImeServerName = null)
    {
        if (is_null($secondaryImeServerName) || (is_array($secondaryImeServerName) && empty($secondaryImeServerName))) {
            unset($this->secondaryImeServerName);
        } else {
            $this->secondaryImeServerName = $secondaryImeServerName;
        }
        return $this;
    }
    /**
     * Get learnedRouteFilterGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getLearnedRouteFilterGroupName()
    {
        return isset($this->learnedRouteFilterGroupName) ? $this->learnedRouteFilterGroupName : null;
    }
    /**
     * Set learnedRouteFilterGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $learnedRouteFilterGroupName
     * @return XImeClient
     */
    public function setLearnedRouteFilterGroupName(XFkType $learnedRouteFilterGroupName = null)
    {
        if (is_null($learnedRouteFilterGroupName) || (is_array($learnedRouteFilterGroupName) && empty($learnedRouteFilterGroupName))) {
            unset($this->learnedRouteFilterGroupName);
        } else {
            $this->learnedRouteFilterGroupName = $learnedRouteFilterGroupName;
        }
        return $this;
    }
    /**
     * Get exclusionNumberGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getExclusionNumberGroupName()
    {
        return isset($this->exclusionNumberGroupName) ? $this->exclusionNumberGroupName : null;
    }
    /**
     * Set exclusionNumberGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $exclusionNumberGroupName
     * @return XImeClient
     */
    public function setExclusionNumberGroupName(XFkType $exclusionNumberGroupName = null)
    {
        if (is_null($exclusionNumberGroupName) || (is_array($exclusionNumberGroupName) && empty($exclusionNumberGroupName))) {
            unset($this->exclusionNumberGroupName);
        } else {
            $this->exclusionNumberGroupName = $exclusionNumberGroupName;
        }
        return $this;
    }
    /**
     * Get firewallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getFirewallName()
    {
        return isset($this->firewallName) ? $this->firewallName : null;
    }
    /**
     * Set firewallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $firewallName
     * @return XImeClient
     */
    public function setFirewallName(XFkType $firewallName = null)
    {
        if (is_null($firewallName) || (is_array($firewallName) && empty($firewallName))) {
            unset($this->firewallName);
        } else {
            $this->firewallName = $firewallName;
        }
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return XImeClient
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get ccmExternalIpMaps value
     * @return CcmExternalIpMaps|null
     */
    public function getCcmExternalIpMaps()
    {
        return $this->ccmExternalIpMaps;
    }
    /**
     * Set ccmExternalIpMaps value
     * @param CcmExternalIpMaps $ccmExternalIpMaps
     * @return XImeClient
     */
    public function setCcmExternalIpMaps(CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        $this->ccmExternalIpMaps = $ccmExternalIpMaps;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XImeClient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
