<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XGeoLocation StructType
 * @subpackage Structs
 */
class XGeoLocation extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $country;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The nationalSubDivision
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 100
     * @var string
     */
    public $nationalSubDivision;
    /**
     * The district
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $district;
    /**
     * The communityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $communityName;
    /**
     * The cityDivision
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $cityDivision;
    /**
     * The neighbourhood
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $neighbourhood;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $street;
    /**
     * The leadingStreetDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $leadingStreetDirection;
    /**
     * The trailingStreetSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $trailingStreetSuffix;
    /**
     * The streetSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $streetSuffix;
    /**
     * The houseNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $houseNumber;
    /**
     * The houseNumberSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 100
     * @var string
     */
    public $houseNumberSuffix;
    /**
     * The landmark
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $landmark;
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $location;
    /**
     * The floor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $floor;
    /**
     * The occupantName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $occupantName;
    /**
     * The postalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 100
     * @var string
     */
    public $postalCode;
    /**
     * Constructor method for XGeoLocation
     * @uses XGeoLocation::setName()
     * @uses XGeoLocation::setCountry()
     * @uses XGeoLocation::setDescription()
     * @uses XGeoLocation::setNationalSubDivision()
     * @uses XGeoLocation::setDistrict()
     * @uses XGeoLocation::setCommunityName()
     * @uses XGeoLocation::setCityDivision()
     * @uses XGeoLocation::setNeighbourhood()
     * @uses XGeoLocation::setStreet()
     * @uses XGeoLocation::setLeadingStreetDirection()
     * @uses XGeoLocation::setTrailingStreetSuffix()
     * @uses XGeoLocation::setStreetSuffix()
     * @uses XGeoLocation::setHouseNumber()
     * @uses XGeoLocation::setHouseNumberSuffix()
     * @uses XGeoLocation::setLandmark()
     * @uses XGeoLocation::setLocation()
     * @uses XGeoLocation::setFloor()
     * @uses XGeoLocation::setOccupantName()
     * @uses XGeoLocation::setPostalCode()
     * @param string $name
     * @param string $country
     * @param string $description
     * @param string $nationalSubDivision
     * @param string $district
     * @param string $communityName
     * @param string $cityDivision
     * @param string $neighbourhood
     * @param string $street
     * @param string $leadingStreetDirection
     * @param string $trailingStreetSuffix
     * @param string $streetSuffix
     * @param string $houseNumber
     * @param string $houseNumberSuffix
     * @param string $landmark
     * @param string $location
     * @param string $floor
     * @param string $occupantName
     * @param string $postalCode
     */
    public function __construct($name = null, $country = null, $description = null, $nationalSubDivision = null, $district = null, $communityName = null, $cityDivision = null, $neighbourhood = null, $street = null, $leadingStreetDirection = null, $trailingStreetSuffix = null, $streetSuffix = null, $houseNumber = null, $houseNumberSuffix = null, $landmark = null, $location = null, $floor = null, $occupantName = null, $postalCode = null)
    {
        $this
            ->setName($name)
            ->setCountry($country)
            ->setDescription($description)
            ->setNationalSubDivision($nationalSubDivision)
            ->setDistrict($district)
            ->setCommunityName($communityName)
            ->setCityDivision($cityDivision)
            ->setNeighbourhood($neighbourhood)
            ->setStreet($street)
            ->setLeadingStreetDirection($leadingStreetDirection)
            ->setTrailingStreetSuffix($trailingStreetSuffix)
            ->setStreetSuffix($streetSuffix)
            ->setHouseNumber($houseNumber)
            ->setHouseNumberSuffix($houseNumberSuffix)
            ->setLandmark($landmark)
            ->setLocation($location)
            ->setFloor($floor)
            ->setOccupantName($occupantName)
            ->setPostalCode($postalCode);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XGeoLocation
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return XGeoLocation
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XGeoLocation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get nationalSubDivision value
     * @return string|null
     */
    public function getNationalSubDivision()
    {
        return $this->nationalSubDivision;
    }
    /**
     * Set nationalSubDivision value
     * @param string $nationalSubDivision
     * @return XGeoLocation
     */
    public function setNationalSubDivision($nationalSubDivision = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nationalSubDivision) && strlen($nationalSubDivision) > 100) || (is_array($nationalSubDivision) && count($nationalSubDivision) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($nationalSubDivision) ? strlen($nationalSubDivision) : count($nationalSubDivision)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nationalSubDivision) && !is_string($nationalSubDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalSubDivision)), __LINE__);
        }
        $this->nationalSubDivision = $nationalSubDivision;
        return $this;
    }
    /**
     * Get district value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @param string $district
     * @return XGeoLocation
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($district) && strlen($district) > 255) || (is_array($district) && count($district) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($district) ? strlen($district) : count($district)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($district)), __LINE__);
        }
        $this->district = $district;
        return $this;
    }
    /**
     * Get communityName value
     * @return string|null
     */
    public function getCommunityName()
    {
        return $this->communityName;
    }
    /**
     * Set communityName value
     * @param string $communityName
     * @return XGeoLocation
     */
    public function setCommunityName($communityName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($communityName) && strlen($communityName) > 255) || (is_array($communityName) && count($communityName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($communityName) ? strlen($communityName) : count($communityName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($communityName) && !is_string($communityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communityName)), __LINE__);
        }
        $this->communityName = $communityName;
        return $this;
    }
    /**
     * Get cityDivision value
     * @return string|null
     */
    public function getCityDivision()
    {
        return $this->cityDivision;
    }
    /**
     * Set cityDivision value
     * @param string $cityDivision
     * @return XGeoLocation
     */
    public function setCityDivision($cityDivision = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cityDivision) && strlen($cityDivision) > 255) || (is_array($cityDivision) && count($cityDivision) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($cityDivision) ? strlen($cityDivision) : count($cityDivision)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cityDivision) && !is_string($cityDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityDivision)), __LINE__);
        }
        $this->cityDivision = $cityDivision;
        return $this;
    }
    /**
     * Get neighbourhood value
     * @return string|null
     */
    public function getNeighbourhood()
    {
        return $this->neighbourhood;
    }
    /**
     * Set neighbourhood value
     * @param string $neighbourhood
     * @return XGeoLocation
     */
    public function setNeighbourhood($neighbourhood = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($neighbourhood) && strlen($neighbourhood) > 255) || (is_array($neighbourhood) && count($neighbourhood) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($neighbourhood) ? strlen($neighbourhood) : count($neighbourhood)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($neighbourhood) && !is_string($neighbourhood)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($neighbourhood)), __LINE__);
        }
        $this->neighbourhood = $neighbourhood;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return XGeoLocation
     */
    public function setStreet($street = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($street) && strlen($street) > 255) || (is_array($street) && count($street) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($street) ? strlen($street) : count($street)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get leadingStreetDirection value
     * @return string|null
     */
    public function getLeadingStreetDirection()
    {
        return $this->leadingStreetDirection;
    }
    /**
     * Set leadingStreetDirection value
     * @param string $leadingStreetDirection
     * @return XGeoLocation
     */
    public function setLeadingStreetDirection($leadingStreetDirection = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($leadingStreetDirection) && strlen($leadingStreetDirection) > 50) || (is_array($leadingStreetDirection) && count($leadingStreetDirection) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($leadingStreetDirection) ? strlen($leadingStreetDirection) : count($leadingStreetDirection)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($leadingStreetDirection) && !is_string($leadingStreetDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leadingStreetDirection)), __LINE__);
        }
        $this->leadingStreetDirection = $leadingStreetDirection;
        return $this;
    }
    /**
     * Get trailingStreetSuffix value
     * @return string|null
     */
    public function getTrailingStreetSuffix()
    {
        return $this->trailingStreetSuffix;
    }
    /**
     * Set trailingStreetSuffix value
     * @param string $trailingStreetSuffix
     * @return XGeoLocation
     */
    public function setTrailingStreetSuffix($trailingStreetSuffix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($trailingStreetSuffix) && strlen($trailingStreetSuffix) > 50) || (is_array($trailingStreetSuffix) && count($trailingStreetSuffix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($trailingStreetSuffix) ? strlen($trailingStreetSuffix) : count($trailingStreetSuffix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($trailingStreetSuffix) && !is_string($trailingStreetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trailingStreetSuffix)), __LINE__);
        }
        $this->trailingStreetSuffix = $trailingStreetSuffix;
        return $this;
    }
    /**
     * Get streetSuffix value
     * @return string|null
     */
    public function getStreetSuffix()
    {
        return $this->streetSuffix;
    }
    /**
     * Set streetSuffix value
     * @param string $streetSuffix
     * @return XGeoLocation
     */
    public function setStreetSuffix($streetSuffix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($streetSuffix) && strlen($streetSuffix) > 255) || (is_array($streetSuffix) && count($streetSuffix) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($streetSuffix) ? strlen($streetSuffix) : count($streetSuffix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($streetSuffix) && !is_string($streetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetSuffix)), __LINE__);
        }
        $this->streetSuffix = $streetSuffix;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return XGeoLocation
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($houseNumber) && strlen($houseNumber) > 16) || (is_array($houseNumber) && count($houseNumber) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($houseNumber) ? strlen($houseNumber) : count($houseNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get houseNumberSuffix value
     * @return string|null
     */
    public function getHouseNumberSuffix()
    {
        return $this->houseNumberSuffix;
    }
    /**
     * Set houseNumberSuffix value
     * @param string $houseNumberSuffix
     * @return XGeoLocation
     */
    public function setHouseNumberSuffix($houseNumberSuffix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($houseNumberSuffix) && strlen($houseNumberSuffix) > 100) || (is_array($houseNumberSuffix) && count($houseNumberSuffix) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($houseNumberSuffix) ? strlen($houseNumberSuffix) : count($houseNumberSuffix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($houseNumberSuffix) && !is_string($houseNumberSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNumberSuffix)), __LINE__);
        }
        $this->houseNumberSuffix = $houseNumberSuffix;
        return $this;
    }
    /**
     * Get landmark value
     * @return string|null
     */
    public function getLandmark()
    {
        return $this->landmark;
    }
    /**
     * Set landmark value
     * @param string $landmark
     * @return XGeoLocation
     */
    public function setLandmark($landmark = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($landmark) && strlen($landmark) > 255) || (is_array($landmark) && count($landmark) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($landmark) ? strlen($landmark) : count($landmark)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($landmark) && !is_string($landmark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($landmark)), __LINE__);
        }
        $this->landmark = $landmark;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return XGeoLocation
     */
    public function setLocation($location = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($location) && strlen($location) > 255) || (is_array($location) && count($location) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($location) ? strlen($location) : count($location)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return XGeoLocation
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($floor) && strlen($floor) > 16) || (is_array($floor) && count($floor) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($floor) ? strlen($floor) : count($floor)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get occupantName value
     * @return string|null
     */
    public function getOccupantName()
    {
        return $this->occupantName;
    }
    /**
     * Set occupantName value
     * @param string $occupantName
     * @return XGeoLocation
     */
    public function setOccupantName($occupantName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($occupantName) && strlen($occupantName) > 255) || (is_array($occupantName) && count($occupantName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($occupantName) ? strlen($occupantName) : count($occupantName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($occupantName) && !is_string($occupantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($occupantName)), __LINE__);
        }
        $this->occupantName = $occupantName;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return XGeoLocation
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postalCode) && strlen($postalCode) > 100) || (is_array($postalCode) && count($postalCode) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($postalCode) ? strlen($postalCode) : count($postalCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XGeoLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
