<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XGatewayEndpointDigitalAccessPri StructType
 * @subpackage Structs
 */
class XGatewayEndpointDigitalAccessPri extends AbstractStructBase
{
    /**
     * The domainName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The gatewayUuid
     * Meta informations extracted from the WSDL
     * - documentation: pkid of the Gateway whose endpoint is to be added
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The unit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $unit;
    /**
     * The subunit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subunit;
    /**
     * The endpoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XGatewayEndpointDigitalPri
     */
    public $endpoint;
    /**
     * Constructor method for XGatewayEndpointDigitalAccessPri
     * @uses XGatewayEndpointDigitalAccessPri::setDomainName()
     * @uses XGatewayEndpointDigitalAccessPri::setGatewayUuid()
     * @uses XGatewayEndpointDigitalAccessPri::setUnit()
     * @uses XGatewayEndpointDigitalAccessPri::setSubunit()
     * @uses XGatewayEndpointDigitalAccessPri::setEndpoint()
     * @param string $domainName
     * @param string $gatewayUuid
     * @param string $unit
     * @param string $subunit
     * @param XGatewayEndpointDigitalPri $endpoint
     */
    public function __construct($domainName = null, $gatewayUuid = null, $unit = null, $subunit = null, XGatewayEndpointDigitalPri $endpoint = null)
    {
        $this
            ->setDomainName($domainName)
            ->setGatewayUuid($gatewayUuid)
            ->setUnit($unit)
            ->setSubunit($subunit)
            ->setEndpoint($endpoint);
    }
    /**
     * Get domainName value
     * @return string
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return XGatewayEndpointDigitalAccessPri
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get gatewayUuid value
     * @return string
     */
    public function getGatewayUuid()
    {
        return $this->gatewayUuid;
    }
    /**
     * Set gatewayUuid value
     * @param string $gatewayUuid
     * @return XGatewayEndpointDigitalAccessPri
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gatewayUuid) && !preg_match('/\{........-....-....-....-............\}/', $gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($gatewayUuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gatewayUuid) && !is_string($gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gatewayUuid)), __LINE__);
        }
        $this->gatewayUuid = $gatewayUuid;
        return $this;
    }
    /**
     * Get unit value
     * @return string
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit
     * @return XGatewayEndpointDigitalAccessPri
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($unit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unit, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get subunit value
     * @return string
     */
    public function getSubunit()
    {
        return $this->subunit;
    }
    /**
     * Set subunit value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subunit
     * @return XGatewayEndpointDigitalAccessPri
     */
    public function setSubunit($subunit = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($subunit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subunit, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->subunit = $subunit;
        return $this;
    }
    /**
     * Get endpoint value
     * @return XGatewayEndpointDigitalPri
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }
    /**
     * Set endpoint value
     * @param XGatewayEndpointDigitalPri $endpoint
     * @return XGatewayEndpointDigitalAccessPri
     */
    public function setEndpoint(XGatewayEndpointDigitalPri $endpoint = null)
    {
        $this->endpoint = $endpoint;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XGatewayEndpointDigitalAccessPri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
