<?php
/**
 * This class stands for XEOSuppVoiceCall EnumType
 * @subpackage Enumerations
 */
class XEOSuppVoiceCall
{
    /**
     * Constant for value 'Disabled (Default value)'
     * @return string 'Disabled (Default value)'
     */
    const VALUE_DISABLED_DEFAULT_VALUE = 'Disabled (Default value)';
    /**
     * Constant for value 'Best Effort (no MTP inserted)'
     * @return string 'Best Effort (no MTP inserted)'
     */
    const VALUE_BEST_EFFORT_NO_MTP_INSERTED = 'Best Effort (no MTP inserted)';
    /**
     * Constant for value 'Mandatory (insert MTP if needed)'
     * @return string 'Mandatory (insert MTP if needed)'
     */
    const VALUE_MANDATORY_INSERT_MTP_IF_NEEDED = 'Mandatory (insert MTP if needed)';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISABLED_DEFAULT_VALUE
     * @uses self::VALUE_BEST_EFFORT_NO_MTP_INSERTED
     * @uses self::VALUE_MANDATORY_INSERT_MTP_IF_NEEDED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISABLED_DEFAULT_VALUE,
            self::VALUE_BEST_EFFORT_NO_MTP_INSERTED,
            self::VALUE_MANDATORY_INSERT_MTP_IF_NEEDED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
