<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDirectoryLookupDialRules StructType
 * @subpackage Structs
 */
class XDirectoryLookupDialRules extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The numberOfDigits
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $numberOfDigits;
    /**
     * The digitsToBeRemoved
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $digitsToBeRemoved;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $priority;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The numberBeginWith
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numberBeginWith;
    /**
     * The prefixPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $prefixPattern;
    /**
     * Constructor method for XDirectoryLookupDialRules
     * @uses XDirectoryLookupDialRules::setName()
     * @uses XDirectoryLookupDialRules::setNumberOfDigits()
     * @uses XDirectoryLookupDialRules::setDigitsToBeRemoved()
     * @uses XDirectoryLookupDialRules::setPriority()
     * @uses XDirectoryLookupDialRules::setDescription()
     * @uses XDirectoryLookupDialRules::setNumberBeginWith()
     * @uses XDirectoryLookupDialRules::setPrefixPattern()
     * @param string $name
     * @param string $numberOfDigits
     * @param string $digitsToBeRemoved
     * @param string $priority
     * @param string $description
     * @param string $numberBeginWith
     * @param string $prefixPattern
     */
    public function __construct($name = null, $numberOfDigits = '0', $digitsToBeRemoved = '0', $priority = '0', $description = null, $numberBeginWith = null, $prefixPattern = null)
    {
        $this
            ->setName($name)
            ->setNumberOfDigits($numberOfDigits)
            ->setDigitsToBeRemoved($digitsToBeRemoved)
            ->setPriority($priority)
            ->setDescription($description)
            ->setNumberBeginWith($numberBeginWith)
            ->setPrefixPattern($prefixPattern);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XDirectoryLookupDialRules
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get numberOfDigits value
     * @return string
     */
    public function getNumberOfDigits()
    {
        return $this->numberOfDigits;
    }
    /**
     * Set numberOfDigits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfDigits
     * @return XDirectoryLookupDialRules
     */
    public function setNumberOfDigits($numberOfDigits = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($numberOfDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberOfDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfDigits = $numberOfDigits;
        return $this;
    }
    /**
     * Get digitsToBeRemoved value
     * @return string
     */
    public function getDigitsToBeRemoved()
    {
        return $this->digitsToBeRemoved;
    }
    /**
     * Set digitsToBeRemoved value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitsToBeRemoved
     * @return XDirectoryLookupDialRules
     */
    public function setDigitsToBeRemoved($digitsToBeRemoved = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($digitsToBeRemoved)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $digitsToBeRemoved, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->digitsToBeRemoved = $digitsToBeRemoved;
        return $this;
    }
    /**
     * Get priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return XDirectoryLookupDialRules
     */
    public function setPriority($priority = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XDirectoryLookupDialRules
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get numberBeginWith value
     * @return string|null
     */
    public function getNumberBeginWith()
    {
        return $this->numberBeginWith;
    }
    /**
     * Set numberBeginWith value
     * @param string $numberBeginWith
     * @return XDirectoryLookupDialRules
     */
    public function setNumberBeginWith($numberBeginWith = null)
    {
        // validation for constraint: string
        if (!is_null($numberBeginWith) && !is_string($numberBeginWith)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberBeginWith)), __LINE__);
        }
        $this->numberBeginWith = $numberBeginWith;
        return $this;
    }
    /**
     * Get prefixPattern value
     * @return string|null
     */
    public function getPrefixPattern()
    {
        return $this->prefixPattern;
    }
    /**
     * Set prefixPattern value
     * @param string $prefixPattern
     * @return XDirectoryLookupDialRules
     */
    public function setPrefixPattern($prefixPattern = null)
    {
        // validation for constraint: string
        if (!is_null($prefixPattern) && !is_string($prefixPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixPattern)), __LINE__);
        }
        $this->prefixPattern = $prefixPattern;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XDirectoryLookupDialRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
