<?php
/**
 * This class stands for XDialParameter EnumType
 * @subpackage Enumerations
 */
class XDialParameter
{
    /**
     * Constant for value 'Pattern'
     * @return string 'Pattern'
     */
    const VALUE_PATTERN = 'Pattern';
    /**
     * Constant for value 'Button'
     * @return string 'Button'
     */
    const VALUE_BUTTON = 'Button';
    /**
     * Constant for value 'Timeout'
     * @return string 'Timeout'
     */
    const VALUE_TIMEOUT = 'Timeout';
    /**
     * Constant for value 'User'
     * @return string 'User'
     */
    const VALUE_USER = 'User';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PATTERN
     * @uses self::VALUE_BUTTON
     * @uses self::VALUE_TIMEOUT
     * @uses self::VALUE_USER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PATTERN,
            self::VALUE_BUTTON,
            self::VALUE_TIMEOUT,
            self::VALUE_USER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
