<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDateTimeGroup StructType
 * @subpackage Structs
 */
class XDateTimeGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The timeZone
     * Meta informations extracted from the WSDL
     * - default: Europe/London
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * The separator
     * Meta informations extracted from the WSDL
     * - documentation: It can be one among / (slash), . (dot), - (dash)
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $separator;
    /**
     * The dateformat
     * Meta informations extracted from the WSDL
     * - documentation: It can be one among D/M/Y,M/D/Y,Y/M/D
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $dateformat;
    /**
     * The timeFormat
     * Meta informations extracted from the WSDL
     * - documentation: It can be one among 12-hour,24-hour
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $timeFormat;
    /**
     * The phoneNtpReferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PhoneNtpReferences
     */
    public $phoneNtpReferences;
    /**
     * Constructor method for XDateTimeGroup
     * @uses XDateTimeGroup::setName()
     * @uses XDateTimeGroup::setTimeZone()
     * @uses XDateTimeGroup::setSeparator()
     * @uses XDateTimeGroup::setDateformat()
     * @uses XDateTimeGroup::setTimeFormat()
     * @uses XDateTimeGroup::setPhoneNtpReferences()
     * @param string $name
     * @param string $timeZone
     * @param string $separator
     * @param string $dateformat
     * @param string $timeFormat
     * @param PhoneNtpReferences $phoneNtpReferences
     */
    public function __construct($name = null, $timeZone = 'Europe/London', $separator = null, $dateformat = null, $timeFormat = null, PhoneNtpReferences $phoneNtpReferences = null)
    {
        $this
            ->setName($name)
            ->setTimeZone($timeZone)
            ->setSeparator($separator)
            ->setDateformat($dateformat)
            ->setTimeFormat($timeFormat)
            ->setPhoneNtpReferences($phoneNtpReferences);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XDateTimeGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses XTimeZone::valueIsValid()
     * @uses XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return XDateTimeGroup
     */
    public function setTimeZone($timeZone = 'Europe/London')
    {
        // validation for constraint: enumeration
        if (!XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get separator value
     * @return string
     */
    public function getSeparator()
    {
        return $this->separator;
    }
    /**
     * Set separator value
     * @param string $separator
     * @return XDateTimeGroup
     */
    public function setSeparator($separator = null)
    {
        // validation for constraint: string
        if (!is_null($separator) && !is_string($separator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($separator)), __LINE__);
        }
        $this->separator = $separator;
        return $this;
    }
    /**
     * Get dateformat value
     * @return string
     */
    public function getDateformat()
    {
        return $this->dateformat;
    }
    /**
     * Set dateformat value
     * @param string $dateformat
     * @return XDateTimeGroup
     */
    public function setDateformat($dateformat = null)
    {
        // validation for constraint: string
        if (!is_null($dateformat) && !is_string($dateformat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateformat)), __LINE__);
        }
        $this->dateformat = $dateformat;
        return $this;
    }
    /**
     * Get timeFormat value
     * @return string
     */
    public function getTimeFormat()
    {
        return $this->timeFormat;
    }
    /**
     * Set timeFormat value
     * @param string $timeFormat
     * @return XDateTimeGroup
     */
    public function setTimeFormat($timeFormat = null)
    {
        // validation for constraint: string
        if (!is_null($timeFormat) && !is_string($timeFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeFormat)), __LINE__);
        }
        $this->timeFormat = $timeFormat;
        return $this;
    }
    /**
     * Get phoneNtpReferences value
     * @return PhoneNtpReferences|null
     */
    public function getPhoneNtpReferences()
    {
        return $this->phoneNtpReferences;
    }
    /**
     * Set phoneNtpReferences value
     * @param PhoneNtpReferences $phoneNtpReferences
     * @return XDateTimeGroup
     */
    public function setPhoneNtpReferences(PhoneNtpReferences $phoneNtpReferences = null)
    {
        $this->phoneNtpReferences = $phoneNtpReferences;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XDateTimeGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
