<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCredentialPolicy StructType
 * @subpackage Structs
 */
class XCredentialPolicy extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The failedLogon
     * Meta informations extracted from the WSDL
     * - default: 3
     * - documentation: Failed logon must be a number in the range 0 to 100. If 0 is entered, NoLimitForFailedLogon is true
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $failedLogon;
    /**
     * The resetFailedLogonAttempts
     * Meta informations extracted from the WSDL
     * - default: 30
     * - documentation: Reset Failed logon attempts must be a number in the range 1 to 120. (minutes)
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $resetFailedLogonAttempts;
    /**
     * The lockoutDuration
     * Meta informations extracted from the WSDL
     * - default: 30
     * - documentation: Lockout duration must be a number in the range 0 to 1440. (minutes), If 0 is entered then Administrator Must Unlock is true.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $lockoutDuration;
    /**
     * The credChangeDuration
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Credential change duration must be a number in the range 0 to 129600. (minutes)
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $credChangeDuration;
    /**
     * The credExpiresAfter
     * Meta informations extracted from the WSDL
     * - default: 180
     * - documentation: Credential expires after must be a number in the range 0 to 365. (Days). If 0 is entered, then neverExpires is true
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $credExpiresAfter;
    /**
     * The minCredLength
     * Meta informations extracted from the WSDL
     * - default: 8
     * - documentation: Minimum credential length must be a number in the range 0 to 64.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $minCredLength;
    /**
     * The prevCredStoredNum
     * Meta informations extracted from the WSDL
     * - default: 12
     * - documentation: Stored number of previous credentials must be a number in the range 0 to 25.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $prevCredStoredNum;
    /**
     * The inactiveDaysAllowed
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Inactive days allowed must be a number in the range 0 to 5000.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $inactiveDaysAllowed;
    /**
     * The expiryWarningDays
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Expiry warning days must be a number in the range 0 to 90.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $expiryWarningDays;
    /**
     * The trivialCredCheck
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $trivialCredCheck;
    /**
     * Constructor method for XCredentialPolicy
     * @uses XCredentialPolicy::setName()
     * @uses XCredentialPolicy::setFailedLogon()
     * @uses XCredentialPolicy::setResetFailedLogonAttempts()
     * @uses XCredentialPolicy::setLockoutDuration()
     * @uses XCredentialPolicy::setCredChangeDuration()
     * @uses XCredentialPolicy::setCredExpiresAfter()
     * @uses XCredentialPolicy::setMinCredLength()
     * @uses XCredentialPolicy::setPrevCredStoredNum()
     * @uses XCredentialPolicy::setInactiveDaysAllowed()
     * @uses XCredentialPolicy::setExpiryWarningDays()
     * @uses XCredentialPolicy::setTrivialCredCheck()
     * @param string $name
     * @param string $failedLogon
     * @param string $resetFailedLogonAttempts
     * @param string $lockoutDuration
     * @param string $credChangeDuration
     * @param string $credExpiresAfter
     * @param string $minCredLength
     * @param string $prevCredStoredNum
     * @param string $inactiveDaysAllowed
     * @param string $expiryWarningDays
     * @param string $trivialCredCheck
     */
    public function __construct($name = null, $failedLogon = '3', $resetFailedLogonAttempts = '30', $lockoutDuration = '30', $credChangeDuration = '0', $credExpiresAfter = '180', $minCredLength = '8', $prevCredStoredNum = '12', $inactiveDaysAllowed = '0', $expiryWarningDays = '0', $trivialCredCheck = true)
    {
        $this
            ->setName($name)
            ->setFailedLogon($failedLogon)
            ->setResetFailedLogonAttempts($resetFailedLogonAttempts)
            ->setLockoutDuration($lockoutDuration)
            ->setCredChangeDuration($credChangeDuration)
            ->setCredExpiresAfter($credExpiresAfter)
            ->setMinCredLength($minCredLength)
            ->setPrevCredStoredNum($prevCredStoredNum)
            ->setInactiveDaysAllowed($inactiveDaysAllowed)
            ->setExpiryWarningDays($expiryWarningDays)
            ->setTrivialCredCheck($trivialCredCheck);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XCredentialPolicy
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get failedLogon value
     * @return string
     */
    public function getFailedLogon()
    {
        return $this->failedLogon;
    }
    /**
     * Set failedLogon value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failedLogon
     * @return XCredentialPolicy
     */
    public function setFailedLogon($failedLogon = '3')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($failedLogon)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $failedLogon, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->failedLogon = $failedLogon;
        return $this;
    }
    /**
     * Get resetFailedLogonAttempts value
     * @return string
     */
    public function getResetFailedLogonAttempts()
    {
        return $this->resetFailedLogonAttempts;
    }
    /**
     * Set resetFailedLogonAttempts value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resetFailedLogonAttempts
     * @return XCredentialPolicy
     */
    public function setResetFailedLogonAttempts($resetFailedLogonAttempts = '30')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($resetFailedLogonAttempts)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resetFailedLogonAttempts, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->resetFailedLogonAttempts = $resetFailedLogonAttempts;
        return $this;
    }
    /**
     * Get lockoutDuration value
     * @return string
     */
    public function getLockoutDuration()
    {
        return $this->lockoutDuration;
    }
    /**
     * Set lockoutDuration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lockoutDuration
     * @return XCredentialPolicy
     */
    public function setLockoutDuration($lockoutDuration = '30')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($lockoutDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lockoutDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->lockoutDuration = $lockoutDuration;
        return $this;
    }
    /**
     * Get credChangeDuration value
     * @return string
     */
    public function getCredChangeDuration()
    {
        return $this->credChangeDuration;
    }
    /**
     * Set credChangeDuration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credChangeDuration
     * @return XCredentialPolicy
     */
    public function setCredChangeDuration($credChangeDuration = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($credChangeDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $credChangeDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->credChangeDuration = $credChangeDuration;
        return $this;
    }
    /**
     * Get credExpiresAfter value
     * @return string
     */
    public function getCredExpiresAfter()
    {
        return $this->credExpiresAfter;
    }
    /**
     * Set credExpiresAfter value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credExpiresAfter
     * @return XCredentialPolicy
     */
    public function setCredExpiresAfter($credExpiresAfter = '180')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($credExpiresAfter)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $credExpiresAfter, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->credExpiresAfter = $credExpiresAfter;
        return $this;
    }
    /**
     * Get minCredLength value
     * @return string
     */
    public function getMinCredLength()
    {
        return $this->minCredLength;
    }
    /**
     * Set minCredLength value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $minCredLength
     * @return XCredentialPolicy
     */
    public function setMinCredLength($minCredLength = '8')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($minCredLength)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $minCredLength, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->minCredLength = $minCredLength;
        return $this;
    }
    /**
     * Get prevCredStoredNum value
     * @return string
     */
    public function getPrevCredStoredNum()
    {
        return $this->prevCredStoredNum;
    }
    /**
     * Set prevCredStoredNum value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $prevCredStoredNum
     * @return XCredentialPolicy
     */
    public function setPrevCredStoredNum($prevCredStoredNum = '12')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($prevCredStoredNum)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $prevCredStoredNum, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->prevCredStoredNum = $prevCredStoredNum;
        return $this;
    }
    /**
     * Get inactiveDaysAllowed value
     * @return string
     */
    public function getInactiveDaysAllowed()
    {
        return $this->inactiveDaysAllowed;
    }
    /**
     * Set inactiveDaysAllowed value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inactiveDaysAllowed
     * @return XCredentialPolicy
     */
    public function setInactiveDaysAllowed($inactiveDaysAllowed = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($inactiveDaysAllowed)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $inactiveDaysAllowed, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->inactiveDaysAllowed = $inactiveDaysAllowed;
        return $this;
    }
    /**
     * Get expiryWarningDays value
     * @return string
     */
    public function getExpiryWarningDays()
    {
        return $this->expiryWarningDays;
    }
    /**
     * Set expiryWarningDays value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expiryWarningDays
     * @return XCredentialPolicy
     */
    public function setExpiryWarningDays($expiryWarningDays = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($expiryWarningDays)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $expiryWarningDays, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->expiryWarningDays = $expiryWarningDays;
        return $this;
    }
    /**
     * Get trivialCredCheck value
     * @return string
     */
    public function getTrivialCredCheck()
    {
        return $this->trivialCredCheck;
    }
    /**
     * Set trivialCredCheck value
     * @param string $trivialCredCheck
     * @return XCredentialPolicy
     */
    public function setTrivialCredCheck($trivialCredCheck = true)
    {
        // validation for constraint: pattern
        if (is_scalar($trivialCredCheck) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $trivialCredCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($trivialCredCheck, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($trivialCredCheck) && !is_string($trivialCredCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trivialCredCheck)), __LINE__);
        }
        $this->trivialCredCheck = $trivialCredCheck;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XCredentialPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
