<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XConferenceBridge StructType
 * @subpackage Structs
 */
class XConferenceBridge extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - default: Hub_None
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $locationName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The subUnit
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: Applicable for Cisco Conference Bridge (WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values range from 1 to 4.The value should be given as per the formula. Cisco Media Server : subunit = ((Extract two digits after 'A'
     * from the name)-2)/3 + 1. Cisco Conference Bridge: subunit = ((Extract two digits after 'C' from the name)-1)/3 + 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subUnit;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - documentation: This tag is used only by Cisco Conference Bridge Hardware.For devices with load information, if any special load information is specified, the special attribute is set to TRUE. Otherwise, the load information is the default for the
     * product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - documentation: This tag is used only by Cisco Video Conference Bridge(IPVC-35xx),Cisco Conference Bridge (WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XVendorConfig
     */
    public $vendorConfig;
    /**
     * The maximumCapacity
     * Meta informations extracted from the WSDL
     * - documentation: This tag is mandatory for Cisco Conference Bridge(WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values for this tag are 32,64,96,128.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maximumCapacity;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco IOS Enhanced Conference Bridge
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $securityProfileName;
    /**
     * The destinationAddress
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $destinationAddress;
    /**
     * The mcuConferenceBridgeSipPort
     * Meta informations extracted from the WSDL
     * - default: 5060
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mcuConferenceBridgeSipPort;
    /**
     * The sipProfile
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $sipProfile;
    /**
     * The srtpAllowed
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The normalizationScript
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $normalizationScript;
    /**
     * The enableTrace
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTrace;
    /**
     * The normalizationScriptInfos
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var NormalizationScriptInfos
     */
    public $normalizationScriptInfos;
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * The httpPort
     * Meta informations extracted from the WSDL
     * - default: 80
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $httpPort;
    /**
     * The useHttps
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useHttps;
    /**
     * The addresses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Addresses
     */
    public $addresses;
    /**
     * The conferenceBridgePrefix
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $conferenceBridgePrefix;
    /**
     * The overrideSIPTrunkAddress
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $overrideSIPTrunkAddress;
    /**
     * The sipTrunkName
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $sipTrunkName;
    /**
     * Constructor method for XConferenceBridge
     * @uses XConferenceBridge::setName()
     * @uses XConferenceBridge::setProduct()
     * @uses XConferenceBridge::setDevicePoolName()
     * @uses XConferenceBridge::setLocationName()
     * @uses XConferenceBridge::setDescription()
     * @uses XConferenceBridge::setCommonDeviceConfigName()
     * @uses XConferenceBridge::setSubUnit()
     * @uses XConferenceBridge::setLoadInformation()
     * @uses XConferenceBridge::setVendorConfig()
     * @uses XConferenceBridge::setMaximumCapacity()
     * @uses XConferenceBridge::setUseTrustedRelayPoint()
     * @uses XConferenceBridge::setSecurityProfileName()
     * @uses XConferenceBridge::setDestinationAddress()
     * @uses XConferenceBridge::setMcuConferenceBridgeSipPort()
     * @uses XConferenceBridge::setSipProfile()
     * @uses XConferenceBridge::setSrtpAllowed()
     * @uses XConferenceBridge::setNormalizationScript()
     * @uses XConferenceBridge::setEnableTrace()
     * @uses XConferenceBridge::setNormalizationScriptInfos()
     * @uses XConferenceBridge::setUserName()
     * @uses XConferenceBridge::setPassword()
     * @uses XConferenceBridge::setHttpPort()
     * @uses XConferenceBridge::setUseHttps()
     * @uses XConferenceBridge::setAddresses()
     * @uses XConferenceBridge::setConferenceBridgePrefix()
     * @uses XConferenceBridge::setOverrideSIPTrunkAddress()
     * @uses XConferenceBridge::setSipTrunkName()
     * @param string $name
     * @param string $product
     * @param XFkType $devicePoolName
     * @param XFkType $locationName
     * @param string $description
     * @param XFkType $commonDeviceConfigName
     * @param string $subUnit
     * @param XLoadInformation $loadInformation
     * @param XVendorConfig $vendorConfig
     * @param string $maximumCapacity
     * @param string $useTrustedRelayPoint
     * @param XFkType $securityProfileName
     * @param string $destinationAddress
     * @param string $mcuConferenceBridgeSipPort
     * @param XFkType $sipProfile
     * @param string $srtpAllowed
     * @param XFkType $normalizationScript
     * @param string $enableTrace
     * @param NormalizationScriptInfos $normalizationScriptInfos
     * @param string $userName
     * @param string $password
     * @param string $httpPort
     * @param string $useHttps
     * @param Addresses $addresses
     * @param string $conferenceBridgePrefix
     * @param string $overrideSIPTrunkAddress
     * @param XFkType $sipTrunkName
     */
    public function __construct($name = null, $product = null, XFkType $devicePoolName = null, XFkType $locationName = 'Hub_None', $description = null, XFkType $commonDeviceConfigName = null, $subUnit = '0', XLoadInformation $loadInformation = null, XVendorConfig $vendorConfig = null, $maximumCapacity = null, $useTrustedRelayPoint = 'Default', XFkType $securityProfileName = null, $destinationAddress = null, $mcuConferenceBridgeSipPort = '5060', XFkType $sipProfile = null, $srtpAllowed = null, XFkType $normalizationScript = null, $enableTrace = null, NormalizationScriptInfos $normalizationScriptInfos = null, $userName = null, $password = null, $httpPort = '80', $useHttps = false, Addresses $addresses = null, $conferenceBridgePrefix = null, $overrideSIPTrunkAddress = false, XFkType $sipTrunkName = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setDescription($description)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setSubUnit($subUnit)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setMaximumCapacity($maximumCapacity)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setDestinationAddress($destinationAddress)
            ->setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort)
            ->setSipProfile($sipProfile)
            ->setSrtpAllowed($srtpAllowed)
            ->setNormalizationScript($normalizationScript)
            ->setEnableTrace($enableTrace)
            ->setNormalizationScriptInfos($normalizationScriptInfos)
            ->setUserName($userName)
            ->setPassword($password)
            ->setHttpPort($httpPort)
            ->setUseHttps($useHttps)
            ->setAddresses($addresses)
            ->setConferenceBridgePrefix($conferenceBridgePrefix)
            ->setOverrideSIPTrunkAddress($overrideSIPTrunkAddress)
            ->setSipTrunkName($sipTrunkName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XConferenceBridge
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return XConferenceBridge
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return XConferenceBridge
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return XConferenceBridge
     */
    public function setLocationName(XFkType $locationName = 'Hub_None')
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XConferenceBridge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $commonDeviceConfigName
     * @return XConferenceBridge
     */
    public function setCommonDeviceConfigName(XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get subUnit value
     * @return string|null
     */
    public function getSubUnit()
    {
        return $this->subUnit;
    }
    /**
     * Set subUnit value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subUnit
     * @return XConferenceBridge
     */
    public function setSubUnit($subUnit = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($subUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subUnit, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->subUnit = $subUnit;
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XLoadInformation $loadInformation
     * @return XConferenceBridge
     */
    public function setLoadInformation(XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param XVendorConfig $vendorConfig
     * @return XConferenceBridge
     */
    public function setVendorConfig(XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get maximumCapacity value
     * @return string|null
     */
    public function getMaximumCapacity()
    {
        return $this->maximumCapacity;
    }
    /**
     * Set maximumCapacity value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maximumCapacity
     * @return XConferenceBridge
     */
    public function setMaximumCapacity($maximumCapacity = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maximumCapacity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maximumCapacity, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maximumCapacity = $maximumCapacity;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return XConferenceBridge
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSecurityProfileName()
    {
        return isset($this->securityProfileName) ? $this->securityProfileName : null;
    }
    /**
     * Set securityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $securityProfileName
     * @return XConferenceBridge
     */
    public function setSecurityProfileName(XFkType $securityProfileName = null)
    {
        if (is_null($securityProfileName) || (is_array($securityProfileName) && empty($securityProfileName))) {
            unset($this->securityProfileName);
        } else {
            $this->securityProfileName = $securityProfileName;
        }
        return $this;
    }
    /**
     * Get destinationAddress value
     * @return string|null
     */
    public function getDestinationAddress()
    {
        return $this->destinationAddress;
    }
    /**
     * Set destinationAddress value
     * @param string $destinationAddress
     * @return XConferenceBridge
     */
    public function setDestinationAddress($destinationAddress = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAddress) && !is_string($destinationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationAddress)), __LINE__);
        }
        $this->destinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get mcuConferenceBridgeSipPort value
     * @return string|null
     */
    public function getMcuConferenceBridgeSipPort()
    {
        return $this->mcuConferenceBridgeSipPort;
    }
    /**
     * Set mcuConferenceBridgeSipPort value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mcuConferenceBridgeSipPort
     * @return XConferenceBridge
     */
    public function setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort = '5060')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($mcuConferenceBridgeSipPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mcuConferenceBridgeSipPort, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->mcuConferenceBridgeSipPort = $mcuConferenceBridgeSipPort;
        return $this;
    }
    /**
     * Get sipProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSipProfile()
    {
        return isset($this->sipProfile) ? $this->sipProfile : null;
    }
    /**
     * Set sipProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $sipProfile
     * @return XConferenceBridge
     */
    public function setSipProfile(XFkType $sipProfile = null)
    {
        if (is_null($sipProfile) || (is_array($sipProfile) && empty($sipProfile))) {
            unset($this->sipProfile);
        } else {
            $this->sipProfile = $sipProfile;
        }
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return XConferenceBridge
     */
    public function setSrtpAllowed($srtpAllowed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($srtpAllowed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srtpAllowed)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get normalizationScript value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getNormalizationScript()
    {
        return isset($this->normalizationScript) ? $this->normalizationScript : null;
    }
    /**
     * Set normalizationScript value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $normalizationScript
     * @return XConferenceBridge
     */
    public function setNormalizationScript(XFkType $normalizationScript = null)
    {
        if (is_null($normalizationScript) || (is_array($normalizationScript) && empty($normalizationScript))) {
            unset($this->normalizationScript);
        } else {
            $this->normalizationScript = $normalizationScript;
        }
        return $this;
    }
    /**
     * Get enableTrace value
     * @return string|null
     */
    public function getEnableTrace()
    {
        return $this->enableTrace;
    }
    /**
     * Set enableTrace value
     * @param string $enableTrace
     * @return XConferenceBridge
     */
    public function setEnableTrace($enableTrace = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableTrace) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableTrace, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableTrace) && !is_string($enableTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableTrace)), __LINE__);
        }
        $this->enableTrace = $enableTrace;
        return $this;
    }
    /**
     * Get normalizationScriptInfos value
     * @return NormalizationScriptInfos|null
     */
    public function getNormalizationScriptInfos()
    {
        return $this->normalizationScriptInfos;
    }
    /**
     * Set normalizationScriptInfos value
     * @param NormalizationScriptInfos $normalizationScriptInfos
     * @return XConferenceBridge
     */
    public function setNormalizationScriptInfos(NormalizationScriptInfos $normalizationScriptInfos = null)
    {
        $this->normalizationScriptInfos = $normalizationScriptInfos;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return XConferenceBridge
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return XConferenceBridge
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get httpPort value
     * @return string|null
     */
    public function getHttpPort()
    {
        return $this->httpPort;
    }
    /**
     * Set httpPort value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $httpPort
     * @return XConferenceBridge
     */
    public function setHttpPort($httpPort = '80')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($httpPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $httpPort, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->httpPort = $httpPort;
        return $this;
    }
    /**
     * Get useHttps value
     * @return string|null
     */
    public function getUseHttps()
    {
        return $this->useHttps;
    }
    /**
     * Set useHttps value
     * @param string $useHttps
     * @return XConferenceBridge
     */
    public function setUseHttps($useHttps = false)
    {
        // validation for constraint: pattern
        if (is_scalar($useHttps) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useHttps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useHttps, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useHttps) && !is_string($useHttps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useHttps)), __LINE__);
        }
        $this->useHttps = $useHttps;
        return $this;
    }
    /**
     * Get addresses value
     * @return Addresses|null
     */
    public function getAddresses()
    {
        return $this->addresses;
    }
    /**
     * Set addresses value
     * @param Addresses $addresses
     * @return XConferenceBridge
     */
    public function setAddresses(Addresses $addresses = null)
    {
        $this->addresses = $addresses;
        return $this;
    }
    /**
     * Get conferenceBridgePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConferenceBridgePrefix()
    {
        return isset($this->conferenceBridgePrefix) ? $this->conferenceBridgePrefix : null;
    }
    /**
     * Set conferenceBridgePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conferenceBridgePrefix
     * @return XConferenceBridge
     */
    public function setConferenceBridgePrefix($conferenceBridgePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($conferenceBridgePrefix) && !is_string($conferenceBridgePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conferenceBridgePrefix)), __LINE__);
        }
        if (is_null($conferenceBridgePrefix) || (is_array($conferenceBridgePrefix) && empty($conferenceBridgePrefix))) {
            unset($this->conferenceBridgePrefix);
        } else {
            $this->conferenceBridgePrefix = $conferenceBridgePrefix;
        }
        return $this;
    }
    /**
     * Get overrideSIPTrunkAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverrideSIPTrunkAddress()
    {
        return isset($this->overrideSIPTrunkAddress) ? $this->overrideSIPTrunkAddress : null;
    }
    /**
     * Set overrideSIPTrunkAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $overrideSIPTrunkAddress
     * @return XConferenceBridge
     */
    public function setOverrideSIPTrunkAddress($overrideSIPTrunkAddress = false)
    {
        // validation for constraint: pattern
        if (is_scalar($overrideSIPTrunkAddress) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $overrideSIPTrunkAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($overrideSIPTrunkAddress, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($overrideSIPTrunkAddress) && !is_string($overrideSIPTrunkAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overrideSIPTrunkAddress)), __LINE__);
        }
        if (is_null($overrideSIPTrunkAddress) || (is_array($overrideSIPTrunkAddress) && empty($overrideSIPTrunkAddress))) {
            unset($this->overrideSIPTrunkAddress);
        } else {
            $this->overrideSIPTrunkAddress = $overrideSIPTrunkAddress;
        }
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param XFkType $sipTrunkName
     * @return XConferenceBridge
     */
    public function setSipTrunkName(XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XConferenceBridge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
