<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCcdAdvertisingService StructType
 * @subpackage Structs
 */
class XCcdAdvertisingService extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The hostDnGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $hostDnGroup;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The isActivated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The safSipTrunk
     * Meta informations extracted from the WSDL
     * - documentation: Either safSipTrunk, safH323Trunk or both should be configured while adding
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $safSipTrunk;
    /**
     * The safH323Trunk
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $safH323Trunk;
    /**
     * Constructor method for XCcdAdvertisingService
     * @uses XCcdAdvertisingService::setName()
     * @uses XCcdAdvertisingService::setHostDnGroup()
     * @uses XCcdAdvertisingService::setDescription()
     * @uses XCcdAdvertisingService::setIsActivated()
     * @uses XCcdAdvertisingService::setSafSipTrunk()
     * @uses XCcdAdvertisingService::setSafH323Trunk()
     * @param string $name
     * @param XFkType $hostDnGroup
     * @param string $description
     * @param string $isActivated
     * @param XFkType $safSipTrunk
     * @param XFkType $safH323Trunk
     */
    public function __construct($name = null, XFkType $hostDnGroup = null, $description = null, $isActivated = null, XFkType $safSipTrunk = null, XFkType $safH323Trunk = null)
    {
        $this
            ->setName($name)
            ->setHostDnGroup($hostDnGroup)
            ->setDescription($description)
            ->setIsActivated($isActivated)
            ->setSafSipTrunk($safSipTrunk)
            ->setSafH323Trunk($safH323Trunk);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XCcdAdvertisingService
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get hostDnGroup value
     * @return XFkType
     */
    public function getHostDnGroup()
    {
        return $this->hostDnGroup;
    }
    /**
     * Set hostDnGroup value
     * @param XFkType $hostDnGroup
     * @return XCcdAdvertisingService
     */
    public function setHostDnGroup(XFkType $hostDnGroup = null)
    {
        $this->hostDnGroup = $hostDnGroup;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XCcdAdvertisingService
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return XCcdAdvertisingService
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActivated, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get safSipTrunk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSafSipTrunk()
    {
        return isset($this->safSipTrunk) ? $this->safSipTrunk : null;
    }
    /**
     * Set safSipTrunk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $safSipTrunk
     * @return XCcdAdvertisingService
     */
    public function setSafSipTrunk(XFkType $safSipTrunk = null)
    {
        if (is_null($safSipTrunk) || (is_array($safSipTrunk) && empty($safSipTrunk))) {
            unset($this->safSipTrunk);
        } else {
            $this->safSipTrunk = $safSipTrunk;
        }
        return $this;
    }
    /**
     * Get safH323Trunk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSafH323Trunk()
    {
        return isset($this->safH323Trunk) ? $this->safH323Trunk : null;
    }
    /**
     * Set safH323Trunk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $safH323Trunk
     * @return XCcdAdvertisingService
     */
    public function setSafH323Trunk(XFkType $safH323Trunk = null)
    {
        if (is_null($safH323Trunk) || (is_array($safH323Trunk) && empty($safH323Trunk))) {
            unset($this->safH323Trunk);
        } else {
            $this->safH323Trunk = $safH323Trunk;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XCcdAdvertisingService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
