<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallsQueue StructType
 * @subpackage Structs
 */
class XCallsQueue extends AbstractStructBase
{
    /**
     * The maxCallersInQueue
     * Meta informations extracted from the WSDL
     * - default: 32
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $maxCallersInQueue;
    /**
     * The maxWaitTimeInQueue
     * Meta informations extracted from the WSDL
     * - default: 900
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $maxWaitTimeInQueue;
    /**
     * The queueFullDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $queueFullDestination;
    /**
     * The callingSearchSpacePilotQueueFull
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingSearchSpacePilotQueueFull;
    /**
     * The maxWaitTimeDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $maxWaitTimeDestination;
    /**
     * The callingSearchSpaceMaxWaitTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingSearchSpaceMaxWaitTime;
    /**
     * The noAgentDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $noAgentDestination;
    /**
     * The callingSearchSpaceNoAgent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingSearchSpaceNoAgent;
    /**
     * The networkHoldMohAudioSourceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceID;
    /**
     * Constructor method for XCallsQueue
     * @uses XCallsQueue::setMaxCallersInQueue()
     * @uses XCallsQueue::setMaxWaitTimeInQueue()
     * @uses XCallsQueue::setQueueFullDestination()
     * @uses XCallsQueue::setCallingSearchSpacePilotQueueFull()
     * @uses XCallsQueue::setMaxWaitTimeDestination()
     * @uses XCallsQueue::setCallingSearchSpaceMaxWaitTime()
     * @uses XCallsQueue::setNoAgentDestination()
     * @uses XCallsQueue::setCallingSearchSpaceNoAgent()
     * @uses XCallsQueue::setNetworkHoldMohAudioSourceID()
     * @param string $maxCallersInQueue
     * @param string $maxWaitTimeInQueue
     * @param string $queueFullDestination
     * @param XFkType $callingSearchSpacePilotQueueFull
     * @param string $maxWaitTimeDestination
     * @param XFkType $callingSearchSpaceMaxWaitTime
     * @param string $noAgentDestination
     * @param XFkType $callingSearchSpaceNoAgent
     * @param string $networkHoldMohAudioSourceID
     */
    public function __construct($maxCallersInQueue = '32', $maxWaitTimeInQueue = '900', $queueFullDestination = null, XFkType $callingSearchSpacePilotQueueFull = null, $maxWaitTimeDestination = null, XFkType $callingSearchSpaceMaxWaitTime = null, $noAgentDestination = null, XFkType $callingSearchSpaceNoAgent = null, $networkHoldMohAudioSourceID = null)
    {
        $this
            ->setMaxCallersInQueue($maxCallersInQueue)
            ->setMaxWaitTimeInQueue($maxWaitTimeInQueue)
            ->setQueueFullDestination($queueFullDestination)
            ->setCallingSearchSpacePilotQueueFull($callingSearchSpacePilotQueueFull)
            ->setMaxWaitTimeDestination($maxWaitTimeDestination)
            ->setCallingSearchSpaceMaxWaitTime($callingSearchSpaceMaxWaitTime)
            ->setNoAgentDestination($noAgentDestination)
            ->setCallingSearchSpaceNoAgent($callingSearchSpaceNoAgent)
            ->setNetworkHoldMohAudioSourceID($networkHoldMohAudioSourceID);
    }
    /**
     * Get maxCallersInQueue value
     * @return string
     */
    public function getMaxCallersInQueue()
    {
        return $this->maxCallersInQueue;
    }
    /**
     * Set maxCallersInQueue value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxCallersInQueue
     * @return XCallsQueue
     */
    public function setMaxCallersInQueue($maxCallersInQueue = '32')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxCallersInQueue)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxCallersInQueue, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxCallersInQueue = $maxCallersInQueue;
        return $this;
    }
    /**
     * Get maxWaitTimeInQueue value
     * @return string
     */
    public function getMaxWaitTimeInQueue()
    {
        return $this->maxWaitTimeInQueue;
    }
    /**
     * Set maxWaitTimeInQueue value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxWaitTimeInQueue
     * @return XCallsQueue
     */
    public function setMaxWaitTimeInQueue($maxWaitTimeInQueue = '900')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxWaitTimeInQueue)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxWaitTimeInQueue, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxWaitTimeInQueue = $maxWaitTimeInQueue;
        return $this;
    }
    /**
     * Get queueFullDestination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueueFullDestination()
    {
        return isset($this->queueFullDestination) ? $this->queueFullDestination : null;
    }
    /**
     * Set queueFullDestination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queueFullDestination
     * @return XCallsQueue
     */
    public function setQueueFullDestination($queueFullDestination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($queueFullDestination) && strlen($queueFullDestination) > 50) || (is_array($queueFullDestination) && count($queueFullDestination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($queueFullDestination) ? strlen($queueFullDestination) : count($queueFullDestination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($queueFullDestination) && !is_string($queueFullDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueFullDestination)), __LINE__);
        }
        if (is_null($queueFullDestination) || (is_array($queueFullDestination) && empty($queueFullDestination))) {
            unset($this->queueFullDestination);
        } else {
            $this->queueFullDestination = $queueFullDestination;
        }
        return $this;
    }
    /**
     * Get callingSearchSpacePilotQueueFull value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingSearchSpacePilotQueueFull()
    {
        return isset($this->callingSearchSpacePilotQueueFull) ? $this->callingSearchSpacePilotQueueFull : null;
    }
    /**
     * Set callingSearchSpacePilotQueueFull value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingSearchSpacePilotQueueFull
     * @return XCallsQueue
     */
    public function setCallingSearchSpacePilotQueueFull(XFkType $callingSearchSpacePilotQueueFull = null)
    {
        if (is_null($callingSearchSpacePilotQueueFull) || (is_array($callingSearchSpacePilotQueueFull) && empty($callingSearchSpacePilotQueueFull))) {
            unset($this->callingSearchSpacePilotQueueFull);
        } else {
            $this->callingSearchSpacePilotQueueFull = $callingSearchSpacePilotQueueFull;
        }
        return $this;
    }
    /**
     * Get maxWaitTimeDestination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxWaitTimeDestination()
    {
        return isset($this->maxWaitTimeDestination) ? $this->maxWaitTimeDestination : null;
    }
    /**
     * Set maxWaitTimeDestination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maxWaitTimeDestination
     * @return XCallsQueue
     */
    public function setMaxWaitTimeDestination($maxWaitTimeDestination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($maxWaitTimeDestination) && strlen($maxWaitTimeDestination) > 50) || (is_array($maxWaitTimeDestination) && count($maxWaitTimeDestination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($maxWaitTimeDestination) ? strlen($maxWaitTimeDestination) : count($maxWaitTimeDestination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($maxWaitTimeDestination) && !is_string($maxWaitTimeDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxWaitTimeDestination)), __LINE__);
        }
        if (is_null($maxWaitTimeDestination) || (is_array($maxWaitTimeDestination) && empty($maxWaitTimeDestination))) {
            unset($this->maxWaitTimeDestination);
        } else {
            $this->maxWaitTimeDestination = $maxWaitTimeDestination;
        }
        return $this;
    }
    /**
     * Get callingSearchSpaceMaxWaitTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingSearchSpaceMaxWaitTime()
    {
        return isset($this->callingSearchSpaceMaxWaitTime) ? $this->callingSearchSpaceMaxWaitTime : null;
    }
    /**
     * Set callingSearchSpaceMaxWaitTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingSearchSpaceMaxWaitTime
     * @return XCallsQueue
     */
    public function setCallingSearchSpaceMaxWaitTime(XFkType $callingSearchSpaceMaxWaitTime = null)
    {
        if (is_null($callingSearchSpaceMaxWaitTime) || (is_array($callingSearchSpaceMaxWaitTime) && empty($callingSearchSpaceMaxWaitTime))) {
            unset($this->callingSearchSpaceMaxWaitTime);
        } else {
            $this->callingSearchSpaceMaxWaitTime = $callingSearchSpaceMaxWaitTime;
        }
        return $this;
    }
    /**
     * Get noAgentDestination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNoAgentDestination()
    {
        return isset($this->noAgentDestination) ? $this->noAgentDestination : null;
    }
    /**
     * Set noAgentDestination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $noAgentDestination
     * @return XCallsQueue
     */
    public function setNoAgentDestination($noAgentDestination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($noAgentDestination) && strlen($noAgentDestination) > 50) || (is_array($noAgentDestination) && count($noAgentDestination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($noAgentDestination) ? strlen($noAgentDestination) : count($noAgentDestination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noAgentDestination) && !is_string($noAgentDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noAgentDestination)), __LINE__);
        }
        if (is_null($noAgentDestination) || (is_array($noAgentDestination) && empty($noAgentDestination))) {
            unset($this->noAgentDestination);
        } else {
            $this->noAgentDestination = $noAgentDestination;
        }
        return $this;
    }
    /**
     * Get callingSearchSpaceNoAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingSearchSpaceNoAgent()
    {
        return isset($this->callingSearchSpaceNoAgent) ? $this->callingSearchSpaceNoAgent : null;
    }
    /**
     * Set callingSearchSpaceNoAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingSearchSpaceNoAgent
     * @return XCallsQueue
     */
    public function setCallingSearchSpaceNoAgent(XFkType $callingSearchSpaceNoAgent = null)
    {
        if (is_null($callingSearchSpaceNoAgent) || (is_array($callingSearchSpaceNoAgent) && empty($callingSearchSpaceNoAgent))) {
            unset($this->callingSearchSpaceNoAgent);
        } else {
            $this->callingSearchSpaceNoAgent = $callingSearchSpaceNoAgent;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceID()
    {
        return isset($this->networkHoldMohAudioSourceID) ? $this->networkHoldMohAudioSourceID : null;
    }
    /**
     * Set networkHoldMohAudioSourceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceID
     * @return XCallsQueue
     */
    public function setNetworkHoldMohAudioSourceID($networkHoldMohAudioSourceID = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($networkHoldMohAudioSourceID)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceID, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($networkHoldMohAudioSourceID) || (is_array($networkHoldMohAudioSourceID) && empty($networkHoldMohAudioSourceID))) {
            unset($this->networkHoldMohAudioSourceID);
        } else {
            $this->networkHoldMohAudioSourceID = $networkHoldMohAudioSourceID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XCallsQueue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
