<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallManagerMember StructType
 * @subpackage Structs
 */
class XCallManagerMember extends AbstractStructBase
{
    /**
     * The callManagerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $callManagerName;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $priority;
    /**
     * Constructor method for XCallManagerMember
     * @uses XCallManagerMember::setCallManagerName()
     * @uses XCallManagerMember::setPriority()
     * @param XFkType $callManagerName
     * @param string $priority
     */
    public function __construct(XFkType $callManagerName = null, $priority = null)
    {
        $this
            ->setCallManagerName($callManagerName)
            ->setPriority($priority);
    }
    /**
     * Get callManagerName value
     * @return XFkType
     */
    public function getCallManagerName()
    {
        return $this->callManagerName;
    }
    /**
     * Set callManagerName value
     * @param XFkType $callManagerName
     * @return XCallManagerMember
     */
    public function setCallManagerName(XFkType $callManagerName = null)
    {
        $this->callManagerName = $callManagerName;
        return $this;
    }
    /**
     * Get priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return XCallManagerMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XCallManagerMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
