<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallForwardBusyInt StructType
 * @subpackage Structs
 */
class XCallForwardBusyInt extends AbstractStructBase
{
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The forwardToVoiceMail
     * Meta informations extracted from the WSDL
     * - documentation: DB: Derived from CF*VoiceMailEnabled fields. This tag has been marked as ReadOnly for callForwardAlternateParty as it is not applicable for callForwardAlternateParty setting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $forwardToVoiceMail;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $destination;
    /**
     * Constructor method for XCallForwardBusyInt
     * @uses XCallForwardBusyInt::setCallingSearchSpaceName()
     * @uses XCallForwardBusyInt::setForwardToVoiceMail()
     * @uses XCallForwardBusyInt::setDestination()
     * @param XFkType $callingSearchSpaceName
     * @param string $forwardToVoiceMail
     * @param string $destination
     */
    public function __construct(XFkType $callingSearchSpaceName = null, $forwardToVoiceMail = null, $destination = null)
    {
        $this
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setForwardToVoiceMail($forwardToVoiceMail)
            ->setDestination($destination);
    }
    /**
     * Get callingSearchSpaceName value
     * @return XFkType
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param XFkType $callingSearchSpaceName
     * @return XCallForwardBusyInt
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get forwardToVoiceMail value
     * @return string|null
     */
    public function getForwardToVoiceMail()
    {
        return $this->forwardToVoiceMail;
    }
    /**
     * Set forwardToVoiceMail value
     * @param string $forwardToVoiceMail
     * @return XCallForwardBusyInt
     */
    public function setForwardToVoiceMail($forwardToVoiceMail = null)
    {
        // validation for constraint: pattern
        if (is_scalar($forwardToVoiceMail) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($forwardToVoiceMail, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($forwardToVoiceMail) && !is_string($forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forwardToVoiceMail)), __LINE__);
        }
        $this->forwardToVoiceMail = $forwardToVoiceMail;
        return $this;
    }
    /**
     * Get destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->destination) ? $this->destination : null;
    }
    /**
     * Set destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return XCallForwardBusyInt
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($destination) && strlen($destination) > 50) || (is_array($destination) && count($destination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($destination) ? strlen($destination) : count($destination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->destination);
        } else {
            $this->destination = $destination;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XCallForwardBusyInt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
