<?php
/**
 * This class stands for XCUCMVersionInSipHeader EnumType
 * @subpackage Enumerations
 */
class XCUCMVersionInSipHeader
{
    /**
     * Constant for value 'Major And Minor'
     * @return string 'Major And Minor'
     */
    const VALUE_MAJOR_AND_MINOR = 'Major And Minor';
    /**
     * Constant for value 'Major'
     * @return string 'Major'
     */
    const VALUE_MAJOR = 'Major';
    /**
     * Constant for value 'Major, Minor And Revision'
     * @return string 'Major, Minor And Revision'
     */
    const VALUE_MAJOR_MINOR_AND_REVISION = 'Major, Minor And Revision';
    /**
     * Constant for value 'Full Build'
     * @return string 'Full Build'
     */
    const VALUE_FULL_BUILD = 'Full Build';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MAJOR_AND_MINOR
     * @uses self::VALUE_MAJOR
     * @uses self::VALUE_MAJOR_MINOR_AND_REVISION
     * @uses self::VALUE_FULL_BUILD
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MAJOR_AND_MINOR,
            self::VALUE_MAJOR,
            self::VALUE_MAJOR_MINOR_AND_REVISION,
            self::VALUE_FULL_BUILD,
            self::VALUE_NONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
