<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XButton StructType
 * @subpackage Structs
 */
class XButton extends AbstractStructBase
{
    /**
     * The feature
     * Meta informations extracted from the WSDL
     * - documentation: The feature invoked by this button.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $feature;
    /**
     * The buttonNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $buttonNumber;
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - documentation: The label invoked by this button.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $label;
    /**
     * Constructor method for XButton
     * @uses XButton::setFeature()
     * @uses XButton::setButtonNumber()
     * @uses XButton::setLabel()
     * @param string $feature
     * @param string $buttonNumber
     * @param string $label
     */
    public function __construct($feature = null, $buttonNumber = null, $label = null)
    {
        $this
            ->setFeature($feature)
            ->setButtonNumber($buttonNumber)
            ->setLabel($label);
    }
    /**
     * Get feature value
     * @return string
     */
    public function getFeature()
    {
        return $this->feature;
    }
    /**
     * Set feature value
     * @uses XFeature::valueIsValid()
     * @uses XFeature::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $feature
     * @return XButton
     */
    public function setFeature($feature = null)
    {
        // validation for constraint: enumeration
        if (!XFeature::valueIsValid($feature)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $feature, implode(', ', XFeature::getValidValues())), __LINE__);
        }
        $this->feature = $feature;
        return $this;
    }
    /**
     * Get buttonNumber value
     * @return string
     */
    public function getButtonNumber()
    {
        return $this->buttonNumber;
    }
    /**
     * Set buttonNumber value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $buttonNumber
     * @return XButton
     */
    public function setButtonNumber($buttonNumber = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($buttonNumber)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $buttonNumber, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->buttonNumber = $buttonNumber;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return XButton
     */
    public function setLabel($label = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($label) && strlen($label) > 50) || (is_array($label) && count($label) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($label) ? strlen($label) : count($label)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XButton
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
