<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XApplicationServer StructType
 * @subpackage Structs
 */
class XApplicationServer extends AbstractStructBase
{
    /**
     * The appServerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $appServerType;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - documentation: Applicable for Cisco Unity Voice Mail 4.x or later, Cisco Unity Connection and Cisco Web Dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The appUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AppUsers
     */
    public $appUsers;
    /**
     * The url
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $url;
    /**
     * The endUserUrl
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server, CER Location Management
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endUserUrl;
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - documentation: Applicable Only for Cisco Web dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $processNodeName;
    /**
     * The endUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var EndUsers
     */
    public $endUsers;
    /**
     * Constructor method for XApplicationServer
     * @uses XApplicationServer::setAppServerType()
     * @uses XApplicationServer::setName()
     * @uses XApplicationServer::setIpAddress()
     * @uses XApplicationServer::setAppUsers()
     * @uses XApplicationServer::setUrl()
     * @uses XApplicationServer::setEndUserUrl()
     * @uses XApplicationServer::setProcessNodeName()
     * @uses XApplicationServer::setEndUsers()
     * @param string $appServerType
     * @param string $name
     * @param string $ipAddress
     * @param AppUsers $appUsers
     * @param string $url
     * @param string $endUserUrl
     * @param XFkType $processNodeName
     * @param EndUsers $endUsers
     */
    public function __construct($appServerType = null, $name = null, $ipAddress = null, AppUsers $appUsers = null, $url = null, $endUserUrl = null, XFkType $processNodeName = null, EndUsers $endUsers = null)
    {
        $this
            ->setAppServerType($appServerType)
            ->setName($name)
            ->setIpAddress($ipAddress)
            ->setAppUsers($appUsers)
            ->setUrl($url)
            ->setEndUserUrl($endUserUrl)
            ->setProcessNodeName($processNodeName)
            ->setEndUsers($endUsers);
    }
    /**
     * Get appServerType value
     * @return string
     */
    public function getAppServerType()
    {
        return $this->appServerType;
    }
    /**
     * Set appServerType value
     * @uses XAppServer::valueIsValid()
     * @uses XAppServer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appServerType
     * @return XApplicationServer
     */
    public function setAppServerType($appServerType = null)
    {
        // validation for constraint: enumeration
        if (!XAppServer::valueIsValid($appServerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $appServerType, implode(', ', XAppServer::getValidValues())), __LINE__);
        }
        $this->appServerType = $appServerType;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XApplicationServer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return XApplicationServer
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get appUsers value
     * @return AppUsers|null
     */
    public function getAppUsers()
    {
        return $this->appUsers;
    }
    /**
     * Set appUsers value
     * @param AppUsers $appUsers
     * @return XApplicationServer
     */
    public function setAppUsers(AppUsers $appUsers = null)
    {
        $this->appUsers = $appUsers;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return XApplicationServer
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get endUserUrl value
     * @return string|null
     */
    public function getEndUserUrl()
    {
        return $this->endUserUrl;
    }
    /**
     * Set endUserUrl value
     * @param string $endUserUrl
     * @return XApplicationServer
     */
    public function setEndUserUrl($endUserUrl = null)
    {
        // validation for constraint: string
        if (!is_null($endUserUrl) && !is_string($endUserUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endUserUrl)), __LINE__);
        }
        $this->endUserUrl = $endUserUrl;
        return $this;
    }
    /**
     * Get processNodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getProcessNodeName()
    {
        return isset($this->processNodeName) ? $this->processNodeName : null;
    }
    /**
     * Set processNodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $processNodeName
     * @return XApplicationServer
     */
    public function setProcessNodeName(XFkType $processNodeName = null)
    {
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->processNodeName);
        } else {
            $this->processNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get endUsers value
     * @return EndUsers|null
     */
    public function getEndUsers()
    {
        return $this->endUsers;
    }
    /**
     * Set endUsers value
     * @param EndUsers $endUsers
     * @return XApplicationServer
     */
    public function setEndUsers(EndUsers $endUsers = null)
    {
        $this->endUsers = $endUsers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XApplicationServer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
