<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAarGroupRelationship StructType
 * @subpackage Structs
 */
class XAarGroupRelationship extends AbstractStructBase
{
    /**
     * The aarGroupFromName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $aarGroupFromName;
    /**
     * The aarGroupToName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $aarGroupToName;
    /**
     * The prefixDigit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 32
     * @var string
     */
    public $prefixDigit;
    /**
     * Constructor method for XAarGroupRelationship
     * @uses XAarGroupRelationship::setAarGroupFromName()
     * @uses XAarGroupRelationship::setAarGroupToName()
     * @uses XAarGroupRelationship::setPrefixDigit()
     * @param XFkType $aarGroupFromName
     * @param XFkType $aarGroupToName
     * @param string $prefixDigit
     */
    public function __construct(XFkType $aarGroupFromName = null, XFkType $aarGroupToName = null, $prefixDigit = null)
    {
        $this
            ->setAarGroupFromName($aarGroupFromName)
            ->setAarGroupToName($aarGroupToName)
            ->setPrefixDigit($prefixDigit);
    }
    /**
     * Get aarGroupFromName value
     * @return XFkType
     */
    public function getAarGroupFromName()
    {
        return $this->aarGroupFromName;
    }
    /**
     * Set aarGroupFromName value
     * @param XFkType $aarGroupFromName
     * @return XAarGroupRelationship
     */
    public function setAarGroupFromName(XFkType $aarGroupFromName = null)
    {
        $this->aarGroupFromName = $aarGroupFromName;
        return $this;
    }
    /**
     * Get aarGroupToName value
     * @return XFkType
     */
    public function getAarGroupToName()
    {
        return $this->aarGroupToName;
    }
    /**
     * Set aarGroupToName value
     * @param XFkType $aarGroupToName
     * @return XAarGroupRelationship
     */
    public function setAarGroupToName(XFkType $aarGroupToName = null)
    {
        $this->aarGroupToName = $aarGroupToName;
        return $this;
    }
    /**
     * Get prefixDigit value
     * @return string
     */
    public function getPrefixDigit()
    {
        return $this->prefixDigit;
    }
    /**
     * Set prefixDigit value
     * @param string $prefixDigit
     * @return XAarGroupRelationship
     */
    public function setPrefixDigit($prefixDigit = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDigit) && strlen($prefixDigit) > 32) || (is_array($prefixDigit) && count($prefixDigit) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($prefixDigit) ? strlen($prefixDigit) : count($prefixDigit)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDigit) && !is_string($prefixDigit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDigit)), __LINE__);
        }
        $this->prefixDigit = $prefixDigit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XAarGroupRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
