<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUniversalDeviceTemplateReq StructType
 * @subpackage Structs
 */
class UpdateUniversalDeviceTemplateReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The deviceDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $deviceDescription;
    /**
     * The devicePool
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $devicePool;
    /**
     * The deviceSecurityProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $deviceSecurityProfile;
    /**
     * The sipProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $sipProfile;
    /**
     * The phoneButtonTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $phoneButtonTemplate;
    /**
     * The sipDialRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $sipDialRules;
    /**
     * The callingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingSearchSpace;
    /**
     * The callingPartyTransformationCSSForInboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingPartyTransformationCSSForInboundCalls;
    /**
     * The callingPartyTransformationCSSForOutboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingPartyTransformationCSSForOutboundCalls;
    /**
     * The reroutingCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $reroutingCallingSearchSpace;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCallingPartyTransformationCSSforInboundCalls;
    /**
     * The useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
    /**
     * The commonPhoneProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $commonPhoneProfile;
    /**
     * The commonDeviceConfiguration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $commonDeviceConfiguration;
    /**
     * The softkeyTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $softkeyTemplate;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $featureControlPolicy;
    /**
     * The phonePersonalization
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $phonePersonalization;
    /**
     * The mtpPreferredOriginatingCodec
     * Meta informations extracted from the WSDL
     * - default: 711ulaw
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mtpPreferredOriginatingCodec;
    /**
     * The outboundCallRollover
     * Meta informations extracted from the WSDL
     * - default: No Rollover
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $outboundCallRollover;
    /**
     * The mediaTerminationPointRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mediaTerminationPointRequired;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The requiredDtmfReception
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requiredDtmfReception;
    /**
     * The rfc2833Disabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2833Disabled;
    /**
     * The speeddials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Speeddials
     */
    public $speeddials;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The protectedDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $protectedDevice;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - default: By Null String
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The authenticationString
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationString;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - default: 1024
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The servicesProvisioning
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $servicesProvisioning;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The secureShellUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureShellUser;
    /**
     * The secureShellPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureShellPassword;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The mlppDomain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $mlppDomain;
    /**
     * The mlppIndication
     * Meta informations extracted from the WSDL
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndication;
    /**
     * The mlppPreemption
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppPreemption;
    /**
     * The doNotDisturb
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $doNotDisturb;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - default: Ringer Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndOption;
    /**
     * The dndIncomingCallAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dndIncomingCallAlert;
    /**
     * The aarGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $aarGroup;
    /**
     * The aarCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $aarCallingSearchSpace;
    /**
     * The blfPresenceGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $blfPresenceGroup;
    /**
     * The blfAudibleAlertSettingPhoneBusy
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $blfAudibleAlertSettingPhoneBusy;
    /**
     * The blfAudibleAlertSettingPhoneIdle
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $blfAudibleAlertSettingPhoneIdle;
    /**
     * The userHoldMohAudioSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSource;
    /**
     * The networkHoldMohAudioSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSource;
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $location;
    /**
     * The geoLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $geoLocation;
    /**
     * The deviceMobilityMode
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $deviceMobilityMode;
    /**
     * The mediaResourceGroupList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $mediaResourceGroupList;
    /**
     * The remoteDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The hotlineDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The requireOffPremiseLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireOffPremiseLocation;
    /**
     * The ownerUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $ownerUserId;
    /**
     * The mobilityUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $mobilityUserId;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The builtInBridge
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $builtInBridge;
    /**
     * The allowControlOfDeviceFromCti
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowControlOfDeviceFromCti;
    /**
     * The ignorePresentationIndicators
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The enableExtensionMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The recordingOptions
     * Meta informations extracted from the WSDL
     * - default: Call Recording Disabled
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $recordingOptions;
    /**
     * The privacy
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $privacy;
    /**
     * The loggedIntoHuntGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $loggedIntoHuntGroup;
    /**
     * The proxyServer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxyServer;
    /**
     * The servicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $servicesUrl;
    /**
     * The idle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $idle;
    /**
     * The idleTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $idleTimer;
    /**
     * The secureDirUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureDirUrl;
    /**
     * The messages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $messages;
    /**
     * The secureIdleUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureIdleUrl;
    /**
     * The authenticationServer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationServer;
    /**
     * The directory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $directory;
    /**
     * The secureServicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureServicesUrl;
    /**
     * The information
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $information;
    /**
     * The secureMessagesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureMessagesUrl;
    /**
     * The secureInformationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureInformationUrl;
    /**
     * The secureAuthenticationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureAuthenticationUrl;
    /**
     * The externalPhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $externalPhoneNumber;
    /**
     * The audibleMsgWaitingicatorPolicy
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $audibleMsgWaitingicatorPolicy;
    /**
     * The logMissedCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $logMissedCalls;
    /**
     * The visualMsgWaitingIndicatorPolicy
     * Meta informations extracted from the WSDL
     * - default: Use System Policy
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $visualMsgWaitingIndicatorPolicy;
    /**
     * The lineLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $lineLabel;
    /**
     * The displayCallerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $displayCallerId;
    /**
     * The MaxNumberOfCalls
     * Meta informations extracted from the WSDL
     * - default: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $MaxNumberOfCalls;
    /**
     * The ringSettingWhenPhoneIdle
     * Meta informations extracted from the WSDL
     * - default: Ring
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ringSettingWhenPhoneIdle;
    /**
     * The busyTrigger
     * Meta informations extracted from the WSDL
     * - default: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $busyTrigger;
    /**
     * The ringSettingWhenPhoneInUse
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ringSettingWhenPhoneInUse;
    /**
     * The directoryNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $directoryNumber;
    /**
     * The recordingProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $recordingProfile;
    /**
     * The callPickupGroupAudioAlertSettingPhoneActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callPickupGroupAudioAlertSettingPhoneActive;
    /**
     * The callPickupGroupAudioAlertSettingPhoneIdle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callPickupGroupAudioAlertSettingPhoneIdle;
    /**
     * The monitoringCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $monitoringCallingSearchSpace;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Services
     */
    public $services;
    /**
     * Constructor method for UpdateUniversalDeviceTemplateReq
     * @uses UpdateUniversalDeviceTemplateReq::setNewName()
     * @uses UpdateUniversalDeviceTemplateReq::setDeviceDescription()
     * @uses UpdateUniversalDeviceTemplateReq::setDevicePool()
     * @uses UpdateUniversalDeviceTemplateReq::setDeviceSecurityProfile()
     * @uses UpdateUniversalDeviceTemplateReq::setSipProfile()
     * @uses UpdateUniversalDeviceTemplateReq::setPhoneButtonTemplate()
     * @uses UpdateUniversalDeviceTemplateReq::setSipDialRules()
     * @uses UpdateUniversalDeviceTemplateReq::setCallingSearchSpace()
     * @uses UpdateUniversalDeviceTemplateReq::setCallingPartyTransformationCSSForInboundCalls()
     * @uses UpdateUniversalDeviceTemplateReq::setCallingPartyTransformationCSSForOutboundCalls()
     * @uses UpdateUniversalDeviceTemplateReq::setReroutingCallingSearchSpace()
     * @uses UpdateUniversalDeviceTemplateReq::setSubscribeCallingSearchSpaceName()
     * @uses UpdateUniversalDeviceTemplateReq::setUseDevicePoolCallingPartyTransformationCSSforInboundCalls()
     * @uses UpdateUniversalDeviceTemplateReq::setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls()
     * @uses UpdateUniversalDeviceTemplateReq::setCommonPhoneProfile()
     * @uses UpdateUniversalDeviceTemplateReq::setCommonDeviceConfiguration()
     * @uses UpdateUniversalDeviceTemplateReq::setSoftkeyTemplate()
     * @uses UpdateUniversalDeviceTemplateReq::setFeatureControlPolicy()
     * @uses UpdateUniversalDeviceTemplateReq::setPhonePersonalization()
     * @uses UpdateUniversalDeviceTemplateReq::setMtpPreferredOriginatingCodec()
     * @uses UpdateUniversalDeviceTemplateReq::setOutboundCallRollover()
     * @uses UpdateUniversalDeviceTemplateReq::setMediaTerminationPointRequired()
     * @uses UpdateUniversalDeviceTemplateReq::setUnattendedPort()
     * @uses UpdateUniversalDeviceTemplateReq::setRequiredDtmfReception()
     * @uses UpdateUniversalDeviceTemplateReq::setRfc2833Disabled()
     * @uses UpdateUniversalDeviceTemplateReq::setSpeeddials()
     * @uses UpdateUniversalDeviceTemplateReq::setUseTrustedRelayPoint()
     * @uses UpdateUniversalDeviceTemplateReq::setProtectedDevice()
     * @uses UpdateUniversalDeviceTemplateReq::setAuthenticationMode()
     * @uses UpdateUniversalDeviceTemplateReq::setAuthenticationString()
     * @uses UpdateUniversalDeviceTemplateReq::setKeySize()
     * @uses UpdateUniversalDeviceTemplateReq::setServicesProvisioning()
     * @uses UpdateUniversalDeviceTemplateReq::setPacketCaptureMode()
     * @uses UpdateUniversalDeviceTemplateReq::setPacketCaptureDuration()
     * @uses UpdateUniversalDeviceTemplateReq::setSecureShellUser()
     * @uses UpdateUniversalDeviceTemplateReq::setSecureShellPassword()
     * @uses UpdateUniversalDeviceTemplateReq::setUserLocale()
     * @uses UpdateUniversalDeviceTemplateReq::setNetworkLocale()
     * @uses UpdateUniversalDeviceTemplateReq::setMlppDomain()
     * @uses UpdateUniversalDeviceTemplateReq::setMlppIndication()
     * @uses UpdateUniversalDeviceTemplateReq::setMlppPreemption()
     * @uses UpdateUniversalDeviceTemplateReq::setDoNotDisturb()
     * @uses UpdateUniversalDeviceTemplateReq::setDndOption()
     * @uses UpdateUniversalDeviceTemplateReq::setDndIncomingCallAlert()
     * @uses UpdateUniversalDeviceTemplateReq::setAarGroup()
     * @uses UpdateUniversalDeviceTemplateReq::setAarCallingSearchSpace()
     * @uses UpdateUniversalDeviceTemplateReq::setBlfPresenceGroup()
     * @uses UpdateUniversalDeviceTemplateReq::setBlfAudibleAlertSettingPhoneBusy()
     * @uses UpdateUniversalDeviceTemplateReq::setBlfAudibleAlertSettingPhoneIdle()
     * @uses UpdateUniversalDeviceTemplateReq::setUserHoldMohAudioSource()
     * @uses UpdateUniversalDeviceTemplateReq::setNetworkHoldMohAudioSource()
     * @uses UpdateUniversalDeviceTemplateReq::setLocation()
     * @uses UpdateUniversalDeviceTemplateReq::setGeoLocation()
     * @uses UpdateUniversalDeviceTemplateReq::setDeviceMobilityMode()
     * @uses UpdateUniversalDeviceTemplateReq::setMediaResourceGroupList()
     * @uses UpdateUniversalDeviceTemplateReq::setRemoteDevice()
     * @uses UpdateUniversalDeviceTemplateReq::setHotlineDevice()
     * @uses UpdateUniversalDeviceTemplateReq::setRetryVideoCallAsAudio()
     * @uses UpdateUniversalDeviceTemplateReq::setRequireOffPremiseLocation()
     * @uses UpdateUniversalDeviceTemplateReq::setOwnerUserId()
     * @uses UpdateUniversalDeviceTemplateReq::setMobilityUserId()
     * @uses UpdateUniversalDeviceTemplateReq::setJoinAcrossLines()
     * @uses UpdateUniversalDeviceTemplateReq::setAlwaysUsePrimeLine()
     * @uses UpdateUniversalDeviceTemplateReq::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses UpdateUniversalDeviceTemplateReq::setSingleButtonBarge()
     * @uses UpdateUniversalDeviceTemplateReq::setBuiltInBridge()
     * @uses UpdateUniversalDeviceTemplateReq::setAllowControlOfDeviceFromCti()
     * @uses UpdateUniversalDeviceTemplateReq::setIgnorePresentationIndicators()
     * @uses UpdateUniversalDeviceTemplateReq::setEnableExtensionMobility()
     * @uses UpdateUniversalDeviceTemplateReq::setRecordingOptions()
     * @uses UpdateUniversalDeviceTemplateReq::setPrivacy()
     * @uses UpdateUniversalDeviceTemplateReq::setLoggedIntoHuntGroup()
     * @uses UpdateUniversalDeviceTemplateReq::setProxyServer()
     * @uses UpdateUniversalDeviceTemplateReq::setServicesUrl()
     * @uses UpdateUniversalDeviceTemplateReq::setIdle()
     * @uses UpdateUniversalDeviceTemplateReq::setIdleTimer()
     * @uses UpdateUniversalDeviceTemplateReq::setSecureDirUrl()
     * @uses UpdateUniversalDeviceTemplateReq::setMessages()
     * @uses UpdateUniversalDeviceTemplateReq::setSecureIdleUrl()
     * @uses UpdateUniversalDeviceTemplateReq::setAuthenticationServer()
     * @uses UpdateUniversalDeviceTemplateReq::setDirectory()
     * @uses UpdateUniversalDeviceTemplateReq::setSecureServicesUrl()
     * @uses UpdateUniversalDeviceTemplateReq::setInformation()
     * @uses UpdateUniversalDeviceTemplateReq::setSecureMessagesUrl()
     * @uses UpdateUniversalDeviceTemplateReq::setSecureInformationUrl()
     * @uses UpdateUniversalDeviceTemplateReq::setSecureAuthenticationUrl()
     * @uses UpdateUniversalDeviceTemplateReq::setExternalPhoneNumber()
     * @uses UpdateUniversalDeviceTemplateReq::setAudibleMsgWaitingicatorPolicy()
     * @uses UpdateUniversalDeviceTemplateReq::setLogMissedCalls()
     * @uses UpdateUniversalDeviceTemplateReq::setVisualMsgWaitingIndicatorPolicy()
     * @uses UpdateUniversalDeviceTemplateReq::setLineLabel()
     * @uses UpdateUniversalDeviceTemplateReq::setDisplayCallerId()
     * @uses UpdateUniversalDeviceTemplateReq::setMaxNumberOfCalls()
     * @uses UpdateUniversalDeviceTemplateReq::setRingSettingWhenPhoneIdle()
     * @uses UpdateUniversalDeviceTemplateReq::setBusyTrigger()
     * @uses UpdateUniversalDeviceTemplateReq::setRingSettingWhenPhoneInUse()
     * @uses UpdateUniversalDeviceTemplateReq::setDirectoryNumber()
     * @uses UpdateUniversalDeviceTemplateReq::setRecordingProfile()
     * @uses UpdateUniversalDeviceTemplateReq::setCallPickupGroupAudioAlertSettingPhoneActive()
     * @uses UpdateUniversalDeviceTemplateReq::setCallPickupGroupAudioAlertSettingPhoneIdle()
     * @uses UpdateUniversalDeviceTemplateReq::setMonitoringCallingSearchSpace()
     * @uses UpdateUniversalDeviceTemplateReq::setConfidentialAccess()
     * @uses UpdateUniversalDeviceTemplateReq::setServices()
     * @param string $newName
     * @param string $deviceDescription
     * @param XFkType $devicePool
     * @param XFkType $deviceSecurityProfile
     * @param XFkType $sipProfile
     * @param XFkType $phoneButtonTemplate
     * @param XFkType $sipDialRules
     * @param XFkType $callingSearchSpace
     * @param XFkType $callingPartyTransformationCSSForInboundCalls
     * @param XFkType $callingPartyTransformationCSSForOutboundCalls
     * @param XFkType $reroutingCallingSearchSpace
     * @param XFkType $subscribeCallingSearchSpaceName
     * @param string $useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * @param string $useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * @param XFkType $commonPhoneProfile
     * @param XFkType $commonDeviceConfiguration
     * @param XFkType $softkeyTemplate
     * @param XFkType $featureControlPolicy
     * @param string $phonePersonalization
     * @param string $mtpPreferredOriginatingCodec
     * @param string $outboundCallRollover
     * @param string $mediaTerminationPointRequired
     * @param string $unattendedPort
     * @param string $requiredDtmfReception
     * @param string $rfc2833Disabled
     * @param Speeddials $speeddials
     * @param string $useTrustedRelayPoint
     * @param string $protectedDevice
     * @param string $authenticationMode
     * @param string $authenticationString
     * @param string $keySize
     * @param string $servicesProvisioning
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $secureShellUser
     * @param string $secureShellPassword
     * @param string $userLocale
     * @param string $networkLocale
     * @param XFkType $mlppDomain
     * @param string $mlppIndication
     * @param string $mlppPreemption
     * @param string $doNotDisturb
     * @param string $dndOption
     * @param string $dndIncomingCallAlert
     * @param XFkType $aarGroup
     * @param XFkType $aarCallingSearchSpace
     * @param XFkType $blfPresenceGroup
     * @param string $blfAudibleAlertSettingPhoneBusy
     * @param string $blfAudibleAlertSettingPhoneIdle
     * @param string $userHoldMohAudioSource
     * @param string $networkHoldMohAudioSource
     * @param XFkType $location
     * @param XFkType $geoLocation
     * @param string $deviceMobilityMode
     * @param XFkType $mediaResourceGroupList
     * @param string $remoteDevice
     * @param string $hotlineDevice
     * @param string $retryVideoCallAsAudio
     * @param string $requireOffPremiseLocation
     * @param XFkType $ownerUserId
     * @param XFkType $mobilityUserId
     * @param string $joinAcrossLines
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param string $singleButtonBarge
     * @param string $builtInBridge
     * @param string $allowControlOfDeviceFromCti
     * @param string $ignorePresentationIndicators
     * @param string $enableExtensionMobility
     * @param string $recordingOptions
     * @param string $privacy
     * @param string $loggedIntoHuntGroup
     * @param string $proxyServer
     * @param string $servicesUrl
     * @param string $idle
     * @param string $idleTimer
     * @param string $secureDirUrl
     * @param string $messages
     * @param string $secureIdleUrl
     * @param string $authenticationServer
     * @param string $directory
     * @param string $secureServicesUrl
     * @param string $information
     * @param string $secureMessagesUrl
     * @param string $secureInformationUrl
     * @param string $secureAuthenticationUrl
     * @param string $externalPhoneNumber
     * @param string $audibleMsgWaitingicatorPolicy
     * @param string $logMissedCalls
     * @param string $visualMsgWaitingIndicatorPolicy
     * @param string $lineLabel
     * @param string $displayCallerId
     * @param string $maxNumberOfCalls
     * @param string $ringSettingWhenPhoneIdle
     * @param string $busyTrigger
     * @param string $ringSettingWhenPhoneInUse
     * @param XFkType $directoryNumber
     * @param XFkType $recordingProfile
     * @param string $callPickupGroupAudioAlertSettingPhoneActive
     * @param string $callPickupGroupAudioAlertSettingPhoneIdle
     * @param XFkType $monitoringCallingSearchSpace
     * @param ConfidentialAccess $confidentialAccess
     * @param Services $services
     */
    public function __construct($newName = null, $deviceDescription = null, XFkType $devicePool = null, XFkType $deviceSecurityProfile = null, XFkType $sipProfile = null, XFkType $phoneButtonTemplate = null, XFkType $sipDialRules = null, XFkType $callingSearchSpace = null, XFkType $callingPartyTransformationCSSForInboundCalls = null, XFkType $callingPartyTransformationCSSForOutboundCalls = null, XFkType $reroutingCallingSearchSpace = null, XFkType $subscribeCallingSearchSpaceName = null, $useDevicePoolCallingPartyTransformationCSSforInboundCalls = null, $useDevicePoolCallingPartyTransformationCSSforOutboundCalls = null, XFkType $commonPhoneProfile = null, XFkType $commonDeviceConfiguration = null, XFkType $softkeyTemplate = null, XFkType $featureControlPolicy = null, $phonePersonalization = 'Default', $mtpPreferredOriginatingCodec = '711ulaw', $outboundCallRollover = 'No Rollover', $mediaTerminationPointRequired = null, $unattendedPort = null, $requiredDtmfReception = null, $rfc2833Disabled = null, Speeddials $speeddials = null, $useTrustedRelayPoint = 'Default', $protectedDevice = null, $authenticationMode = 'By Null String', $authenticationString = null, $keySize = '1024', $servicesProvisioning = 'Default', $packetCaptureMode = 'None', $packetCaptureDuration = '0', $secureShellUser = null, $secureShellPassword = null, $userLocale = null, $networkLocale = null, XFkType $mlppDomain = null, $mlppIndication = 'Off', $mlppPreemption = 'Default', $doNotDisturb = null, $dndOption = 'Ringer Off', $dndIncomingCallAlert = null, XFkType $aarGroup = null, XFkType $aarCallingSearchSpace = null, XFkType $blfPresenceGroup = null, $blfAudibleAlertSettingPhoneBusy = 'Default', $blfAudibleAlertSettingPhoneIdle = 'Default', $userHoldMohAudioSource = null, $networkHoldMohAudioSource = null, XFkType $location = null, XFkType $geoLocation = null, $deviceMobilityMode = 'Default', XFkType $mediaResourceGroupList = null, $remoteDevice = null, $hotlineDevice = null, $retryVideoCallAsAudio = null, $requireOffPremiseLocation = null, XFkType $ownerUserId = null, XFkType $mobilityUserId = null, $joinAcrossLines = 'Default', $alwaysUsePrimeLine = 'Default', $alwaysUsePrimeLineForVoiceMessage = 'Default', $singleButtonBarge = 'Default', $builtInBridge = 'Default', $allowControlOfDeviceFromCti = null, $ignorePresentationIndicators = null, $enableExtensionMobility = null, $recordingOptions = 'Call Recording Disabled', $privacy = 'Default', $loggedIntoHuntGroup = null, $proxyServer = null, $servicesUrl = null, $idle = null, $idleTimer = null, $secureDirUrl = null, $messages = null, $secureIdleUrl = null, $authenticationServer = null, $directory = null, $secureServicesUrl = null, $information = null, $secureMessagesUrl = null, $secureInformationUrl = null, $secureAuthenticationUrl = null, $externalPhoneNumber = null, $audibleMsgWaitingicatorPolicy = 'Default', $logMissedCalls = null, $visualMsgWaitingIndicatorPolicy = 'Use System Policy', $lineLabel = null, $displayCallerId = null, $maxNumberOfCalls = '2', $ringSettingWhenPhoneIdle = 'Ring', $busyTrigger = '1', $ringSettingWhenPhoneInUse = 'Use System Default', XFkType $directoryNumber = null, XFkType $recordingProfile = null, $callPickupGroupAudioAlertSettingPhoneActive = null, $callPickupGroupAudioAlertSettingPhoneIdle = null, XFkType $monitoringCallingSearchSpace = null, ConfidentialAccess $confidentialAccess = null, Services $services = null)
    {
        $this
            ->setNewName($newName)
            ->setDeviceDescription($deviceDescription)
            ->setDevicePool($devicePool)
            ->setDeviceSecurityProfile($deviceSecurityProfile)
            ->setSipProfile($sipProfile)
            ->setPhoneButtonTemplate($phoneButtonTemplate)
            ->setSipDialRules($sipDialRules)
            ->setCallingSearchSpace($callingSearchSpace)
            ->setCallingPartyTransformationCSSForInboundCalls($callingPartyTransformationCSSForInboundCalls)
            ->setCallingPartyTransformationCSSForOutboundCalls($callingPartyTransformationCSSForOutboundCalls)
            ->setReroutingCallingSearchSpace($reroutingCallingSearchSpace)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setUseDevicePoolCallingPartyTransformationCSSforInboundCalls($useDevicePoolCallingPartyTransformationCSSforInboundCalls)
            ->setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)
            ->setCommonPhoneProfile($commonPhoneProfile)
            ->setCommonDeviceConfiguration($commonDeviceConfiguration)
            ->setSoftkeyTemplate($softkeyTemplate)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setPhonePersonalization($phonePersonalization)
            ->setMtpPreferredOriginatingCodec($mtpPreferredOriginatingCodec)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setMediaTerminationPointRequired($mediaTerminationPointRequired)
            ->setUnattendedPort($unattendedPort)
            ->setRequiredDtmfReception($requiredDtmfReception)
            ->setRfc2833Disabled($rfc2833Disabled)
            ->setSpeeddials($speeddials)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setProtectedDevice($protectedDevice)
            ->setAuthenticationMode($authenticationMode)
            ->setAuthenticationString($authenticationString)
            ->setKeySize($keySize)
            ->setServicesProvisioning($servicesProvisioning)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSecureShellUser($secureShellUser)
            ->setSecureShellPassword($secureShellPassword)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setMlppDomain($mlppDomain)
            ->setMlppIndication($mlppIndication)
            ->setMlppPreemption($mlppPreemption)
            ->setDoNotDisturb($doNotDisturb)
            ->setDndOption($dndOption)
            ->setDndIncomingCallAlert($dndIncomingCallAlert)
            ->setAarGroup($aarGroup)
            ->setAarCallingSearchSpace($aarCallingSearchSpace)
            ->setBlfPresenceGroup($blfPresenceGroup)
            ->setBlfAudibleAlertSettingPhoneBusy($blfAudibleAlertSettingPhoneBusy)
            ->setBlfAudibleAlertSettingPhoneIdle($blfAudibleAlertSettingPhoneIdle)
            ->setUserHoldMohAudioSource($userHoldMohAudioSource)
            ->setNetworkHoldMohAudioSource($networkHoldMohAudioSource)
            ->setLocation($location)
            ->setGeoLocation($geoLocation)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setMediaResourceGroupList($mediaResourceGroupList)
            ->setRemoteDevice($remoteDevice)
            ->setHotlineDevice($hotlineDevice)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setRequireOffPremiseLocation($requireOffPremiseLocation)
            ->setOwnerUserId($ownerUserId)
            ->setMobilityUserId($mobilityUserId)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setBuiltInBridge($builtInBridge)
            ->setAllowControlOfDeviceFromCti($allowControlOfDeviceFromCti)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setRecordingOptions($recordingOptions)
            ->setPrivacy($privacy)
            ->setLoggedIntoHuntGroup($loggedIntoHuntGroup)
            ->setProxyServer($proxyServer)
            ->setServicesUrl($servicesUrl)
            ->setIdle($idle)
            ->setIdleTimer($idleTimer)
            ->setSecureDirUrl($secureDirUrl)
            ->setMessages($messages)
            ->setSecureIdleUrl($secureIdleUrl)
            ->setAuthenticationServer($authenticationServer)
            ->setDirectory($directory)
            ->setSecureServicesUrl($secureServicesUrl)
            ->setInformation($information)
            ->setSecureMessagesUrl($secureMessagesUrl)
            ->setSecureInformationUrl($secureInformationUrl)
            ->setSecureAuthenticationUrl($secureAuthenticationUrl)
            ->setExternalPhoneNumber($externalPhoneNumber)
            ->setAudibleMsgWaitingicatorPolicy($audibleMsgWaitingicatorPolicy)
            ->setLogMissedCalls($logMissedCalls)
            ->setVisualMsgWaitingIndicatorPolicy($visualMsgWaitingIndicatorPolicy)
            ->setLineLabel($lineLabel)
            ->setDisplayCallerId($displayCallerId)
            ->setMaxNumberOfCalls($maxNumberOfCalls)
            ->setRingSettingWhenPhoneIdle($ringSettingWhenPhoneIdle)
            ->setBusyTrigger($busyTrigger)
            ->setRingSettingWhenPhoneInUse($ringSettingWhenPhoneInUse)
            ->setDirectoryNumber($directoryNumber)
            ->setRecordingProfile($recordingProfile)
            ->setCallPickupGroupAudioAlertSettingPhoneActive($callPickupGroupAudioAlertSettingPhoneActive)
            ->setCallPickupGroupAudioAlertSettingPhoneIdle($callPickupGroupAudioAlertSettingPhoneIdle)
            ->setMonitoringCallingSearchSpace($monitoringCallingSearchSpace)
            ->setConfidentialAccess($confidentialAccess)
            ->setServices($services);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get deviceDescription value
     * @return string|null
     */
    public function getDeviceDescription()
    {
        return $this->deviceDescription;
    }
    /**
     * Set deviceDescription value
     * @param string $deviceDescription
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setDeviceDescription($deviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDescription) && !is_string($deviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceDescription)), __LINE__);
        }
        $this->deviceDescription = $deviceDescription;
        return $this;
    }
    /**
     * Get devicePool value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDevicePool()
    {
        return isset($this->devicePool) ? $this->devicePool : null;
    }
    /**
     * Set devicePool value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $devicePool
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setDevicePool(XFkType $devicePool = null)
    {
        if (is_null($devicePool) || (is_array($devicePool) && empty($devicePool))) {
            unset($this->devicePool);
        } else {
            $this->devicePool = $devicePool;
        }
        return $this;
    }
    /**
     * Get deviceSecurityProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDeviceSecurityProfile()
    {
        return isset($this->deviceSecurityProfile) ? $this->deviceSecurityProfile : null;
    }
    /**
     * Set deviceSecurityProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $deviceSecurityProfile
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setDeviceSecurityProfile(XFkType $deviceSecurityProfile = null)
    {
        if (is_null($deviceSecurityProfile) || (is_array($deviceSecurityProfile) && empty($deviceSecurityProfile))) {
            unset($this->deviceSecurityProfile);
        } else {
            $this->deviceSecurityProfile = $deviceSecurityProfile;
        }
        return $this;
    }
    /**
     * Get sipProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSipProfile()
    {
        return isset($this->sipProfile) ? $this->sipProfile : null;
    }
    /**
     * Set sipProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $sipProfile
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSipProfile(XFkType $sipProfile = null)
    {
        if (is_null($sipProfile) || (is_array($sipProfile) && empty($sipProfile))) {
            unset($this->sipProfile);
        } else {
            $this->sipProfile = $sipProfile;
        }
        return $this;
    }
    /**
     * Get phoneButtonTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getPhoneButtonTemplate()
    {
        return isset($this->phoneButtonTemplate) ? $this->phoneButtonTemplate : null;
    }
    /**
     * Set phoneButtonTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $phoneButtonTemplate
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setPhoneButtonTemplate(XFkType $phoneButtonTemplate = null)
    {
        if (is_null($phoneButtonTemplate) || (is_array($phoneButtonTemplate) && empty($phoneButtonTemplate))) {
            unset($this->phoneButtonTemplate);
        } else {
            $this->phoneButtonTemplate = $phoneButtonTemplate;
        }
        return $this;
    }
    /**
     * Get sipDialRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSipDialRules()
    {
        return isset($this->sipDialRules) ? $this->sipDialRules : null;
    }
    /**
     * Set sipDialRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $sipDialRules
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSipDialRules(XFkType $sipDialRules = null)
    {
        if (is_null($sipDialRules) || (is_array($sipDialRules) && empty($sipDialRules))) {
            unset($this->sipDialRules);
        } else {
            $this->sipDialRules = $sipDialRules;
        }
        return $this;
    }
    /**
     * Get callingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingSearchSpace()
    {
        return isset($this->callingSearchSpace) ? $this->callingSearchSpace : null;
    }
    /**
     * Set callingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingSearchSpace
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setCallingSearchSpace(XFkType $callingSearchSpace = null)
    {
        if (is_null($callingSearchSpace) || (is_array($callingSearchSpace) && empty($callingSearchSpace))) {
            unset($this->callingSearchSpace);
        } else {
            $this->callingSearchSpace = $callingSearchSpace;
        }
        return $this;
    }
    /**
     * Get callingPartyTransformationCSSForInboundCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingPartyTransformationCSSForInboundCalls()
    {
        return isset($this->callingPartyTransformationCSSForInboundCalls) ? $this->callingPartyTransformationCSSForInboundCalls : null;
    }
    /**
     * Set callingPartyTransformationCSSForInboundCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingPartyTransformationCSSForInboundCalls
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setCallingPartyTransformationCSSForInboundCalls(XFkType $callingPartyTransformationCSSForInboundCalls = null)
    {
        if (is_null($callingPartyTransformationCSSForInboundCalls) || (is_array($callingPartyTransformationCSSForInboundCalls) && empty($callingPartyTransformationCSSForInboundCalls))) {
            unset($this->callingPartyTransformationCSSForInboundCalls);
        } else {
            $this->callingPartyTransformationCSSForInboundCalls = $callingPartyTransformationCSSForInboundCalls;
        }
        return $this;
    }
    /**
     * Get callingPartyTransformationCSSForOutboundCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingPartyTransformationCSSForOutboundCalls()
    {
        return isset($this->callingPartyTransformationCSSForOutboundCalls) ? $this->callingPartyTransformationCSSForOutboundCalls : null;
    }
    /**
     * Set callingPartyTransformationCSSForOutboundCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingPartyTransformationCSSForOutboundCalls
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setCallingPartyTransformationCSSForOutboundCalls(XFkType $callingPartyTransformationCSSForOutboundCalls = null)
    {
        if (is_null($callingPartyTransformationCSSForOutboundCalls) || (is_array($callingPartyTransformationCSSForOutboundCalls) && empty($callingPartyTransformationCSSForOutboundCalls))) {
            unset($this->callingPartyTransformationCSSForOutboundCalls);
        } else {
            $this->callingPartyTransformationCSSForOutboundCalls = $callingPartyTransformationCSSForOutboundCalls;
        }
        return $this;
    }
    /**
     * Get reroutingCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getReroutingCallingSearchSpace()
    {
        return isset($this->reroutingCallingSearchSpace) ? $this->reroutingCallingSearchSpace : null;
    }
    /**
     * Set reroutingCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $reroutingCallingSearchSpace
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setReroutingCallingSearchSpace(XFkType $reroutingCallingSearchSpace = null)
    {
        if (is_null($reroutingCallingSearchSpace) || (is_array($reroutingCallingSearchSpace) && empty($reroutingCallingSearchSpace))) {
            unset($this->reroutingCallingSearchSpace);
        } else {
            $this->reroutingCallingSearchSpace = $reroutingCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return isset($this->subscribeCallingSearchSpaceName) ? $this->subscribeCallingSearchSpaceName : null;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $subscribeCallingSearchSpaceName
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSubscribeCallingSearchSpaceName(XFkType $subscribeCallingSearchSpaceName = null)
    {
        if (is_null($subscribeCallingSearchSpaceName) || (is_array($subscribeCallingSearchSpaceName) && empty($subscribeCallingSearchSpaceName))) {
            unset($this->subscribeCallingSearchSpaceName);
        } else {
            $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCallingPartyTransformationCSSforInboundCalls value
     * @return string|null
     */
    public function getUseDevicePoolCallingPartyTransformationCSSforInboundCalls()
    {
        return $this->useDevicePoolCallingPartyTransformationCSSforInboundCalls;
    }
    /**
     * Set useDevicePoolCallingPartyTransformationCSSforInboundCalls value
     * @param string $useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setUseDevicePoolCallingPartyTransformationCSSforInboundCalls($useDevicePoolCallingPartyTransformationCSSforInboundCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCallingPartyTransformationCSSforInboundCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCallingPartyTransformationCSSforInboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCallingPartyTransformationCSSforInboundCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCallingPartyTransformationCSSforInboundCalls) && !is_string($useDevicePoolCallingPartyTransformationCSSforInboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCallingPartyTransformationCSSforInboundCalls)), __LINE__);
        }
        $this->useDevicePoolCallingPartyTransformationCSSforInboundCalls = $useDevicePoolCallingPartyTransformationCSSforInboundCalls;
        return $this;
    }
    /**
     * Get useDevicePoolCallingPartyTransformationCSSforOutboundCalls value
     * @return string|null
     */
    public function getUseDevicePoolCallingPartyTransformationCSSforOutboundCalls()
    {
        return $this->useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
    }
    /**
     * Set useDevicePoolCallingPartyTransformationCSSforOutboundCalls value
     * @param string $useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls($useDevicePoolCallingPartyTransformationCSSforOutboundCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCallingPartyTransformationCSSforOutboundCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCallingPartyTransformationCSSforOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCallingPartyTransformationCSSforOutboundCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCallingPartyTransformationCSSforOutboundCalls) && !is_string($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)), __LINE__);
        }
        $this->useDevicePoolCallingPartyTransformationCSSforOutboundCalls = $useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
        return $this;
    }
    /**
     * Get commonPhoneProfile value
     * @return XFkType|null
     */
    public function getCommonPhoneProfile()
    {
        return $this->commonPhoneProfile;
    }
    /**
     * Set commonPhoneProfile value
     * @param XFkType $commonPhoneProfile
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setCommonPhoneProfile(XFkType $commonPhoneProfile = null)
    {
        $this->commonPhoneProfile = $commonPhoneProfile;
        return $this;
    }
    /**
     * Get commonDeviceConfiguration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCommonDeviceConfiguration()
    {
        return isset($this->commonDeviceConfiguration) ? $this->commonDeviceConfiguration : null;
    }
    /**
     * Set commonDeviceConfiguration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $commonDeviceConfiguration
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setCommonDeviceConfiguration(XFkType $commonDeviceConfiguration = null)
    {
        if (is_null($commonDeviceConfiguration) || (is_array($commonDeviceConfiguration) && empty($commonDeviceConfiguration))) {
            unset($this->commonDeviceConfiguration);
        } else {
            $this->commonDeviceConfiguration = $commonDeviceConfiguration;
        }
        return $this;
    }
    /**
     * Get softkeyTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSoftkeyTemplate()
    {
        return isset($this->softkeyTemplate) ? $this->softkeyTemplate : null;
    }
    /**
     * Set softkeyTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $softkeyTemplate
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSoftkeyTemplate(XFkType $softkeyTemplate = null)
    {
        if (is_null($softkeyTemplate) || (is_array($softkeyTemplate) && empty($softkeyTemplate))) {
            unset($this->softkeyTemplate);
        } else {
            $this->softkeyTemplate = $softkeyTemplate;
        }
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return isset($this->featureControlPolicy) ? $this->featureControlPolicy : null;
    }
    /**
     * Set featureControlPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $featureControlPolicy
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setFeatureControlPolicy(XFkType $featureControlPolicy = null)
    {
        if (is_null($featureControlPolicy) || (is_array($featureControlPolicy) && empty($featureControlPolicy))) {
            unset($this->featureControlPolicy);
        } else {
            $this->featureControlPolicy = $featureControlPolicy;
        }
        return $this;
    }
    /**
     * Get phonePersonalization value
     * @return string|null
     */
    public function getPhonePersonalization()
    {
        return $this->phonePersonalization;
    }
    /**
     * Set phonePersonalization value
     * @uses XPhonePersonalization::valueIsValid()
     * @uses XPhonePersonalization::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phonePersonalization
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setPhonePersonalization($phonePersonalization = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPhonePersonalization::valueIsValid($phonePersonalization)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phonePersonalization, implode(', ', XPhonePersonalization::getValidValues())), __LINE__);
        }
        $this->phonePersonalization = $phonePersonalization;
        return $this;
    }
    /**
     * Get mtpPreferredOriginatingCodec value
     * @return string|null
     */
    public function getMtpPreferredOriginatingCodec()
    {
        return $this->mtpPreferredOriginatingCodec;
    }
    /**
     * Set mtpPreferredOriginatingCodec value
     * @uses XSIPCodec::valueIsValid()
     * @uses XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtpPreferredOriginatingCodec
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setMtpPreferredOriginatingCodec($mtpPreferredOriginatingCodec = '711ulaw')
    {
        // validation for constraint: enumeration
        if (!XSIPCodec::valueIsValid($mtpPreferredOriginatingCodec)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mtpPreferredOriginatingCodec, implode(', ', XSIPCodec::getValidValues())), __LINE__);
        }
        $this->mtpPreferredOriginatingCodec = $mtpPreferredOriginatingCodec;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return string|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @uses XOutboundCallRollover::valueIsValid()
     * @uses XOutboundCallRollover::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outboundCallRollover
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setOutboundCallRollover($outboundCallRollover = 'No Rollover')
    {
        // validation for constraint: enumeration
        if (!XOutboundCallRollover::valueIsValid($outboundCallRollover)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $outboundCallRollover, implode(', ', XOutboundCallRollover::getValidValues())), __LINE__);
        }
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get mediaTerminationPointRequired value
     * @return string|null
     */
    public function getMediaTerminationPointRequired()
    {
        return $this->mediaTerminationPointRequired;
    }
    /**
     * Set mediaTerminationPointRequired value
     * @param string $mediaTerminationPointRequired
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setMediaTerminationPointRequired($mediaTerminationPointRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mediaTerminationPointRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mediaTerminationPointRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mediaTerminationPointRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mediaTerminationPointRequired) && !is_string($mediaTerminationPointRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mediaTerminationPointRequired)), __LINE__);
        }
        $this->mediaTerminationPointRequired = $mediaTerminationPointRequired;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get requiredDtmfReception value
     * @return string|null
     */
    public function getRequiredDtmfReception()
    {
        return $this->requiredDtmfReception;
    }
    /**
     * Set requiredDtmfReception value
     * @param string $requiredDtmfReception
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setRequiredDtmfReception($requiredDtmfReception = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requiredDtmfReception) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requiredDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requiredDtmfReception, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requiredDtmfReception) && !is_string($requiredDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requiredDtmfReception)), __LINE__);
        }
        $this->requiredDtmfReception = $requiredDtmfReception;
        return $this;
    }
    /**
     * Get rfc2833Disabled value
     * @return string|null
     */
    public function getRfc2833Disabled()
    {
        return $this->rfc2833Disabled;
    }
    /**
     * Set rfc2833Disabled value
     * @param string $rfc2833Disabled
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setRfc2833Disabled($rfc2833Disabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rfc2833Disabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rfc2833Disabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rfc2833Disabled) && !is_string($rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rfc2833Disabled)), __LINE__);
        }
        $this->rfc2833Disabled = $rfc2833Disabled;
        return $this;
    }
    /**
     * Get speeddials value
     * @return Speeddials|null
     */
    public function getSpeeddials()
    {
        return $this->speeddials;
    }
    /**
     * Set speeddials value
     * @param Speeddials $speeddials
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSpeeddials(Speeddials $speeddials = null)
    {
        $this->speeddials = $speeddials;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get protectedDevice value
     * @return string|null
     */
    public function getProtectedDevice()
    {
        return $this->protectedDevice;
    }
    /**
     * Set protectedDevice value
     * @param string $protectedDevice
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setProtectedDevice($protectedDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($protectedDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $protectedDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($protectedDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($protectedDevice) && !is_string($protectedDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($protectedDevice)), __LINE__);
        }
        $this->protectedDevice = $protectedDevice;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses XAuthenticationMode::valueIsValid()
     * @uses XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        // validation for constraint: enumeration
        if (!XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses XKeySize::valueIsValid()
     * @uses XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setKeySize($keySize = '1024')
    {
        // validation for constraint: enumeration
        if (!XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get servicesProvisioning value
     * @return string|null
     */
    public function getServicesProvisioning()
    {
        return $this->servicesProvisioning;
    }
    /**
     * Set servicesProvisioning value
     * @uses XPhoneServiceDisplay::valueIsValid()
     * @uses XPhoneServiceDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servicesProvisioning
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setServicesProvisioning($servicesProvisioning = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPhoneServiceDisplay::valueIsValid($servicesProvisioning)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $servicesProvisioning, implode(', ', XPhoneServiceDisplay::getValidValues())), __LINE__);
        }
        $this->servicesProvisioning = $servicesProvisioning;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses XPacketCaptureMode::valueIsValid()
     * @uses XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        // validation for constraint: enumeration
        if (!XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get secureShellUser value
     * @return string|null
     */
    public function getSecureShellUser()
    {
        return $this->secureShellUser;
    }
    /**
     * Set secureShellUser value
     * @param string $secureShellUser
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSecureShellUser($secureShellUser = null)
    {
        // validation for constraint: string
        if (!is_null($secureShellUser) && !is_string($secureShellUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureShellUser)), __LINE__);
        }
        $this->secureShellUser = $secureShellUser;
        return $this;
    }
    /**
     * Get secureShellPassword value
     * @return string|null
     */
    public function getSecureShellPassword()
    {
        return $this->secureShellPassword;
    }
    /**
     * Set secureShellPassword value
     * @param string $secureShellPassword
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSecureShellPassword($secureShellPassword = null)
    {
        // validation for constraint: string
        if (!is_null($secureShellPassword) && !is_string($secureShellPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureShellPassword)), __LINE__);
        }
        $this->secureShellPassword = $secureShellPassword;
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XCountry::valueIsValid()
     * @uses XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', XCountry::getValidValues())), __LINE__);
        }
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get mlppDomain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMlppDomain()
    {
        return isset($this->mlppDomain) ? $this->mlppDomain : null;
    }
    /**
     * Set mlppDomain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $mlppDomain
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setMlppDomain(XFkType $mlppDomain = null)
    {
        if (is_null($mlppDomain) || (is_array($mlppDomain) && empty($mlppDomain))) {
            unset($this->mlppDomain);
        } else {
            $this->mlppDomain = $mlppDomain;
        }
        return $this;
    }
    /**
     * Get mlppIndication value
     * @return string|null
     */
    public function getMlppIndication()
    {
        return $this->mlppIndication;
    }
    /**
     * Set mlppIndication value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndication
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setMlppIndication($mlppIndication = 'Off')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($mlppIndication)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndication, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndication = $mlppIndication;
        return $this;
    }
    /**
     * Get mlppPreemption value
     * @return string|null
     */
    public function getMlppPreemption()
    {
        return $this->mlppPreemption;
    }
    /**
     * Set mlppPreemption value
     * @uses XPreemption::valueIsValid()
     * @uses XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppPreemption
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setMlppPreemption($mlppPreemption = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPreemption::valueIsValid($mlppPreemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppPreemption, implode(', ', XPreemption::getValidValues())), __LINE__);
        }
        $this->mlppPreemption = $mlppPreemption;
        return $this;
    }
    /**
     * Get doNotDisturb value
     * @return string|null
     */
    public function getDoNotDisturb()
    {
        return $this->doNotDisturb;
    }
    /**
     * Set doNotDisturb value
     * @param string $doNotDisturb
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setDoNotDisturb($doNotDisturb = null)
    {
        // validation for constraint: pattern
        if (is_scalar($doNotDisturb) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $doNotDisturb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($doNotDisturb, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($doNotDisturb) && !is_string($doNotDisturb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doNotDisturb)), __LINE__);
        }
        $this->doNotDisturb = $doNotDisturb;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses XDNDOption::valueIsValid()
     * @uses XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setDndOption($dndOption = 'Ringer Off')
    {
        // validation for constraint: enumeration
        if (!XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndIncomingCallAlert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDndIncomingCallAlert()
    {
        return isset($this->dndIncomingCallAlert) ? $this->dndIncomingCallAlert : null;
    }
    /**
     * Set dndIncomingCallAlert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndIncomingCallAlert
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setDndIncomingCallAlert($dndIncomingCallAlert = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($dndIncomingCallAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndIncomingCallAlert, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($dndIncomingCallAlert) || (is_array($dndIncomingCallAlert) && empty($dndIncomingCallAlert))) {
            unset($this->dndIncomingCallAlert);
        } else {
            $this->dndIncomingCallAlert = $dndIncomingCallAlert;
        }
        return $this;
    }
    /**
     * Get aarGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAarGroup()
    {
        return isset($this->aarGroup) ? $this->aarGroup : null;
    }
    /**
     * Set aarGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $aarGroup
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setAarGroup(XFkType $aarGroup = null)
    {
        if (is_null($aarGroup) || (is_array($aarGroup) && empty($aarGroup))) {
            unset($this->aarGroup);
        } else {
            $this->aarGroup = $aarGroup;
        }
        return $this;
    }
    /**
     * Get aarCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAarCallingSearchSpace()
    {
        return isset($this->aarCallingSearchSpace) ? $this->aarCallingSearchSpace : null;
    }
    /**
     * Set aarCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $aarCallingSearchSpace
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setAarCallingSearchSpace(XFkType $aarCallingSearchSpace = null)
    {
        if (is_null($aarCallingSearchSpace) || (is_array($aarCallingSearchSpace) && empty($aarCallingSearchSpace))) {
            unset($this->aarCallingSearchSpace);
        } else {
            $this->aarCallingSearchSpace = $aarCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get blfPresenceGroup value
     * @return XFkType|null
     */
    public function getBlfPresenceGroup()
    {
        return $this->blfPresenceGroup;
    }
    /**
     * Set blfPresenceGroup value
     * @param XFkType $blfPresenceGroup
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setBlfPresenceGroup(XFkType $blfPresenceGroup = null)
    {
        $this->blfPresenceGroup = $blfPresenceGroup;
        return $this;
    }
    /**
     * Get blfAudibleAlertSettingPhoneBusy value
     * @return string|null
     */
    public function getBlfAudibleAlertSettingPhoneBusy()
    {
        return $this->blfAudibleAlertSettingPhoneBusy;
    }
    /**
     * Set blfAudibleAlertSettingPhoneBusy value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $blfAudibleAlertSettingPhoneBusy
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setBlfAudibleAlertSettingPhoneBusy($blfAudibleAlertSettingPhoneBusy = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($blfAudibleAlertSettingPhoneBusy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $blfAudibleAlertSettingPhoneBusy, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->blfAudibleAlertSettingPhoneBusy = $blfAudibleAlertSettingPhoneBusy;
        return $this;
    }
    /**
     * Get blfAudibleAlertSettingPhoneIdle value
     * @return string|null
     */
    public function getBlfAudibleAlertSettingPhoneIdle()
    {
        return $this->blfAudibleAlertSettingPhoneIdle;
    }
    /**
     * Set blfAudibleAlertSettingPhoneIdle value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $blfAudibleAlertSettingPhoneIdle
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setBlfAudibleAlertSettingPhoneIdle($blfAudibleAlertSettingPhoneIdle = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($blfAudibleAlertSettingPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $blfAudibleAlertSettingPhoneIdle, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->blfAudibleAlertSettingPhoneIdle = $blfAudibleAlertSettingPhoneIdle;
        return $this;
    }
    /**
     * Get userHoldMohAudioSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSource()
    {
        return isset($this->userHoldMohAudioSource) ? $this->userHoldMohAudioSource : null;
    }
    /**
     * Set userHoldMohAudioSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSource
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setUserHoldMohAudioSource($userHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($userHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSource, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($userHoldMohAudioSource) || (is_array($userHoldMohAudioSource) && empty($userHoldMohAudioSource))) {
            unset($this->userHoldMohAudioSource);
        } else {
            $this->userHoldMohAudioSource = $userHoldMohAudioSource;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSource()
    {
        return isset($this->networkHoldMohAudioSource) ? $this->networkHoldMohAudioSource : null;
    }
    /**
     * Set networkHoldMohAudioSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSource
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setNetworkHoldMohAudioSource($networkHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($networkHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSource, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($networkHoldMohAudioSource) || (is_array($networkHoldMohAudioSource) && empty($networkHoldMohAudioSource))) {
            unset($this->networkHoldMohAudioSource);
        } else {
            $this->networkHoldMohAudioSource = $networkHoldMohAudioSource;
        }
        return $this;
    }
    /**
     * Get location value
     * @return XFkType|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param XFkType $location
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setLocation(XFkType $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get geoLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getGeoLocation()
    {
        return isset($this->geoLocation) ? $this->geoLocation : null;
    }
    /**
     * Set geoLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $geoLocation
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setGeoLocation(XFkType $geoLocation = null)
    {
        if (is_null($geoLocation) || (is_array($geoLocation) && empty($geoLocation))) {
            unset($this->geoLocation);
        } else {
            $this->geoLocation = $geoLocation;
        }
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return string|null
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceMobilityMode
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setDeviceMobilityMode($deviceMobilityMode = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($deviceMobilityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceMobilityMode, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get mediaResourceGroupList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMediaResourceGroupList()
    {
        return isset($this->mediaResourceGroupList) ? $this->mediaResourceGroupList : null;
    }
    /**
     * Set mediaResourceGroupList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $mediaResourceGroupList
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setMediaResourceGroupList(XFkType $mediaResourceGroupList = null)
    {
        if (is_null($mediaResourceGroupList) || (is_array($mediaResourceGroupList) && empty($mediaResourceGroupList))) {
            unset($this->mediaResourceGroupList);
        } else {
            $this->mediaResourceGroupList = $mediaResourceGroupList;
        }
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setRemoteDevice($remoteDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($remoteDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($remoteDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteDevice) && !is_string($remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteDevice)), __LINE__);
        }
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setHotlineDevice($hotlineDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($hotlineDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($hotlineDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hotlineDevice) && !is_string($hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotlineDevice)), __LINE__);
        }
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get requireOffPremiseLocation value
     * @return string|null
     */
    public function getRequireOffPremiseLocation()
    {
        return $this->requireOffPremiseLocation;
    }
    /**
     * Set requireOffPremiseLocation value
     * @param string $requireOffPremiseLocation
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setRequireOffPremiseLocation($requireOffPremiseLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requireOffPremiseLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requireOffPremiseLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireOffPremiseLocation) && !is_string($requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireOffPremiseLocation)), __LINE__);
        }
        $this->requireOffPremiseLocation = $requireOffPremiseLocation;
        return $this;
    }
    /**
     * Get ownerUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getOwnerUserId()
    {
        return isset($this->ownerUserId) ? $this->ownerUserId : null;
    }
    /**
     * Set ownerUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $ownerUserId
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setOwnerUserId(XFkType $ownerUserId = null)
    {
        if (is_null($ownerUserId) || (is_array($ownerUserId) && empty($ownerUserId))) {
            unset($this->ownerUserId);
        } else {
            $this->ownerUserId = $ownerUserId;
        }
        return $this;
    }
    /**
     * Get mobilityUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMobilityUserId()
    {
        return isset($this->mobilityUserId) ? $this->mobilityUserId : null;
    }
    /**
     * Set mobilityUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $mobilityUserId
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setMobilityUserId(XFkType $mobilityUserId = null)
    {
        if (is_null($mobilityUserId) || (is_array($mobilityUserId) && empty($mobilityUserId))) {
            unset($this->mobilityUserId);
        } else {
            $this->mobilityUserId = $mobilityUserId;
        }
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setJoinAcrossLines($joinAcrossLines = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses XBarge::valueIsValid()
     * @uses XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSingleButtonBarge($singleButtonBarge = 'Default')
    {
        // validation for constraint: enumeration
        if (!XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get builtInBridge value
     * @return string|null
     */
    public function getBuiltInBridge()
    {
        return $this->builtInBridge;
    }
    /**
     * Set builtInBridge value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $builtInBridge
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setBuiltInBridge($builtInBridge = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($builtInBridge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $builtInBridge, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->builtInBridge = $builtInBridge;
        return $this;
    }
    /**
     * Get allowControlOfDeviceFromCti value
     * @return string|null
     */
    public function getAllowControlOfDeviceFromCti()
    {
        return $this->allowControlOfDeviceFromCti;
    }
    /**
     * Set allowControlOfDeviceFromCti value
     * @param string $allowControlOfDeviceFromCti
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setAllowControlOfDeviceFromCti($allowControlOfDeviceFromCti = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowControlOfDeviceFromCti) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowControlOfDeviceFromCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowControlOfDeviceFromCti, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowControlOfDeviceFromCti) && !is_string($allowControlOfDeviceFromCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowControlOfDeviceFromCti)), __LINE__);
        }
        $this->allowControlOfDeviceFromCti = $allowControlOfDeviceFromCti;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignorePresentationIndicators)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableExtensionMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableExtensionMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableExtensionMobility) && !is_string($enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableExtensionMobility)), __LINE__);
        }
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get recordingOptions value
     * @return string|null
     */
    public function getRecordingOptions()
    {
        return $this->recordingOptions;
    }
    /**
     * Set recordingOptions value
     * @uses XRecordingFlag::valueIsValid()
     * @uses XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingOptions
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setRecordingOptions($recordingOptions = 'Call Recording Disabled')
    {
        // validation for constraint: enumeration
        if (!XRecordingFlag::valueIsValid($recordingOptions)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recordingOptions, implode(', ', XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingOptions = $recordingOptions;
        return $this;
    }
    /**
     * Get privacy value
     * @return string|null
     */
    public function getPrivacy()
    {
        return $this->privacy;
    }
    /**
     * Set privacy value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $privacy
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setPrivacy($privacy = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($privacy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $privacy, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->privacy = $privacy;
        return $this;
    }
    /**
     * Get loggedIntoHuntGroup value
     * @return string|null
     */
    public function getLoggedIntoHuntGroup()
    {
        return $this->loggedIntoHuntGroup;
    }
    /**
     * Set loggedIntoHuntGroup value
     * @param string $loggedIntoHuntGroup
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setLoggedIntoHuntGroup($loggedIntoHuntGroup = null)
    {
        // validation for constraint: pattern
        if (is_scalar($loggedIntoHuntGroup) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $loggedIntoHuntGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($loggedIntoHuntGroup, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($loggedIntoHuntGroup) && !is_string($loggedIntoHuntGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loggedIntoHuntGroup)), __LINE__);
        }
        $this->loggedIntoHuntGroup = $loggedIntoHuntGroup;
        return $this;
    }
    /**
     * Get proxyServer value
     * @return string|null
     */
    public function getProxyServer()
    {
        return $this->proxyServer;
    }
    /**
     * Set proxyServer value
     * @param string $proxyServer
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setProxyServer($proxyServer = null)
    {
        // validation for constraint: string
        if (!is_null($proxyServer) && !is_string($proxyServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyServer)), __LINE__);
        }
        $this->proxyServer = $proxyServer;
        return $this;
    }
    /**
     * Get servicesUrl value
     * @return string|null
     */
    public function getServicesUrl()
    {
        return $this->servicesUrl;
    }
    /**
     * Set servicesUrl value
     * @param string $servicesUrl
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setServicesUrl($servicesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($servicesUrl) && !is_string($servicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicesUrl)), __LINE__);
        }
        $this->servicesUrl = $servicesUrl;
        return $this;
    }
    /**
     * Get idle value
     * @return string|null
     */
    public function getIdle()
    {
        return $this->idle;
    }
    /**
     * Set idle value
     * @param string $idle
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setIdle($idle = null)
    {
        // validation for constraint: string
        if (!is_null($idle) && !is_string($idle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idle)), __LINE__);
        }
        $this->idle = $idle;
        return $this;
    }
    /**
     * Get idleTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdleTimer()
    {
        return isset($this->idleTimer) ? $this->idleTimer : null;
    }
    /**
     * Set idleTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idleTimer
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setIdleTimer($idleTimer = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($idleTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $idleTimer, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($idleTimer) || (is_array($idleTimer) && empty($idleTimer))) {
            unset($this->idleTimer);
        } else {
            $this->idleTimer = $idleTimer;
        }
        return $this;
    }
    /**
     * Get secureDirUrl value
     * @return string|null
     */
    public function getSecureDirUrl()
    {
        return $this->secureDirUrl;
    }
    /**
     * Set secureDirUrl value
     * @param string $secureDirUrl
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSecureDirUrl($secureDirUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureDirUrl) && !is_string($secureDirUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureDirUrl)), __LINE__);
        }
        $this->secureDirUrl = $secureDirUrl;
        return $this;
    }
    /**
     * Get messages value
     * @return string|null
     */
    public function getMessages()
    {
        return $this->messages;
    }
    /**
     * Set messages value
     * @param string $messages
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setMessages($messages = null)
    {
        // validation for constraint: string
        if (!is_null($messages) && !is_string($messages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messages)), __LINE__);
        }
        $this->messages = $messages;
        return $this;
    }
    /**
     * Get secureIdleUrl value
     * @return string|null
     */
    public function getSecureIdleUrl()
    {
        return $this->secureIdleUrl;
    }
    /**
     * Set secureIdleUrl value
     * @param string $secureIdleUrl
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSecureIdleUrl($secureIdleUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureIdleUrl) && !is_string($secureIdleUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureIdleUrl)), __LINE__);
        }
        $this->secureIdleUrl = $secureIdleUrl;
        return $this;
    }
    /**
     * Get authenticationServer value
     * @return string|null
     */
    public function getAuthenticationServer()
    {
        return $this->authenticationServer;
    }
    /**
     * Set authenticationServer value
     * @param string $authenticationServer
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setAuthenticationServer($authenticationServer = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationServer) && !is_string($authenticationServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationServer)), __LINE__);
        }
        $this->authenticationServer = $authenticationServer;
        return $this;
    }
    /**
     * Get directory value
     * @return string|null
     */
    public function getDirectory()
    {
        return $this->directory;
    }
    /**
     * Set directory value
     * @param string $directory
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setDirectory($directory = null)
    {
        // validation for constraint: string
        if (!is_null($directory) && !is_string($directory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directory)), __LINE__);
        }
        $this->directory = $directory;
        return $this;
    }
    /**
     * Get secureServicesUrl value
     * @return string|null
     */
    public function getSecureServicesUrl()
    {
        return $this->secureServicesUrl;
    }
    /**
     * Set secureServicesUrl value
     * @param string $secureServicesUrl
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSecureServicesUrl($secureServicesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureServicesUrl) && !is_string($secureServicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureServicesUrl)), __LINE__);
        }
        $this->secureServicesUrl = $secureServicesUrl;
        return $this;
    }
    /**
     * Get information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->information;
    }
    /**
     * Set information value
     * @param string $information
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($information)), __LINE__);
        }
        $this->information = $information;
        return $this;
    }
    /**
     * Get secureMessagesUrl value
     * @return string|null
     */
    public function getSecureMessagesUrl()
    {
        return $this->secureMessagesUrl;
    }
    /**
     * Set secureMessagesUrl value
     * @param string $secureMessagesUrl
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSecureMessagesUrl($secureMessagesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureMessagesUrl) && !is_string($secureMessagesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureMessagesUrl)), __LINE__);
        }
        $this->secureMessagesUrl = $secureMessagesUrl;
        return $this;
    }
    /**
     * Get secureInformationUrl value
     * @return string|null
     */
    public function getSecureInformationUrl()
    {
        return $this->secureInformationUrl;
    }
    /**
     * Set secureInformationUrl value
     * @param string $secureInformationUrl
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSecureInformationUrl($secureInformationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureInformationUrl) && !is_string($secureInformationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureInformationUrl)), __LINE__);
        }
        $this->secureInformationUrl = $secureInformationUrl;
        return $this;
    }
    /**
     * Get secureAuthenticationUrl value
     * @return string|null
     */
    public function getSecureAuthenticationUrl()
    {
        return $this->secureAuthenticationUrl;
    }
    /**
     * Set secureAuthenticationUrl value
     * @param string $secureAuthenticationUrl
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setSecureAuthenticationUrl($secureAuthenticationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureAuthenticationUrl) && !is_string($secureAuthenticationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureAuthenticationUrl)), __LINE__);
        }
        $this->secureAuthenticationUrl = $secureAuthenticationUrl;
        return $this;
    }
    /**
     * Get externalPhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalPhoneNumber()
    {
        return isset($this->externalPhoneNumber) ? $this->externalPhoneNumber : null;
    }
    /**
     * Set externalPhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalPhoneNumber
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setExternalPhoneNumber($externalPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalPhoneNumber) && !is_string($externalPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalPhoneNumber)), __LINE__);
        }
        if (is_null($externalPhoneNumber) || (is_array($externalPhoneNumber) && empty($externalPhoneNumber))) {
            unset($this->externalPhoneNumber);
        } else {
            $this->externalPhoneNumber = $externalPhoneNumber;
        }
        return $this;
    }
    /**
     * Get audibleMsgWaitingicatorPolicy value
     * @return string|null
     */
    public function getAudibleMsgWaitingicatorPolicy()
    {
        return $this->audibleMsgWaitingicatorPolicy;
    }
    /**
     * Set audibleMsgWaitingicatorPolicy value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMsgWaitingicatorPolicy
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setAudibleMsgWaitingicatorPolicy($audibleMsgWaitingicatorPolicy = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($audibleMsgWaitingicatorPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $audibleMsgWaitingicatorPolicy, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMsgWaitingicatorPolicy = $audibleMsgWaitingicatorPolicy;
        return $this;
    }
    /**
     * Get logMissedCalls value
     * @return string|null
     */
    public function getLogMissedCalls()
    {
        return $this->logMissedCalls;
    }
    /**
     * Set logMissedCalls value
     * @param string $logMissedCalls
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setLogMissedCalls($logMissedCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($logMissedCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $logMissedCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($logMissedCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($logMissedCalls) && !is_string($logMissedCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($logMissedCalls)), __LINE__);
        }
        $this->logMissedCalls = $logMissedCalls;
        return $this;
    }
    /**
     * Get visualMsgWaitingIndicatorPolicy value
     * @return string|null
     */
    public function getVisualMsgWaitingIndicatorPolicy()
    {
        return $this->visualMsgWaitingIndicatorPolicy;
    }
    /**
     * Set visualMsgWaitingIndicatorPolicy value
     * @uses XMWLPolicy::valueIsValid()
     * @uses XMWLPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $visualMsgWaitingIndicatorPolicy
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setVisualMsgWaitingIndicatorPolicy($visualMsgWaitingIndicatorPolicy = 'Use System Policy')
    {
        // validation for constraint: enumeration
        if (!XMWLPolicy::valueIsValid($visualMsgWaitingIndicatorPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $visualMsgWaitingIndicatorPolicy, implode(', ', XMWLPolicy::getValidValues())), __LINE__);
        }
        $this->visualMsgWaitingIndicatorPolicy = $visualMsgWaitingIndicatorPolicy;
        return $this;
    }
    /**
     * Get lineLabel value
     * @return string|null
     */
    public function getLineLabel()
    {
        return $this->lineLabel;
    }
    /**
     * Set lineLabel value
     * @param string $lineLabel
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setLineLabel($lineLabel = null)
    {
        // validation for constraint: string
        if (!is_null($lineLabel) && !is_string($lineLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineLabel)), __LINE__);
        }
        $this->lineLabel = $lineLabel;
        return $this;
    }
    /**
     * Get displayCallerId value
     * @return string|null
     */
    public function getDisplayCallerId()
    {
        return $this->displayCallerId;
    }
    /**
     * Set displayCallerId value
     * @param string $displayCallerId
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setDisplayCallerId($displayCallerId = null)
    {
        // validation for constraint: string
        if (!is_null($displayCallerId) && !is_string($displayCallerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayCallerId)), __LINE__);
        }
        $this->displayCallerId = $displayCallerId;
        return $this;
    }
    /**
     * Get MaxNumberOfCalls value
     * @return string|null
     */
    public function getMaxNumberOfCalls()
    {
        return $this->MaxNumberOfCalls;
    }
    /**
     * Set MaxNumberOfCalls value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumberOfCalls
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setMaxNumberOfCalls($maxNumberOfCalls = '2')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxNumberOfCalls)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxNumberOfCalls, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->MaxNumberOfCalls = $maxNumberOfCalls;
        return $this;
    }
    /**
     * Get ringSettingWhenPhoneIdle value
     * @return string|null
     */
    public function getRingSettingWhenPhoneIdle()
    {
        return $this->ringSettingWhenPhoneIdle;
    }
    /**
     * Set ringSettingWhenPhoneIdle value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingWhenPhoneIdle
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setRingSettingWhenPhoneIdle($ringSettingWhenPhoneIdle = 'Ring')
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($ringSettingWhenPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingWhenPhoneIdle, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingWhenPhoneIdle = $ringSettingWhenPhoneIdle;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setBusyTrigger($busyTrigger = '1')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $busyTrigger, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get ringSettingWhenPhoneInUse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRingSettingWhenPhoneInUse()
    {
        return isset($this->ringSettingWhenPhoneInUse) ? $this->ringSettingWhenPhoneInUse : null;
    }
    /**
     * Set ringSettingWhenPhoneInUse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingWhenPhoneInUse
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setRingSettingWhenPhoneInUse($ringSettingWhenPhoneInUse = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($ringSettingWhenPhoneInUse)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingWhenPhoneInUse, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($ringSettingWhenPhoneInUse) || (is_array($ringSettingWhenPhoneInUse) && empty($ringSettingWhenPhoneInUse))) {
            unset($this->ringSettingWhenPhoneInUse);
        } else {
            $this->ringSettingWhenPhoneInUse = $ringSettingWhenPhoneInUse;
        }
        return $this;
    }
    /**
     * Get directoryNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDirectoryNumber()
    {
        return isset($this->directoryNumber) ? $this->directoryNumber : null;
    }
    /**
     * Set directoryNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $directoryNumber
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setDirectoryNumber(XFkType $directoryNumber = null)
    {
        if (is_null($directoryNumber) || (is_array($directoryNumber) && empty($directoryNumber))) {
            unset($this->directoryNumber);
        } else {
            $this->directoryNumber = $directoryNumber;
        }
        return $this;
    }
    /**
     * Get recordingProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRecordingProfile()
    {
        return isset($this->recordingProfile) ? $this->recordingProfile : null;
    }
    /**
     * Set recordingProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $recordingProfile
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setRecordingProfile(XFkType $recordingProfile = null)
    {
        if (is_null($recordingProfile) || (is_array($recordingProfile) && empty($recordingProfile))) {
            unset($this->recordingProfile);
        } else {
            $this->recordingProfile = $recordingProfile;
        }
        return $this;
    }
    /**
     * Get callPickupGroupAudioAlertSettingPhoneActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallPickupGroupAudioAlertSettingPhoneActive()
    {
        return isset($this->callPickupGroupAudioAlertSettingPhoneActive) ? $this->callPickupGroupAudioAlertSettingPhoneActive : null;
    }
    /**
     * Set callPickupGroupAudioAlertSettingPhoneActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callPickupGroupAudioAlertSettingPhoneActive
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setCallPickupGroupAudioAlertSettingPhoneActive($callPickupGroupAudioAlertSettingPhoneActive = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($callPickupGroupAudioAlertSettingPhoneActive)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callPickupGroupAudioAlertSettingPhoneActive, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($callPickupGroupAudioAlertSettingPhoneActive) || (is_array($callPickupGroupAudioAlertSettingPhoneActive) && empty($callPickupGroupAudioAlertSettingPhoneActive))) {
            unset($this->callPickupGroupAudioAlertSettingPhoneActive);
        } else {
            $this->callPickupGroupAudioAlertSettingPhoneActive = $callPickupGroupAudioAlertSettingPhoneActive;
        }
        return $this;
    }
    /**
     * Get callPickupGroupAudioAlertSettingPhoneIdle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallPickupGroupAudioAlertSettingPhoneIdle()
    {
        return isset($this->callPickupGroupAudioAlertSettingPhoneIdle) ? $this->callPickupGroupAudioAlertSettingPhoneIdle : null;
    }
    /**
     * Set callPickupGroupAudioAlertSettingPhoneIdle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callPickupGroupAudioAlertSettingPhoneIdle
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setCallPickupGroupAudioAlertSettingPhoneIdle($callPickupGroupAudioAlertSettingPhoneIdle = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($callPickupGroupAudioAlertSettingPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callPickupGroupAudioAlertSettingPhoneIdle, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($callPickupGroupAudioAlertSettingPhoneIdle) || (is_array($callPickupGroupAudioAlertSettingPhoneIdle) && empty($callPickupGroupAudioAlertSettingPhoneIdle))) {
            unset($this->callPickupGroupAudioAlertSettingPhoneIdle);
        } else {
            $this->callPickupGroupAudioAlertSettingPhoneIdle = $callPickupGroupAudioAlertSettingPhoneIdle;
        }
        return $this;
    }
    /**
     * Get monitoringCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMonitoringCallingSearchSpace()
    {
        return isset($this->monitoringCallingSearchSpace) ? $this->monitoringCallingSearchSpace : null;
    }
    /**
     * Set monitoringCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $monitoringCallingSearchSpace
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setMonitoringCallingSearchSpace(XFkType $monitoringCallingSearchSpace = null)
    {
        if (is_null($monitoringCallingSearchSpace) || (is_array($monitoringCallingSearchSpace) && empty($monitoringCallingSearchSpace))) {
            unset($this->monitoringCallingSearchSpace);
        } else {
            $this->monitoringCallingSearchSpace = $monitoringCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param ConfidentialAccess $confidentialAccess
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setConfidentialAccess(ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get services value
     * @return Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param Services $services
     * @return UpdateUniversalDeviceTemplateReq
     */
    public function setServices(Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateUniversalDeviceTemplateReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
