<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUcServiceReq StructType
 * @subpackage Structs
 */
class UpdateUcServiceReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The hostnameorip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $hostnameorip;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence) and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $port;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence),CTI and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $protocol;
    /**
     * The ucServiceXml
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XVendorConfig
     */
    public $ucServiceXml;
    /**
     * Constructor method for UpdateUcServiceReq
     * @uses UpdateUcServiceReq::setNewName()
     * @uses UpdateUcServiceReq::setDescription()
     * @uses UpdateUcServiceReq::setHostnameorip()
     * @uses UpdateUcServiceReq::setPort()
     * @uses UpdateUcServiceReq::setProtocol()
     * @uses UpdateUcServiceReq::setUcServiceXml()
     * @param string $newName
     * @param string $description
     * @param string $hostnameorip
     * @param string $port
     * @param string $protocol
     * @param XVendorConfig $ucServiceXml
     */
    public function __construct($newName = null, $description = null, $hostnameorip = null, $port = null, $protocol = null, XVendorConfig $ucServiceXml = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setHostnameorip($hostnameorip)
            ->setPort($port)
            ->setProtocol($protocol)
            ->setUcServiceXml($ucServiceXml);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateUcServiceReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateUcServiceReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get hostnameorip value
     * @return string|null
     */
    public function getHostnameorip()
    {
        return $this->hostnameorip;
    }
    /**
     * Set hostnameorip value
     * @param string $hostnameorip
     * @return UpdateUcServiceReq
     */
    public function setHostnameorip($hostnameorip = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hostnameorip) && strlen($hostnameorip) > 255) || (is_array($hostnameorip) && count($hostnameorip) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($hostnameorip) ? strlen($hostnameorip) : count($hostnameorip)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hostnameorip) && !is_string($hostnameorip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostnameorip)), __LINE__);
        }
        $this->hostnameorip = $hostnameorip;
        return $this;
    }
    /**
     * Get port value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPort()
    {
        return isset($this->port) ? $this->port : null;
    }
    /**
     * Set port value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return UpdateUcServiceReq
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($port) || (is_array($port) && empty($port))) {
            unset($this->port);
        } else {
            $this->port = $port;
        }
        return $this;
    }
    /**
     * Get protocol value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProtocol()
    {
        return isset($this->protocol) ? $this->protocol : null;
    }
    /**
     * Set protocol value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XConnectProtocol::valueIsValid()
     * @uses XConnectProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return UpdateUcServiceReq
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XConnectProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XConnectProtocol::getValidValues())), __LINE__);
        }
        if (is_null($protocol) || (is_array($protocol) && empty($protocol))) {
            unset($this->protocol);
        } else {
            $this->protocol = $protocol;
        }
        return $this;
    }
    /**
     * Get ucServiceXml value
     * @return XVendorConfig|null
     */
    public function getUcServiceXml()
    {
        return $this->ucServiceXml;
    }
    /**
     * Set ucServiceXml value
     * @param XVendorConfig $ucServiceXml
     * @return UpdateUcServiceReq
     */
    public function setUcServiceXml(XVendorConfig $ucServiceXml = null)
    {
        $this->ucServiceXml = $ucServiceXml;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateUcServiceReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
