<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateResourcePriorityNamespaceListReq StructType
 * @subpackage Structs
 */
class UpdateResourcePriorityNamespaceListReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * Constructor method for UpdateResourcePriorityNamespaceListReq
     * @uses UpdateResourcePriorityNamespaceListReq::setNewName()
     * @uses UpdateResourcePriorityNamespaceListReq::setDescription()
     * @uses UpdateResourcePriorityNamespaceListReq::setRemoveMembers()
     * @uses UpdateResourcePriorityNamespaceListReq::setAddMembers()
     * @uses UpdateResourcePriorityNamespaceListReq::setMembers()
     * @param string $newName
     * @param string $description
     * @param RemoveMembers $removeMembers
     * @param AddMembers $addMembers
     * @param Members $members
     */
    public function __construct($newName = null, $description = null, RemoveMembers $removeMembers = null, AddMembers $addMembers = null, Members $members = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateResourcePriorityNamespaceListReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateResourcePriorityNamespaceListReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param RemoveMembers $removeMembers
     * @return UpdateResourcePriorityNamespaceListReq
     */
    public function setRemoveMembers(RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param AddMembers $addMembers
     * @return UpdateResourcePriorityNamespaceListReq
     */
    public function setAddMembers(AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return UpdateResourcePriorityNamespaceListReq
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateResourcePriorityNamespaceListReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
