<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRecordingProfileReq StructType
 * @subpackage Structs
 */
class UpdateRecordingProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The recordingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $recordingCssName;
    /**
     * The recorderDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $recorderDestination;
    /**
     * Constructor method for UpdateRecordingProfileReq
     * @uses UpdateRecordingProfileReq::setNewName()
     * @uses UpdateRecordingProfileReq::setRecordingCssName()
     * @uses UpdateRecordingProfileReq::setRecorderDestination()
     * @param string $newName
     * @param XFkType $recordingCssName
     * @param string $recorderDestination
     */
    public function __construct($newName = null, XFkType $recordingCssName = null, $recorderDestination = null)
    {
        $this
            ->setNewName($newName)
            ->setRecordingCssName($recordingCssName)
            ->setRecorderDestination($recorderDestination);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateRecordingProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get recordingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRecordingCssName()
    {
        return isset($this->recordingCssName) ? $this->recordingCssName : null;
    }
    /**
     * Set recordingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $recordingCssName
     * @return UpdateRecordingProfileReq
     */
    public function setRecordingCssName(XFkType $recordingCssName = null)
    {
        if (is_null($recordingCssName) || (is_array($recordingCssName) && empty($recordingCssName))) {
            unset($this->recordingCssName);
        } else {
            $this->recordingCssName = $recordingCssName;
        }
        return $this;
    }
    /**
     * Get recorderDestination value
     * @return string|null
     */
    public function getRecorderDestination()
    {
        return $this->recorderDestination;
    }
    /**
     * Set recorderDestination value
     * @param string $recorderDestination
     * @return UpdateRecordingProfileReq
     */
    public function setRecorderDestination($recorderDestination = null)
    {
        // validation for constraint: string
        if (!is_null($recorderDestination) && !is_string($recorderDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recorderDestination)), __LINE__);
        }
        $this->recorderDestination = $recorderDestination;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateRecordingProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
