<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePhoneNtpReq StructType
 * @subpackage Structs
 */
class UpdatePhoneNtpReq extends APIRequest
{
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newIpAddress;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The mode
     * Meta informations extracted from the WSDL
     * - default: Directed Broadcast
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mode;
    /**
     * Constructor method for UpdatePhoneNtpReq
     * @uses UpdatePhoneNtpReq::setIpAddress()
     * @uses UpdatePhoneNtpReq::setUuid()
     * @uses UpdatePhoneNtpReq::setNewIpAddress()
     * @uses UpdatePhoneNtpReq::setDescription()
     * @uses UpdatePhoneNtpReq::setMode()
     * @param string $ipAddress
     * @param string $uuid
     * @param string $newIpAddress
     * @param string $description
     * @param string $mode
     */
    public function __construct($ipAddress = null, $uuid = null, $newIpAddress = null, $description = null, $mode = 'Directed Broadcast')
    {
        $this
            ->setIpAddress($ipAddress)
            ->setUuid($uuid)
            ->setNewIpAddress($newIpAddress)
            ->setDescription($description)
            ->setMode($mode);
    }
    /**
     * Get ipAddress value
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return UpdatePhoneNtpReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return UpdatePhoneNtpReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newIpAddress value
     * @return string|null
     */
    public function getNewIpAddress()
    {
        return $this->newIpAddress;
    }
    /**
     * Set newIpAddress value
     * @param string $newIpAddress
     * @return UpdatePhoneNtpReq
     */
    public function setNewIpAddress($newIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($newIpAddress) && !is_string($newIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newIpAddress)), __LINE__);
        }
        $this->newIpAddress = $newIpAddress;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdatePhoneNtpReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @uses XZzntpmode::valueIsValid()
     * @uses XZzntpmode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mode
     * @return UpdatePhoneNtpReq
     */
    public function setMode($mode = 'Directed Broadcast')
    {
        // validation for constraint: enumeration
        if (!XZzntpmode::valueIsValid($mode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mode, implode(', ', XZzntpmode::getValidValues())), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdatePhoneNtpReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
