<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePageLayoutPreferencesReq StructType
 * @subpackage Structs
 */
class UpdatePageLayoutPreferencesReq extends APIRequest
{
    /**
     * The pageName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pageName;
    /**
     * The pageSections
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var PageSections
     */
    public $pageSections;
    /**
     * Constructor method for UpdatePageLayoutPreferencesReq
     * @uses UpdatePageLayoutPreferencesReq::setPageName()
     * @uses UpdatePageLayoutPreferencesReq::setPageSections()
     * @param string $pageName
     * @param PageSections $pageSections
     */
    public function __construct($pageName = null, PageSections $pageSections = null)
    {
        $this
            ->setPageName($pageName)
            ->setPageSections($pageSections);
    }
    /**
     * Get pageName value
     * @return string
     */
    public function getPageName()
    {
        return $this->pageName;
    }
    /**
     * Set pageName value
     * @param string $pageName
     * @return UpdatePageLayoutPreferencesReq
     */
    public function setPageName($pageName = null)
    {
        // validation for constraint: string
        if (!is_null($pageName) && !is_string($pageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageName)), __LINE__);
        }
        $this->pageName = $pageName;
        return $this;
    }
    /**
     * Get pageSections value
     * @return PageSections
     */
    public function getPageSections()
    {
        return $this->pageSections;
    }
    /**
     * Set pageSections value
     * @param PageSections $pageSections
     * @return UpdatePageLayoutPreferencesReq
     */
    public function setPageSections(PageSections $pageSections = null)
    {
        $this->pageSections = $pageSections;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdatePageLayoutPreferencesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
