<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLdapSyncCustomFieldReq StructType
 * @subpackage Structs
 */
class UpdateLdapSyncCustomFieldReq extends APIRequest
{
    /**
     * The ldapConfigurationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapConfigurationName;
    /**
     * The customUserField
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $customUserField;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The ldapUserField
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapUserField;
    /**
     * Constructor method for UpdateLdapSyncCustomFieldReq
     * @uses UpdateLdapSyncCustomFieldReq::setLdapConfigurationName()
     * @uses UpdateLdapSyncCustomFieldReq::setCustomUserField()
     * @uses UpdateLdapSyncCustomFieldReq::setUuid()
     * @uses UpdateLdapSyncCustomFieldReq::setLdapUserField()
     * @param string $ldapConfigurationName
     * @param string $customUserField
     * @param string $uuid
     * @param string $ldapUserField
     */
    public function __construct($ldapConfigurationName = null, $customUserField = null, $uuid = null, $ldapUserField = null)
    {
        $this
            ->setLdapConfigurationName($ldapConfigurationName)
            ->setCustomUserField($customUserField)
            ->setUuid($uuid)
            ->setLdapUserField($ldapUserField);
    }
    /**
     * Get ldapConfigurationName value
     * @return string
     */
    public function getLdapConfigurationName()
    {
        return $this->ldapConfigurationName;
    }
    /**
     * Set ldapConfigurationName value
     * @param string $ldapConfigurationName
     * @return UpdateLdapSyncCustomFieldReq
     */
    public function setLdapConfigurationName($ldapConfigurationName = null)
    {
        // validation for constraint: string
        if (!is_null($ldapConfigurationName) && !is_string($ldapConfigurationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapConfigurationName)), __LINE__);
        }
        $this->ldapConfigurationName = $ldapConfigurationName;
        return $this;
    }
    /**
     * Get customUserField value
     * @return string
     */
    public function getCustomUserField()
    {
        return $this->customUserField;
    }
    /**
     * Set customUserField value
     * @param string $customUserField
     * @return UpdateLdapSyncCustomFieldReq
     */
    public function setCustomUserField($customUserField = null)
    {
        // validation for constraint: string
        if (!is_null($customUserField) && !is_string($customUserField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customUserField)), __LINE__);
        }
        $this->customUserField = $customUserField;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return UpdateLdapSyncCustomFieldReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get ldapUserField value
     * @return string|null
     */
    public function getLdapUserField()
    {
        return $this->ldapUserField;
    }
    /**
     * Set ldapUserField value
     * @param string $ldapUserField
     * @return UpdateLdapSyncCustomFieldReq
     */
    public function setLdapUserField($ldapUserField = null)
    {
        // validation for constraint: string
        if (!is_null($ldapUserField) && !is_string($ldapUserField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapUserField)), __LINE__);
        }
        $this->ldapUserField = $ldapUserField;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateLdapSyncCustomFieldReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
