<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeClientReq StructType
 * @subpackage Structs
 */
class UpdateImeClientReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $domain;
    /**
     * The isActivated
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The sipTrunkName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $sipTrunkName;
    /**
     * The primaryImeServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $primaryImeServerName;
    /**
     * The secondaryImeServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $secondaryImeServerName;
    /**
     * The learnedRouteFilterGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $learnedRouteFilterGroupName;
    /**
     * The exclusionNumberGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $exclusionNumberGroupName;
    /**
     * The firewallName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $firewallName;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The removeCcmExternalIpMaps
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RemoveCcmExternalIpMaps
     */
    public $removeCcmExternalIpMaps;
    /**
     * The addCcmExternalIpMaps
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddCcmExternalIpMaps
     */
    public $addCcmExternalIpMaps;
    /**
     * The ccmExternalIpMaps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var CcmExternalIpMaps
     */
    public $ccmExternalIpMaps;
    /**
     * Constructor method for UpdateImeClientReq
     * @uses UpdateImeClientReq::setNewName()
     * @uses UpdateImeClientReq::setDescription()
     * @uses UpdateImeClientReq::setDomain()
     * @uses UpdateImeClientReq::setIsActivated()
     * @uses UpdateImeClientReq::setSipTrunkName()
     * @uses UpdateImeClientReq::setPrimaryImeServerName()
     * @uses UpdateImeClientReq::setSecondaryImeServerName()
     * @uses UpdateImeClientReq::setLearnedRouteFilterGroupName()
     * @uses UpdateImeClientReq::setExclusionNumberGroupName()
     * @uses UpdateImeClientReq::setFirewallName()
     * @uses UpdateImeClientReq::setRemoveMembers()
     * @uses UpdateImeClientReq::setAddMembers()
     * @uses UpdateImeClientReq::setMembers()
     * @uses UpdateImeClientReq::setRemoveCcmExternalIpMaps()
     * @uses UpdateImeClientReq::setAddCcmExternalIpMaps()
     * @uses UpdateImeClientReq::setCcmExternalIpMaps()
     * @param string $newName
     * @param string $description
     * @param string $domain
     * @param string $isActivated
     * @param XFkType $sipTrunkName
     * @param XFkType $primaryImeServerName
     * @param XFkType $secondaryImeServerName
     * @param XFkType $learnedRouteFilterGroupName
     * @param XFkType $exclusionNumberGroupName
     * @param XFkType $firewallName
     * @param RemoveMembers $removeMembers
     * @param AddMembers $addMembers
     * @param Members $members
     * @param RemoveCcmExternalIpMaps $removeCcmExternalIpMaps
     * @param AddCcmExternalIpMaps $addCcmExternalIpMaps
     * @param CcmExternalIpMaps $ccmExternalIpMaps
     */
    public function __construct($newName = null, $description = null, $domain = null, $isActivated = false, XFkType $sipTrunkName = null, XFkType $primaryImeServerName = null, XFkType $secondaryImeServerName = null, XFkType $learnedRouteFilterGroupName = null, XFkType $exclusionNumberGroupName = null, XFkType $firewallName = null, RemoveMembers $removeMembers = null, AddMembers $addMembers = null, Members $members = null, RemoveCcmExternalIpMaps $removeCcmExternalIpMaps = null, AddCcmExternalIpMaps $addCcmExternalIpMaps = null, CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setDomain($domain)
            ->setIsActivated($isActivated)
            ->setSipTrunkName($sipTrunkName)
            ->setPrimaryImeServerName($primaryImeServerName)
            ->setSecondaryImeServerName($secondaryImeServerName)
            ->setLearnedRouteFilterGroupName($learnedRouteFilterGroupName)
            ->setExclusionNumberGroupName($exclusionNumberGroupName)
            ->setFirewallName($firewallName)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setRemoveCcmExternalIpMaps($removeCcmExternalIpMaps)
            ->setAddCcmExternalIpMaps($addCcmExternalIpMaps)
            ->setCcmExternalIpMaps($ccmExternalIpMaps);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateImeClientReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateImeClientReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return UpdateImeClientReq
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($domain) && strlen($domain) > 255) || (is_array($domain) && count($domain) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($domain) ? strlen($domain) : count($domain)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return UpdateImeClientReq
     */
    public function setIsActivated($isActivated = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActivated, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param XFkType $sipTrunkName
     * @return UpdateImeClientReq
     */
    public function setSipTrunkName(XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get primaryImeServerName value
     * @return XFkType|null
     */
    public function getPrimaryImeServerName()
    {
        return $this->primaryImeServerName;
    }
    /**
     * Set primaryImeServerName value
     * @param XFkType $primaryImeServerName
     * @return UpdateImeClientReq
     */
    public function setPrimaryImeServerName(XFkType $primaryImeServerName = null)
    {
        $this->primaryImeServerName = $primaryImeServerName;
        return $this;
    }
    /**
     * Get secondaryImeServerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSecondaryImeServerName()
    {
        return isset($this->secondaryImeServerName) ? $this->secondaryImeServerName : null;
    }
    /**
     * Set secondaryImeServerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $secondaryImeServerName
     * @return UpdateImeClientReq
     */
    public function setSecondaryImeServerName(XFkType $secondaryImeServerName = null)
    {
        if (is_null($secondaryImeServerName) || (is_array($secondaryImeServerName) && empty($secondaryImeServerName))) {
            unset($this->secondaryImeServerName);
        } else {
            $this->secondaryImeServerName = $secondaryImeServerName;
        }
        return $this;
    }
    /**
     * Get learnedRouteFilterGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getLearnedRouteFilterGroupName()
    {
        return isset($this->learnedRouteFilterGroupName) ? $this->learnedRouteFilterGroupName : null;
    }
    /**
     * Set learnedRouteFilterGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $learnedRouteFilterGroupName
     * @return UpdateImeClientReq
     */
    public function setLearnedRouteFilterGroupName(XFkType $learnedRouteFilterGroupName = null)
    {
        if (is_null($learnedRouteFilterGroupName) || (is_array($learnedRouteFilterGroupName) && empty($learnedRouteFilterGroupName))) {
            unset($this->learnedRouteFilterGroupName);
        } else {
            $this->learnedRouteFilterGroupName = $learnedRouteFilterGroupName;
        }
        return $this;
    }
    /**
     * Get exclusionNumberGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getExclusionNumberGroupName()
    {
        return isset($this->exclusionNumberGroupName) ? $this->exclusionNumberGroupName : null;
    }
    /**
     * Set exclusionNumberGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $exclusionNumberGroupName
     * @return UpdateImeClientReq
     */
    public function setExclusionNumberGroupName(XFkType $exclusionNumberGroupName = null)
    {
        if (is_null($exclusionNumberGroupName) || (is_array($exclusionNumberGroupName) && empty($exclusionNumberGroupName))) {
            unset($this->exclusionNumberGroupName);
        } else {
            $this->exclusionNumberGroupName = $exclusionNumberGroupName;
        }
        return $this;
    }
    /**
     * Get firewallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getFirewallName()
    {
        return isset($this->firewallName) ? $this->firewallName : null;
    }
    /**
     * Set firewallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $firewallName
     * @return UpdateImeClientReq
     */
    public function setFirewallName(XFkType $firewallName = null)
    {
        if (is_null($firewallName) || (is_array($firewallName) && empty($firewallName))) {
            unset($this->firewallName);
        } else {
            $this->firewallName = $firewallName;
        }
        return $this;
    }
    /**
     * Get removeMembers value
     * @return RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param RemoveMembers $removeMembers
     * @return UpdateImeClientReq
     */
    public function setRemoveMembers(RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param AddMembers $addMembers
     * @return UpdateImeClientReq
     */
    public function setAddMembers(AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return UpdateImeClientReq
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get removeCcmExternalIpMaps value
     * @return RemoveCcmExternalIpMaps|null
     */
    public function getRemoveCcmExternalIpMaps()
    {
        return $this->removeCcmExternalIpMaps;
    }
    /**
     * Set removeCcmExternalIpMaps value
     * @param RemoveCcmExternalIpMaps $removeCcmExternalIpMaps
     * @return UpdateImeClientReq
     */
    public function setRemoveCcmExternalIpMaps(RemoveCcmExternalIpMaps $removeCcmExternalIpMaps = null)
    {
        $this->removeCcmExternalIpMaps = $removeCcmExternalIpMaps;
        return $this;
    }
    /**
     * Get addCcmExternalIpMaps value
     * @return AddCcmExternalIpMaps|null
     */
    public function getAddCcmExternalIpMaps()
    {
        return $this->addCcmExternalIpMaps;
    }
    /**
     * Set addCcmExternalIpMaps value
     * @param AddCcmExternalIpMaps $addCcmExternalIpMaps
     * @return UpdateImeClientReq
     */
    public function setAddCcmExternalIpMaps(AddCcmExternalIpMaps $addCcmExternalIpMaps = null)
    {
        $this->addCcmExternalIpMaps = $addCcmExternalIpMaps;
        return $this;
    }
    /**
     * Get ccmExternalIpMaps value
     * @return CcmExternalIpMaps|null
     */
    public function getCcmExternalIpMaps()
    {
        return $this->ccmExternalIpMaps;
    }
    /**
     * Set ccmExternalIpMaps value
     * @param CcmExternalIpMaps $ccmExternalIpMaps
     * @return UpdateImeClientReq
     */
    public function setCcmExternalIpMaps(CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        $this->ccmExternalIpMaps = $ccmExternalIpMaps;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateImeClientReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
