<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateIlsConfigReq StructType
 * @subpackage Structs
 */
class UpdateIlsConfigReq extends APIRequest
{
    /**
     * The role
     * @var string
     */
    public $role;
    /**
     * The registrationServer
     * @var string
     */
    public $registrationServer;
    /**
     * The activateIls
     * Meta informations extracted from the WSDL
     * - documentation: The tag is still not supported from AXL side.It is just a dummy tag.
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $activateIls;
    /**
     * The synchronizeClustersEvery
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * @var string
     */
    public $synchronizeClustersEvery;
    /**
     * The activatedServers
     * Meta informations extracted from the WSDL
     * - documentation: The tag is still not supported from AXL side.It is just a dummy tag.
     * @var string
     */
    public $activatedServers;
    /**
     * The deactivatedServers
     * Meta informations extracted from the WSDL
     * - documentation: The tag is still not supported from AXL side.It is just a dummy tag.
     * @var string
     */
    public $deactivatedServers;
    /**
     * The useTls
     * Meta informations extracted from the WSDL
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useTls;
    /**
     * The usePassword
     * @var string
     */
    public $usePassword;
    /**
     * Constructor method for UpdateIlsConfigReq
     * @uses UpdateIlsConfigReq::setRole()
     * @uses UpdateIlsConfigReq::setRegistrationServer()
     * @uses UpdateIlsConfigReq::setActivateIls()
     * @uses UpdateIlsConfigReq::setSynchronizeClustersEvery()
     * @uses UpdateIlsConfigReq::setActivatedServers()
     * @uses UpdateIlsConfigReq::setDeactivatedServers()
     * @uses UpdateIlsConfigReq::setUseTls()
     * @uses UpdateIlsConfigReq::setUsePassword()
     * @param string $role
     * @param string $registrationServer
     * @param string $activateIls
     * @param string $synchronizeClustersEvery
     * @param string $activatedServers
     * @param string $deactivatedServers
     * @param string $useTls
     * @param string $usePassword
     */
    public function __construct($role = null, $registrationServer = null, $activateIls = null, $synchronizeClustersEvery = null, $activatedServers = null, $deactivatedServers = null, $useTls = null, $usePassword = null)
    {
        $this
            ->setRole($role)
            ->setRegistrationServer($registrationServer)
            ->setActivateIls($activateIls)
            ->setSynchronizeClustersEvery($synchronizeClustersEvery)
            ->setActivatedServers($activatedServers)
            ->setDeactivatedServers($deactivatedServers)
            ->setUseTls($useTls)
            ->setUsePassword($usePassword);
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return UpdateIlsConfigReq
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get registrationServer value
     * @return string|null
     */
    public function getRegistrationServer()
    {
        return $this->registrationServer;
    }
    /**
     * Set registrationServer value
     * @param string $registrationServer
     * @return UpdateIlsConfigReq
     */
    public function setRegistrationServer($registrationServer = null)
    {
        // validation for constraint: string
        if (!is_null($registrationServer) && !is_string($registrationServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationServer)), __LINE__);
        }
        $this->registrationServer = $registrationServer;
        return $this;
    }
    /**
     * Get activateIls value
     * @return string|null
     */
    public function getActivateIls()
    {
        return $this->activateIls;
    }
    /**
     * Set activateIls value
     * @param string $activateIls
     * @return UpdateIlsConfigReq
     */
    public function setActivateIls($activateIls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($activateIls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $activateIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($activateIls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($activateIls) && !is_string($activateIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activateIls)), __LINE__);
        }
        $this->activateIls = $activateIls;
        return $this;
    }
    /**
     * Get synchronizeClustersEvery value
     * @return string|null
     */
    public function getSynchronizeClustersEvery()
    {
        return $this->synchronizeClustersEvery;
    }
    /**
     * Set synchronizeClustersEvery value
     * @param string $synchronizeClustersEvery
     * @return UpdateIlsConfigReq
     */
    public function setSynchronizeClustersEvery($synchronizeClustersEvery = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($synchronizeClustersEvery) && strlen($synchronizeClustersEvery) > 50) || (is_array($synchronizeClustersEvery) && count($synchronizeClustersEvery) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($synchronizeClustersEvery) ? strlen($synchronizeClustersEvery) : count($synchronizeClustersEvery)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($synchronizeClustersEvery) && !is_string($synchronizeClustersEvery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($synchronizeClustersEvery)), __LINE__);
        }
        $this->synchronizeClustersEvery = $synchronizeClustersEvery;
        return $this;
    }
    /**
     * Get activatedServers value
     * @return string|null
     */
    public function getActivatedServers()
    {
        return $this->activatedServers;
    }
    /**
     * Set activatedServers value
     * @param string $activatedServers
     * @return UpdateIlsConfigReq
     */
    public function setActivatedServers($activatedServers = null)
    {
        // validation for constraint: string
        if (!is_null($activatedServers) && !is_string($activatedServers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activatedServers)), __LINE__);
        }
        $this->activatedServers = $activatedServers;
        return $this;
    }
    /**
     * Get deactivatedServers value
     * @return string|null
     */
    public function getDeactivatedServers()
    {
        return $this->deactivatedServers;
    }
    /**
     * Set deactivatedServers value
     * @param string $deactivatedServers
     * @return UpdateIlsConfigReq
     */
    public function setDeactivatedServers($deactivatedServers = null)
    {
        // validation for constraint: string
        if (!is_null($deactivatedServers) && !is_string($deactivatedServers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deactivatedServers)), __LINE__);
        }
        $this->deactivatedServers = $deactivatedServers;
        return $this;
    }
    /**
     * Get useTls value
     * @return string|null
     */
    public function getUseTls()
    {
        return $this->useTls;
    }
    /**
     * Set useTls value
     * @param string $useTls
     * @return UpdateIlsConfigReq
     */
    public function setUseTls($useTls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useTls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useTls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useTls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useTls) && !is_string($useTls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useTls)), __LINE__);
        }
        $this->useTls = $useTls;
        return $this;
    }
    /**
     * Get usePassword value
     * @return string|null
     */
    public function getUsePassword()
    {
        return $this->usePassword;
    }
    /**
     * Set usePassword value
     * @param string $usePassword
     * @return UpdateIlsConfigReq
     */
    public function setUsePassword($usePassword = null)
    {
        // validation for constraint: string
        if (!is_null($usePassword) && !is_string($usePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usePassword)), __LINE__);
        }
        $this->usePassword = $usePassword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateIlsConfigReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
