<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCcdRequestingServiceReq StructType
 * @subpackage Structs
 */
class UpdateCcdRequestingServiceReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The isActivated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The learnedPatternPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $learnedPatternPrefix;
    /**
     * The pstnPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $pstnPrefix;
    /**
     * The removeAssociatedTrunks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RemoveAssociatedTrunks
     */
    public $removeAssociatedTrunks;
    /**
     * The addAssociatedTrunks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddAssociatedTrunks
     */
    public $addAssociatedTrunks;
    /**
     * The associatedTrunks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AssociatedTrunks
     */
    public $associatedTrunks;
    /**
     * Constructor method for UpdateCcdRequestingServiceReq
     * @uses UpdateCcdRequestingServiceReq::setNewName()
     * @uses UpdateCcdRequestingServiceReq::setDescription()
     * @uses UpdateCcdRequestingServiceReq::setIsActivated()
     * @uses UpdateCcdRequestingServiceReq::setRoutePartitionName()
     * @uses UpdateCcdRequestingServiceReq::setLearnedPatternPrefix()
     * @uses UpdateCcdRequestingServiceReq::setPstnPrefix()
     * @uses UpdateCcdRequestingServiceReq::setRemoveAssociatedTrunks()
     * @uses UpdateCcdRequestingServiceReq::setAddAssociatedTrunks()
     * @uses UpdateCcdRequestingServiceReq::setAssociatedTrunks()
     * @param string $newName
     * @param string $description
     * @param string $isActivated
     * @param XFkType $routePartitionName
     * @param string $learnedPatternPrefix
     * @param string $pstnPrefix
     * @param RemoveAssociatedTrunks $removeAssociatedTrunks
     * @param AddAssociatedTrunks $addAssociatedTrunks
     * @param AssociatedTrunks $associatedTrunks
     */
    public function __construct($newName = null, $description = null, $isActivated = null, XFkType $routePartitionName = null, $learnedPatternPrefix = null, $pstnPrefix = null, RemoveAssociatedTrunks $removeAssociatedTrunks = null, AddAssociatedTrunks $addAssociatedTrunks = null, AssociatedTrunks $associatedTrunks = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setIsActivated($isActivated)
            ->setRoutePartitionName($routePartitionName)
            ->setLearnedPatternPrefix($learnedPatternPrefix)
            ->setPstnPrefix($pstnPrefix)
            ->setRemoveAssociatedTrunks($removeAssociatedTrunks)
            ->setAddAssociatedTrunks($addAssociatedTrunks)
            ->setAssociatedTrunks($associatedTrunks);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateCcdRequestingServiceReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateCcdRequestingServiceReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return UpdateCcdRequestingServiceReq
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActivated, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $routePartitionName
     * @return UpdateCcdRequestingServiceReq
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get learnedPatternPrefix value
     * @return string|null
     */
    public function getLearnedPatternPrefix()
    {
        return $this->learnedPatternPrefix;
    }
    /**
     * Set learnedPatternPrefix value
     * @param string $learnedPatternPrefix
     * @return UpdateCcdRequestingServiceReq
     */
    public function setLearnedPatternPrefix($learnedPatternPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($learnedPatternPrefix) && strlen($learnedPatternPrefix) > 50) || (is_array($learnedPatternPrefix) && count($learnedPatternPrefix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($learnedPatternPrefix) ? strlen($learnedPatternPrefix) : count($learnedPatternPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($learnedPatternPrefix) && !is_string($learnedPatternPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($learnedPatternPrefix)), __LINE__);
        }
        $this->learnedPatternPrefix = $learnedPatternPrefix;
        return $this;
    }
    /**
     * Get pstnPrefix value
     * @return string|null
     */
    public function getPstnPrefix()
    {
        return $this->pstnPrefix;
    }
    /**
     * Set pstnPrefix value
     * @param string $pstnPrefix
     * @return UpdateCcdRequestingServiceReq
     */
    public function setPstnPrefix($pstnPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pstnPrefix) && strlen($pstnPrefix) > 50) || (is_array($pstnPrefix) && count($pstnPrefix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($pstnPrefix) ? strlen($pstnPrefix) : count($pstnPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnPrefix) && !is_string($pstnPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnPrefix)), __LINE__);
        }
        $this->pstnPrefix = $pstnPrefix;
        return $this;
    }
    /**
     * Get removeAssociatedTrunks value
     * @return RemoveAssociatedTrunks|null
     */
    public function getRemoveAssociatedTrunks()
    {
        return $this->removeAssociatedTrunks;
    }
    /**
     * Set removeAssociatedTrunks value
     * @param RemoveAssociatedTrunks $removeAssociatedTrunks
     * @return UpdateCcdRequestingServiceReq
     */
    public function setRemoveAssociatedTrunks(RemoveAssociatedTrunks $removeAssociatedTrunks = null)
    {
        $this->removeAssociatedTrunks = $removeAssociatedTrunks;
        return $this;
    }
    /**
     * Get addAssociatedTrunks value
     * @return AddAssociatedTrunks|null
     */
    public function getAddAssociatedTrunks()
    {
        return $this->addAssociatedTrunks;
    }
    /**
     * Set addAssociatedTrunks value
     * @param AddAssociatedTrunks $addAssociatedTrunks
     * @return UpdateCcdRequestingServiceReq
     */
    public function setAddAssociatedTrunks(AddAssociatedTrunks $addAssociatedTrunks = null)
    {
        $this->addAssociatedTrunks = $addAssociatedTrunks;
        return $this;
    }
    /**
     * Get associatedTrunks value
     * @return AssociatedTrunks|null
     */
    public function getAssociatedTrunks()
    {
        return $this->associatedTrunks;
    }
    /**
     * Set associatedTrunks value
     * @param AssociatedTrunks $associatedTrunks
     * @return UpdateCcdRequestingServiceReq
     */
    public function setAssociatedTrunks(AssociatedTrunks $associatedTrunks = null)
    {
        $this->associatedTrunks = $associatedTrunks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateCcdRequestingServiceReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
