<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RVoiceMailProfile StructType
 * @subpackage Structs
 */
class RVoiceMailProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The isDefault
     * Meta informations extracted from the WSDL
     * - documentation: In Update setting isDefault tag as false would not disable this VoiceMailProfile as Default. Instead, the corresponding tag of another VoiceMailProfile should be set to true.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The voiceMailboxMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $voiceMailboxMask;
    /**
     * The voiceMailPilot
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RVmPilot
     */
    public $voiceMailPilot;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RVoiceMailProfile
     * @uses RVoiceMailProfile::setName()
     * @uses RVoiceMailProfile::setDescription()
     * @uses RVoiceMailProfile::setIsDefault()
     * @uses RVoiceMailProfile::setVoiceMailboxMask()
     * @uses RVoiceMailProfile::setVoiceMailPilot()
     * @uses RVoiceMailProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $isDefault
     * @param string $voiceMailboxMask
     * @param RVmPilot $voiceMailPilot
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $isDefault = null, $voiceMailboxMask = null, RVmPilot $voiceMailPilot = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsDefault($isDefault)
            ->setVoiceMailboxMask($voiceMailboxMask)
            ->setVoiceMailPilot($voiceMailPilot)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RVoiceMailProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RVoiceMailProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return RVoiceMailProfile
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get voiceMailboxMask value
     * @return string|null
     */
    public function getVoiceMailboxMask()
    {
        return $this->voiceMailboxMask;
    }
    /**
     * Set voiceMailboxMask value
     * @param string $voiceMailboxMask
     * @return RVoiceMailProfile
     */
    public function setVoiceMailboxMask($voiceMailboxMask = null)
    {
        // validation for constraint: string
        if (!is_null($voiceMailboxMask) && !is_string($voiceMailboxMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voiceMailboxMask)), __LINE__);
        }
        $this->voiceMailboxMask = $voiceMailboxMask;
        return $this;
    }
    /**
     * Get voiceMailPilot value
     * @return RVmPilot|null
     */
    public function getVoiceMailPilot()
    {
        return $this->voiceMailPilot;
    }
    /**
     * Set voiceMailPilot value
     * @param RVmPilot $voiceMailPilot
     * @return RVoiceMailProfile
     */
    public function setVoiceMailPilot(RVmPilot $voiceMailPilot = null)
    {
        $this->voiceMailPilot = $voiceMailPilot;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RVoiceMailProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RVoiceMailProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
