<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RTODAccessMember StructType
 * @subpackage Structs
 */
class RTODAccessMember extends AbstractStructBase
{
    /**
     * The timeScheduleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $timeScheduleName;
    /**
     * The accessListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $accessListName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RTODAccessMember
     * @uses RTODAccessMember::setTimeScheduleName()
     * @uses RTODAccessMember::setAccessListName()
     * @uses RTODAccessMember::setUuid()
     * @param XFkType $timeScheduleName
     * @param XFkType $accessListName
     * @param string $uuid
     */
    public function __construct(XFkType $timeScheduleName = null, XFkType $accessListName = null, $uuid = null)
    {
        $this
            ->setTimeScheduleName($timeScheduleName)
            ->setAccessListName($accessListName)
            ->setUuid($uuid);
    }
    /**
     * Get timeScheduleName value
     * @return XFkType|null
     */
    public function getTimeScheduleName()
    {
        return $this->timeScheduleName;
    }
    /**
     * Set timeScheduleName value
     * @param XFkType $timeScheduleName
     * @return RTODAccessMember
     */
    public function setTimeScheduleName(XFkType $timeScheduleName = null)
    {
        $this->timeScheduleName = $timeScheduleName;
        return $this;
    }
    /**
     * Get accessListName value
     * @return XFkType|null
     */
    public function getAccessListName()
    {
        return $this->accessListName;
    }
    /**
     * Set accessListName value
     * @param XFkType $accessListName
     * @return RTODAccessMember
     */
    public function setAccessListName(XFkType $accessListName = null)
    {
        $this->accessListName = $accessListName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RTODAccessMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RTODAccessMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
