<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSyslogConfig StructType
 * @subpackage Structs
 */
class RSyslogConfig extends AbstractStructBase
{
    /**
     * The AlarmLevelEvent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AlarmLevelEvent;
    /**
     * The RemoteServerName1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RemoteServerName1;
    /**
     * The RemoteServerName2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RemoteServerName2;
    /**
     * The RemoteServerName3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RemoteServerName3;
    /**
     * The RemoteServerName4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RemoteServerName4;
    /**
     * The RemoteServerName5
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RemoteServerName5;
    /**
     * The monitor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $monitor;
    /**
     * The Enable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $Enable;
    /**
     * Constructor method for RSyslogConfig
     * @uses RSyslogConfig::setAlarmLevelEvent()
     * @uses RSyslogConfig::setRemoteServerName1()
     * @uses RSyslogConfig::setRemoteServerName2()
     * @uses RSyslogConfig::setRemoteServerName3()
     * @uses RSyslogConfig::setRemoteServerName4()
     * @uses RSyslogConfig::setRemoteServerName5()
     * @uses RSyslogConfig::setMonitor()
     * @uses RSyslogConfig::setEnable()
     * @param string $alarmLevelEvent
     * @param string $remoteServerName1
     * @param string $remoteServerName2
     * @param string $remoteServerName3
     * @param string $remoteServerName4
     * @param string $remoteServerName5
     * @param string $monitor
     * @param string $enable
     */
    public function __construct($alarmLevelEvent = null, $remoteServerName1 = null, $remoteServerName2 = null, $remoteServerName3 = null, $remoteServerName4 = null, $remoteServerName5 = null, $monitor = null, $enable = null)
    {
        $this
            ->setAlarmLevelEvent($alarmLevelEvent)
            ->setRemoteServerName1($remoteServerName1)
            ->setRemoteServerName2($remoteServerName2)
            ->setRemoteServerName3($remoteServerName3)
            ->setRemoteServerName4($remoteServerName4)
            ->setRemoteServerName5($remoteServerName5)
            ->setMonitor($monitor)
            ->setEnable($enable);
    }
    /**
     * Get AlarmLevelEvent value
     * @return string|null
     */
    public function getAlarmLevelEvent()
    {
        return $this->AlarmLevelEvent;
    }
    /**
     * Set AlarmLevelEvent value
     * @uses XAlarmSeverity::valueIsValid()
     * @uses XAlarmSeverity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmLevelEvent
     * @return RSyslogConfig
     */
    public function setAlarmLevelEvent($alarmLevelEvent = null)
    {
        // validation for constraint: enumeration
        if (!XAlarmSeverity::valueIsValid($alarmLevelEvent)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alarmLevelEvent, implode(', ', XAlarmSeverity::getValidValues())), __LINE__);
        }
        $this->AlarmLevelEvent = $alarmLevelEvent;
        return $this;
    }
    /**
     * Get RemoteServerName1 value
     * @return string|null
     */
    public function getRemoteServerName1()
    {
        return $this->RemoteServerName1;
    }
    /**
     * Set RemoteServerName1 value
     * @param string $remoteServerName1
     * @return RSyslogConfig
     */
    public function setRemoteServerName1($remoteServerName1 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName1) && !is_string($remoteServerName1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteServerName1)), __LINE__);
        }
        $this->RemoteServerName1 = $remoteServerName1;
        return $this;
    }
    /**
     * Get RemoteServerName2 value
     * @return string|null
     */
    public function getRemoteServerName2()
    {
        return $this->RemoteServerName2;
    }
    /**
     * Set RemoteServerName2 value
     * @param string $remoteServerName2
     * @return RSyslogConfig
     */
    public function setRemoteServerName2($remoteServerName2 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName2) && !is_string($remoteServerName2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteServerName2)), __LINE__);
        }
        $this->RemoteServerName2 = $remoteServerName2;
        return $this;
    }
    /**
     * Get RemoteServerName3 value
     * @return string|null
     */
    public function getRemoteServerName3()
    {
        return $this->RemoteServerName3;
    }
    /**
     * Set RemoteServerName3 value
     * @param string $remoteServerName3
     * @return RSyslogConfig
     */
    public function setRemoteServerName3($remoteServerName3 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName3) && !is_string($remoteServerName3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteServerName3)), __LINE__);
        }
        $this->RemoteServerName3 = $remoteServerName3;
        return $this;
    }
    /**
     * Get RemoteServerName4 value
     * @return string|null
     */
    public function getRemoteServerName4()
    {
        return $this->RemoteServerName4;
    }
    /**
     * Set RemoteServerName4 value
     * @param string $remoteServerName4
     * @return RSyslogConfig
     */
    public function setRemoteServerName4($remoteServerName4 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName4) && !is_string($remoteServerName4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteServerName4)), __LINE__);
        }
        $this->RemoteServerName4 = $remoteServerName4;
        return $this;
    }
    /**
     * Get RemoteServerName5 value
     * @return string|null
     */
    public function getRemoteServerName5()
    {
        return $this->RemoteServerName5;
    }
    /**
     * Set RemoteServerName5 value
     * @param string $remoteServerName5
     * @return RSyslogConfig
     */
    public function setRemoteServerName5($remoteServerName5 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName5) && !is_string($remoteServerName5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteServerName5)), __LINE__);
        }
        $this->RemoteServerName5 = $remoteServerName5;
        return $this;
    }
    /**
     * Get monitor value
     * @return string|null
     */
    public function getMonitor()
    {
        return $this->monitor;
    }
    /**
     * Set monitor value
     * @param string $monitor
     * @return RSyslogConfig
     */
    public function setMonitor($monitor = null)
    {
        // validation for constraint: string
        if (!is_null($monitor) && !is_string($monitor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monitor)), __LINE__);
        }
        $this->monitor = $monitor;
        return $this;
    }
    /**
     * Get Enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->Enable;
    }
    /**
     * Set Enable value
     * @param string $enable
     * @return RSyslogConfig
     */
    public function setEnable($enable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enable)), __LINE__);
        }
        $this->Enable = $enable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RSyslogConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
