<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSoftKeyTemplate StructType
 * @subpackage Structs
 */
class RSoftKeyTemplate extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $description;
    /**
     * The baseSoftkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $baseSoftkeyTemplateName;
    /**
     * The isDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The applications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Applications
     */
    public $applications;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSoftKeyTemplate
     * @uses RSoftKeyTemplate::setName()
     * @uses RSoftKeyTemplate::setDescription()
     * @uses RSoftKeyTemplate::setBaseSoftkeyTemplateName()
     * @uses RSoftKeyTemplate::setIsDefault()
     * @uses RSoftKeyTemplate::setApplications()
     * @uses RSoftKeyTemplate::setUuid()
     * @param string $name
     * @param string $description
     * @param XFkType $baseSoftkeyTemplateName
     * @param string $isDefault
     * @param Applications $applications
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, XFkType $baseSoftkeyTemplateName = null, $isDefault = null, Applications $applications = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setBaseSoftkeyTemplateName($baseSoftkeyTemplateName)
            ->setIsDefault($isDefault)
            ->setApplications($applications)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RSoftKeyTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 100) || (is_array($name) && count($name) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RSoftKeyTemplate
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 100) || (is_array($description) && count($description) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get baseSoftkeyTemplateName value
     * @return XFkType|null
     */
    public function getBaseSoftkeyTemplateName()
    {
        return $this->baseSoftkeyTemplateName;
    }
    /**
     * Set baseSoftkeyTemplateName value
     * @param XFkType $baseSoftkeyTemplateName
     * @return RSoftKeyTemplate
     */
    public function setBaseSoftkeyTemplateName(XFkType $baseSoftkeyTemplateName = null)
    {
        $this->baseSoftkeyTemplateName = $baseSoftkeyTemplateName;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return RSoftKeyTemplate
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get applications value
     * @return Applications|null
     */
    public function getApplications()
    {
        return $this->applications;
    }
    /**
     * Set applications value
     * @param Applications $applications
     * @return RSoftKeyTemplate
     */
    public function setApplications(Applications $applications = null)
    {
        $this->applications = $applications;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RSoftKeyTemplate
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RSoftKeyTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
