<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSipDialRules StructType
 * @subpackage Structs
 */
class RSipDialRules extends AbstractStructBase
{
    /**
     * The dialPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPattern;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The patterns
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Patterns
     */
    public $patterns;
    /**
     * The plars
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Plars
     */
    public $plars;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSipDialRules
     * @uses RSipDialRules::setDialPattern()
     * @uses RSipDialRules::setName()
     * @uses RSipDialRules::setDescription()
     * @uses RSipDialRules::setPatterns()
     * @uses RSipDialRules::setPlars()
     * @uses RSipDialRules::setUuid()
     * @param string $dialPattern
     * @param string $name
     * @param string $description
     * @param Patterns $patterns
     * @param Plars $plars
     * @param string $uuid
     */
    public function __construct($dialPattern = null, $name = null, $description = null, Patterns $patterns = null, Plars $plars = null, $uuid = null)
    {
        $this
            ->setDialPattern($dialPattern)
            ->setName($name)
            ->setDescription($description)
            ->setPatterns($patterns)
            ->setPlars($plars)
            ->setUuid($uuid);
    }
    /**
     * Get dialPattern value
     * @return string|null
     */
    public function getDialPattern()
    {
        return $this->dialPattern;
    }
    /**
     * Set dialPattern value
     * @uses XDialPattern::valueIsValid()
     * @uses XDialPattern::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPattern
     * @return RSipDialRules
     */
    public function setDialPattern($dialPattern = null)
    {
        // validation for constraint: enumeration
        if (!XDialPattern::valueIsValid($dialPattern)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialPattern, implode(', ', XDialPattern::getValidValues())), __LINE__);
        }
        $this->dialPattern = $dialPattern;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RSipDialRules
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RSipDialRules
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get patterns value
     * @return Patterns|null
     */
    public function getPatterns()
    {
        return $this->patterns;
    }
    /**
     * Set patterns value
     * @param Patterns $patterns
     * @return RSipDialRules
     */
    public function setPatterns(Patterns $patterns = null)
    {
        $this->patterns = $patterns;
        return $this;
    }
    /**
     * Get plars value
     * @return Plars|null
     */
    public function getPlars()
    {
        return $this->plars;
    }
    /**
     * Set plars value
     * @param Plars $plars
     * @return RSipDialRules
     */
    public function setPlars(Plars $plars = null)
    {
        $this->plars = $plars;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RSipDialRules
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RSipDialRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
