<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSdpTransparencyProfile StructType
 * @subpackage Structs
 */
class RSdpTransparencyProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The attributeSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var AttributeSet[]
     */
    public $attributeSet;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSdpTransparencyProfile
     * @uses RSdpTransparencyProfile::setName()
     * @uses RSdpTransparencyProfile::setDescription()
     * @uses RSdpTransparencyProfile::setAttributeSet()
     * @uses RSdpTransparencyProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param AttributeSet[] $attributeSet
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, array $attributeSet = array(), $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setAttributeSet($attributeSet)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RSdpTransparencyProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RSdpTransparencyProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get attributeSet value
     * @return AttributeSet[]|null
     */
    public function getAttributeSet()
    {
        return $this->attributeSet;
    }
    /**
     * Set attributeSet value
     * @throws \InvalidArgumentException
     * @param AttributeSet[] $attributeSet
     * @return RSdpTransparencyProfile
     */
    public function setAttributeSet(array $attributeSet = array())
    {
        foreach ($attributeSet as $rSdpTransparencyProfileAttributeSetItem) {
            // validation for constraint: itemType
            if (!$rSdpTransparencyProfileAttributeSetItem instanceof AttributeSet) {
                throw new \InvalidArgumentException(sprintf('The attributeSet property can only contain items of AttributeSet, "%s" given', is_object($rSdpTransparencyProfileAttributeSetItem) ? get_class($rSdpTransparencyProfileAttributeSetItem) : gettype($rSdpTransparencyProfileAttributeSetItem)), __LINE__);
            }
        }
        $this->attributeSet = $attributeSet;
        return $this;
    }
    /**
     * Add item to attributeSet value
     * @throws \InvalidArgumentException
     * @param AttributeSet $item
     * @return RSdpTransparencyProfile
     */
    public function addToAttributeSet(AttributeSet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof AttributeSet) {
            throw new \InvalidArgumentException(sprintf('The attributeSet property can only contain items of AttributeSet, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attributeSet[] = $item;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RSdpTransparencyProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RSdpTransparencyProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
