<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RResourcePriorityNamespaceListMember StructType
 * @subpackage Structs
 */
class RResourcePriorityNamespaceListMember extends AbstractStructBase
{
    /**
     * The resourcePriorityNamespaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RResourcePriorityNamespaceListMember
     * @uses RResourcePriorityNamespaceListMember::setResourcePriorityNamespaceName()
     * @uses RResourcePriorityNamespaceListMember::setIndex()
     * @uses RResourcePriorityNamespaceListMember::setUuid()
     * @param XFkType $resourcePriorityNamespaceName
     * @param string $index
     * @param string $uuid
     */
    public function __construct(XFkType $resourcePriorityNamespaceName = null, $index = null, $uuid = null)
    {
        $this
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setIndex($index)
            ->setUuid($uuid);
    }
    /**
     * Get resourcePriorityNamespaceName value
     * @return XFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return $this->resourcePriorityNamespaceName;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * @param XFkType $resourcePriorityNamespaceName
     * @return RResourcePriorityNamespaceListMember
     */
    public function setResourcePriorityNamespaceName(XFkType $resourcePriorityNamespaceName = null)
    {
        $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        return $this;
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return RResourcePriorityNamespaceListMember
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RResourcePriorityNamespaceListMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RResourcePriorityNamespaceListMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
