<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPhone StructType
 * @subpackage Structs
 */
class RPhone extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The commonPhoneConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $commonPhoneConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XVendorConfig
     */
    public $vendorConfig;
    /**
     * The versionStamp
     * Meta informations extracted from the WSDL
     * - documentation: UUID changed each time device is updated
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $versionStamp;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta informations extracted from the WSDL
     * - documentation: This Tag is valid only for SIP Phones and SIP Trunks
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $geoLocationFilterName;
    /**
     * The sendGeoLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Lines
     */
    public $lines;
    /**
     * The numberOfButtons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfButtons;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $phoneTemplateName;
    /**
     * The speeddials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Speeddials
     */
    public $speeddials;
    /**
     * The busyLampFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var BusyLampFields
     */
    public $busyLampFields;
    /**
     * The primaryPhoneName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $primaryPhoneName;
    /**
     * The ringSettingIdleBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingIdleBlfAudibleAlert;
    /**
     * The ringSettingBusyBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingBusyBlfAudibleAlert;
    /**
     * The blfDirectedCallParks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The idleTimeout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idleTimeout;
    /**
     * The authenticationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationUrl;
    /**
     * The directoryUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directoryUrl;
    /**
     * The idleUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idleUrl;
    /**
     * The informationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $informationUrl;
    /**
     * The messagesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messagesUrl;
    /**
     * The proxyServerUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $proxyServerUrl;
    /**
     * The servicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicesUrl;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Services
     */
    public $services;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $softkeyTemplateName;
    /**
     * The loginUserId
     * Meta informations extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $loginUserId;
    /**
     * The defaultProfileName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the default profile for this device.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $defaultProfileName;
    /**
     * The enableExtensionMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The currentProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $currentProfileName;
    /**
     * The loginTime
     * Meta informations extracted from the WSDL
     * - documentation: Read-only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginTime;
    /**
     * The loginDuration
     * Meta informations extracted from the WSDL
     * - documentation: Read-only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginDuration;
    /**
     * The currentConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CurrentConfig
     */
    public $currentConfig;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The builtInBridgeStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $builtInBridgeStatus;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callInfoPrivacyStatus;
    /**
     * The hlogStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hlogStatus;
    /**
     * The ownerUserName
     * Meta informations extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $ownerUserName;
    /**
     * The ignorePresentationIndicators
     * Meta informations extracted from the WSDL
     * - documentation: The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - documentation: Support for this tag has been removed for IMS phones from 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The allowCtiControlFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCtiControlFlag;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $presenceGroupName;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The requireDtmfReception
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireDtmfReception;
    /**
     * The rfc2833Disabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2833Disabled;
    /**
     * The certificateOperation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - documentation: authenticationMode can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - documentation: keySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keySize;
    /**
     * The authenticationString
     * Meta informations extracted from the WSDL
     * - documentation: authenticationString can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $authenticationString;
    /**
     * The certificateStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificateStatus;
    /**
     * The upgradeFinishTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $upgradeFinishTime;
    /**
     * The deviceMobilityMode
     * Meta informations extracted from the WSDL
     * - documentation: Specifies if the phone is configured for device mobility or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceMobilityMode;
    /**
     * The roamingDevicePoolName
     * Meta informations extracted from the WSDL
     * - documentation: Read-only.Specifies the device pool being used if the device is roaming and the deviceMobility feature is enabled for it.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $roamingDevicePoolName;
    /**
     * The remoteDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndStatus
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The isActive
     * Meta informations extracted from the WSDL
     * - documentation: This tag determines if the newly added phone is active to determine consumption of license.If set to false the license units will not be consumed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActive;
    /**
     * The isDualMode
     * Meta informations extracted from the WSDL
     * - documentation: Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDualMode;
    /**
     * The mobilityUserIdName
     * Meta informations extracted from the WSDL
     * - documentation: The userid of the mobility user for this phone.Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mobilityUserIdName;
    /**
     * The phoneSuite
     * Meta informations extracted from the WSDL
     * - documentation: If a blank tag is passed ,the value of the default is inserted into the database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneSuite;
    /**
     * The phoneServiceDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneServiceDisplay;
    /**
     * The isProtected
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support Secure Tone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isProtected;
    /**
     * The mtpRequired
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The mtpPreferedCodec
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mtpPreferedCodec;
    /**
     * The dialRulesName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $dialRulesName;
    /**
     * The sshUserId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable only to thosedevices that support ssh feature.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $sshUserId;
    /**
     * The sshPwd
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable only to thosedevices that support ssh feature.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $sshPwd;
    /**
     * The digestUser
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $digestUser;
    /**
     * The outboundCallRollover
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that Automatic Outbound Callrollover
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $outboundCallRollover;
    /**
     * The hotlineDevice
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable for PLAR-supporting SIP/SCCP phones only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The secureInformationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureInformationUrl;
    /**
     * The secureDirectoryUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureDirectoryUrl;
    /**
     * The secureMessageUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureMessageUrl;
    /**
     * The secureServicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureServicesUrl;
    /**
     * The secureAuthenticationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureAuthenticationUrl;
    /**
     * The secureIdleUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureIdleUrl;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $featureControlPolicy;
    /**
     * The deviceTrustMode
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for TIP endpoints
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceTrustMode;
    /**
     * The earlyOfferSupportForVoiceCall
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $earlyOfferSupportForVoiceCall;
    /**
     * The requireThirdPartyRegistration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireThirdPartyRegistration;
    /**
     * The blockIncomingCallsWhenRoaming
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockIncomingCallsWhenRoaming;
    /**
     * The homeNetworkId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is only valid when value of blockIncomingCallsWhenRoaming is true
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $homeNetworkId;
    /**
     * The AllowPresentationSharingUsingBfcp
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $AllowPresentationSharingUsingBfcp;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The requireOffPremiseLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireOffPremiseLocation;
    /**
     * The allowiXApplicableMedia
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowiXApplicableMedia;
    /**
     * The cgpnIngressDN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cgpnIngressDN;
    /**
     * The useDevicePoolCgpnIngressDN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnIngressDN;
    /**
     * The msisdn
     * Meta informations extracted from the WSDL
     * - documentation: Mobile Subscriber ISDN
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $msisdn;
    /**
     * The enableCallRoutingToRdWhenNoneIsActive
     * Meta informations extracted from the WSDL
     * - documentation: The new enableCallRoutingToRdWhenNoneIsActive flag for Remote Destination Call Forwarding feature is required for CTI Remote Device. Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCallRoutingToRdWhenNoneIsActive;
    /**
     * The wifiHotspotProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $wifiHotspotProfile;
    /**
     * The wirelessLanProfileGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPhone
     * @uses RPhone::setName()
     * @uses RPhone::setDescription()
     * @uses RPhone::setProduct()
     * @uses RPhone::setModel()
     * @uses RPhone::setClass()
     * @uses RPhone::setProtocol()
     * @uses RPhone::setProtocolSide()
     * @uses RPhone::setCallingSearchSpaceName()
     * @uses RPhone::setDevicePoolName()
     * @uses RPhone::setCommonDeviceConfigName()
     * @uses RPhone::setCommonPhoneConfigName()
     * @uses RPhone::setNetworkLocation()
     * @uses RPhone::setLocationName()
     * @uses RPhone::setMediaResourceListName()
     * @uses RPhone::setNetworkHoldMohAudioSourceId()
     * @uses RPhone::setUserHoldMohAudioSourceId()
     * @uses RPhone::setAutomatedAlternateRoutingCssName()
     * @uses RPhone::setAarNeighborhoodName()
     * @uses RPhone::setLoadInformation()
     * @uses RPhone::setVendorConfig()
     * @uses RPhone::setVersionStamp()
     * @uses RPhone::setTraceFlag()
     * @uses RPhone::setMlppDomainId()
     * @uses RPhone::setMlppIndicationStatus()
     * @uses RPhone::setPreemption()
     * @uses RPhone::setUseTrustedRelayPoint()
     * @uses RPhone::setRetryVideoCallAsAudio()
     * @uses RPhone::setSecurityProfileName()
     * @uses RPhone::setSipProfileName()
     * @uses RPhone::setCgpnTransformationCssName()
     * @uses RPhone::setUseDevicePoolCgpnTransformCss()
     * @uses RPhone::setGeoLocationName()
     * @uses RPhone::setGeoLocationFilterName()
     * @uses RPhone::setSendGeoLocation()
     * @uses RPhone::setLines()
     * @uses RPhone::setNumberOfButtons()
     * @uses RPhone::setPhoneTemplateName()
     * @uses RPhone::setSpeeddials()
     * @uses RPhone::setBusyLampFields()
     * @uses RPhone::setPrimaryPhoneName()
     * @uses RPhone::setRingSettingIdleBlfAudibleAlert()
     * @uses RPhone::setRingSettingBusyBlfAudibleAlert()
     * @uses RPhone::setBlfDirectedCallParks()
     * @uses RPhone::setAddOnModules()
     * @uses RPhone::setUserLocale()
     * @uses RPhone::setNetworkLocale()
     * @uses RPhone::setIdleTimeout()
     * @uses RPhone::setAuthenticationUrl()
     * @uses RPhone::setDirectoryUrl()
     * @uses RPhone::setIdleUrl()
     * @uses RPhone::setInformationUrl()
     * @uses RPhone::setMessagesUrl()
     * @uses RPhone::setProxyServerUrl()
     * @uses RPhone::setServicesUrl()
     * @uses RPhone::setServices()
     * @uses RPhone::setSoftkeyTemplateName()
     * @uses RPhone::setLoginUserId()
     * @uses RPhone::setDefaultProfileName()
     * @uses RPhone::setEnableExtensionMobility()
     * @uses RPhone::setCurrentProfileName()
     * @uses RPhone::setLoginTime()
     * @uses RPhone::setLoginDuration()
     * @uses RPhone::setCurrentConfig()
     * @uses RPhone::setSingleButtonBarge()
     * @uses RPhone::setJoinAcrossLines()
     * @uses RPhone::setBuiltInBridgeStatus()
     * @uses RPhone::setCallInfoPrivacyStatus()
     * @uses RPhone::setHlogStatus()
     * @uses RPhone::setOwnerUserName()
     * @uses RPhone::setIgnorePresentationIndicators()
     * @uses RPhone::setPacketCaptureMode()
     * @uses RPhone::setPacketCaptureDuration()
     * @uses RPhone::setSubscribeCallingSearchSpaceName()
     * @uses RPhone::setRerouteCallingSearchSpaceName()
     * @uses RPhone::setAllowCtiControlFlag()
     * @uses RPhone::setPresenceGroupName()
     * @uses RPhone::setUnattendedPort()
     * @uses RPhone::setRequireDtmfReception()
     * @uses RPhone::setRfc2833Disabled()
     * @uses RPhone::setCertificateOperation()
     * @uses RPhone::setAuthenticationMode()
     * @uses RPhone::setKeySize()
     * @uses RPhone::setAuthenticationString()
     * @uses RPhone::setCertificateStatus()
     * @uses RPhone::setUpgradeFinishTime()
     * @uses RPhone::setDeviceMobilityMode()
     * @uses RPhone::setRoamingDevicePoolName()
     * @uses RPhone::setRemoteDevice()
     * @uses RPhone::setDndOption()
     * @uses RPhone::setDndRingSetting()
     * @uses RPhone::setDndStatus()
     * @uses RPhone::setIsActive()
     * @uses RPhone::setIsDualMode()
     * @uses RPhone::setMobilityUserIdName()
     * @uses RPhone::setPhoneSuite()
     * @uses RPhone::setPhoneServiceDisplay()
     * @uses RPhone::setIsProtected()
     * @uses RPhone::setMtpRequired()
     * @uses RPhone::setMtpPreferedCodec()
     * @uses RPhone::setDialRulesName()
     * @uses RPhone::setSshUserId()
     * @uses RPhone::setSshPwd()
     * @uses RPhone::setDigestUser()
     * @uses RPhone::setOutboundCallRollover()
     * @uses RPhone::setHotlineDevice()
     * @uses RPhone::setSecureInformationUrl()
     * @uses RPhone::setSecureDirectoryUrl()
     * @uses RPhone::setSecureMessageUrl()
     * @uses RPhone::setSecureServicesUrl()
     * @uses RPhone::setSecureAuthenticationUrl()
     * @uses RPhone::setSecureIdleUrl()
     * @uses RPhone::setAlwaysUsePrimeLine()
     * @uses RPhone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses RPhone::setFeatureControlPolicy()
     * @uses RPhone::setDeviceTrustMode()
     * @uses RPhone::setEarlyOfferSupportForVoiceCall()
     * @uses RPhone::setRequireThirdPartyRegistration()
     * @uses RPhone::setBlockIncomingCallsWhenRoaming()
     * @uses RPhone::setHomeNetworkId()
     * @uses RPhone::setAllowPresentationSharingUsingBfcp()
     * @uses RPhone::setConfidentialAccess()
     * @uses RPhone::setRequireOffPremiseLocation()
     * @uses RPhone::setAllowiXApplicableMedia()
     * @uses RPhone::setCgpnIngressDN()
     * @uses RPhone::setUseDevicePoolCgpnIngressDN()
     * @uses RPhone::setMsisdn()
     * @uses RPhone::setEnableCallRoutingToRdWhenNoneIsActive()
     * @uses RPhone::setWifiHotspotProfile()
     * @uses RPhone::setWirelessLanProfileGroup()
     * @uses RPhone::setCtiid()
     * @uses RPhone::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param XFkType $callingSearchSpaceName
     * @param XFkType $devicePoolName
     * @param XFkType $commonDeviceConfigName
     * @param XFkType $commonPhoneConfigName
     * @param string $networkLocation
     * @param XFkType $locationName
     * @param XFkType $mediaResourceListName
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param XFkType $automatedAlternateRoutingCssName
     * @param XFkType $aarNeighborhoodName
     * @param XLoadInformation $loadInformation
     * @param XVendorConfig $vendorConfig
     * @param string $versionStamp
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param XFkType $securityProfileName
     * @param XFkType $sipProfileName
     * @param XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param XFkType $geoLocationName
     * @param XFkType $geoLocationFilterName
     * @param string $sendGeoLocation
     * @param Lines $lines
     * @param string $numberOfButtons
     * @param XFkType $phoneTemplateName
     * @param Speeddials $speeddials
     * @param BusyLampFields $busyLampFields
     * @param XFkType $primaryPhoneName
     * @param string $ringSettingIdleBlfAudibleAlert
     * @param string $ringSettingBusyBlfAudibleAlert
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @param AddOnModules $addOnModules
     * @param string $userLocale
     * @param string $networkLocale
     * @param string $idleTimeout
     * @param string $authenticationUrl
     * @param string $directoryUrl
     * @param string $idleUrl
     * @param string $informationUrl
     * @param string $messagesUrl
     * @param string $proxyServerUrl
     * @param string $servicesUrl
     * @param Services $services
     * @param XFkType $softkeyTemplateName
     * @param string $loginUserId
     * @param XFkType $defaultProfileName
     * @param string $enableExtensionMobility
     * @param XFkType $currentProfileName
     * @param string $loginTime
     * @param string $loginDuration
     * @param CurrentConfig $currentConfig
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param string $builtInBridgeStatus
     * @param string $callInfoPrivacyStatus
     * @param string $hlogStatus
     * @param XFkType $ownerUserName
     * @param string $ignorePresentationIndicators
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param XFkType $subscribeCallingSearchSpaceName
     * @param XFkType $rerouteCallingSearchSpaceName
     * @param string $allowCtiControlFlag
     * @param XFkType $presenceGroupName
     * @param string $unattendedPort
     * @param string $requireDtmfReception
     * @param string $rfc2833Disabled
     * @param string $certificateOperation
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $authenticationString
     * @param string $certificateStatus
     * @param string $upgradeFinishTime
     * @param string $deviceMobilityMode
     * @param XFkType $roamingDevicePoolName
     * @param string $remoteDevice
     * @param string $dndOption
     * @param string $dndRingSetting
     * @param string $dndStatus
     * @param string $isActive
     * @param string $isDualMode
     * @param XFkType $mobilityUserIdName
     * @param string $phoneSuite
     * @param string $phoneServiceDisplay
     * @param string $isProtected
     * @param string $mtpRequired
     * @param string $mtpPreferedCodec
     * @param XFkType $dialRulesName
     * @param string $sshUserId
     * @param string $sshPwd
     * @param string $digestUser
     * @param string $outboundCallRollover
     * @param string $hotlineDevice
     * @param string $secureInformationUrl
     * @param string $secureDirectoryUrl
     * @param string $secureMessageUrl
     * @param string $secureServicesUrl
     * @param string $secureAuthenticationUrl
     * @param string $secureIdleUrl
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param XFkType $featureControlPolicy
     * @param string $deviceTrustMode
     * @param string $earlyOfferSupportForVoiceCall
     * @param string $requireThirdPartyRegistration
     * @param string $blockIncomingCallsWhenRoaming
     * @param string $homeNetworkId
     * @param string $allowPresentationSharingUsingBfcp
     * @param ConfidentialAccess $confidentialAccess
     * @param string $requireOffPremiseLocation
     * @param string $allowiXApplicableMedia
     * @param XFkType $cgpnIngressDN
     * @param string $useDevicePoolCgpnIngressDN
     * @param string $msisdn
     * @param string $enableCallRoutingToRdWhenNoneIsActive
     * @param XFkType $wifiHotspotProfile
     * @param XFkType $wirelessLanProfileGroup
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, XFkType $callingSearchSpaceName = null, XFkType $devicePoolName = null, XFkType $commonDeviceConfigName = null, XFkType $commonPhoneConfigName = null, $networkLocation = null, XFkType $locationName = null, XFkType $mediaResourceListName = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, XFkType $automatedAlternateRoutingCssName = null, XFkType $aarNeighborhoodName = null, XLoadInformation $loadInformation = null, XVendorConfig $vendorConfig = null, $versionStamp = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = null, $preemption = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, XFkType $securityProfileName = null, XFkType $sipProfileName = null, XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, XFkType $geoLocationName = null, XFkType $geoLocationFilterName = null, $sendGeoLocation = null, Lines $lines = null, $numberOfButtons = null, XFkType $phoneTemplateName = null, Speeddials $speeddials = null, BusyLampFields $busyLampFields = null, XFkType $primaryPhoneName = null, $ringSettingIdleBlfAudibleAlert = null, $ringSettingBusyBlfAudibleAlert = null, BlfDirectedCallParks $blfDirectedCallParks = null, AddOnModules $addOnModules = null, $userLocale = null, $networkLocale = null, $idleTimeout = null, $authenticationUrl = null, $directoryUrl = null, $idleUrl = null, $informationUrl = null, $messagesUrl = null, $proxyServerUrl = null, $servicesUrl = null, Services $services = null, XFkType $softkeyTemplateName = null, $loginUserId = null, XFkType $defaultProfileName = null, $enableExtensionMobility = null, XFkType $currentProfileName = null, $loginTime = null, $loginDuration = null, CurrentConfig $currentConfig = null, $singleButtonBarge = null, $joinAcrossLines = null, $builtInBridgeStatus = null, $callInfoPrivacyStatus = null, $hlogStatus = null, XFkType $ownerUserName = null, $ignorePresentationIndicators = null, $packetCaptureMode = null, $packetCaptureDuration = null, XFkType $subscribeCallingSearchSpaceName = null, XFkType $rerouteCallingSearchSpaceName = null, $allowCtiControlFlag = null, XFkType $presenceGroupName = null, $unattendedPort = null, $requireDtmfReception = null, $rfc2833Disabled = null, $certificateOperation = null, $authenticationMode = null, $keySize = null, $authenticationString = null, $certificateStatus = null, $upgradeFinishTime = null, $deviceMobilityMode = null, XFkType $roamingDevicePoolName = null, $remoteDevice = null, $dndOption = null, $dndRingSetting = null, $dndStatus = null, $isActive = null, $isDualMode = null, XFkType $mobilityUserIdName = null, $phoneSuite = null, $phoneServiceDisplay = null, $isProtected = null, $mtpRequired = null, $mtpPreferedCodec = null, XFkType $dialRulesName = null, $sshUserId = null, $sshPwd = null, $digestUser = null, $outboundCallRollover = null, $hotlineDevice = null, $secureInformationUrl = null, $secureDirectoryUrl = null, $secureMessageUrl = null, $secureServicesUrl = null, $secureAuthenticationUrl = null, $secureIdleUrl = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, XFkType $featureControlPolicy = null, $deviceTrustMode = null, $earlyOfferSupportForVoiceCall = null, $requireThirdPartyRegistration = null, $blockIncomingCallsWhenRoaming = null, $homeNetworkId = null, $allowPresentationSharingUsingBfcp = null, ConfidentialAccess $confidentialAccess = null, $requireOffPremiseLocation = null, $allowiXApplicableMedia = null, XFkType $cgpnIngressDN = null, $useDevicePoolCgpnIngressDN = null, $msisdn = null, $enableCallRoutingToRdWhenNoneIsActive = null, XFkType $wifiHotspotProfile = null, XFkType $wirelessLanProfileGroup = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setVersionStamp($versionStamp)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setLines($lines)
            ->setNumberOfButtons($numberOfButtons)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setSpeeddials($speeddials)
            ->setBusyLampFields($busyLampFields)
            ->setPrimaryPhoneName($primaryPhoneName)
            ->setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert)
            ->setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setIdleTimeout($idleTimeout)
            ->setAuthenticationUrl($authenticationUrl)
            ->setDirectoryUrl($directoryUrl)
            ->setIdleUrl($idleUrl)
            ->setInformationUrl($informationUrl)
            ->setMessagesUrl($messagesUrl)
            ->setProxyServerUrl($proxyServerUrl)
            ->setServicesUrl($servicesUrl)
            ->setServices($services)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setLoginUserId($loginUserId)
            ->setDefaultProfileName($defaultProfileName)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setCurrentProfileName($currentProfileName)
            ->setLoginTime($loginTime)
            ->setLoginDuration($loginDuration)
            ->setCurrentConfig($currentConfig)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setBuiltInBridgeStatus($builtInBridgeStatus)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setHlogStatus($hlogStatus)
            ->setOwnerUserName($ownerUserName)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setAllowCtiControlFlag($allowCtiControlFlag)
            ->setPresenceGroupName($presenceGroupName)
            ->setUnattendedPort($unattendedPort)
            ->setRequireDtmfReception($requireDtmfReception)
            ->setRfc2833Disabled($rfc2833Disabled)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setAuthenticationString($authenticationString)
            ->setCertificateStatus($certificateStatus)
            ->setUpgradeFinishTime($upgradeFinishTime)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setRoamingDevicePoolName($roamingDevicePoolName)
            ->setRemoteDevice($remoteDevice)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setDndStatus($dndStatus)
            ->setIsActive($isActive)
            ->setIsDualMode($isDualMode)
            ->setMobilityUserIdName($mobilityUserIdName)
            ->setPhoneSuite($phoneSuite)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setIsProtected($isProtected)
            ->setMtpRequired($mtpRequired)
            ->setMtpPreferedCodec($mtpPreferedCodec)
            ->setDialRulesName($dialRulesName)
            ->setSshUserId($sshUserId)
            ->setSshPwd($sshPwd)
            ->setDigestUser($digestUser)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setHotlineDevice($hotlineDevice)
            ->setSecureInformationUrl($secureInformationUrl)
            ->setSecureDirectoryUrl($secureDirectoryUrl)
            ->setSecureMessageUrl($secureMessageUrl)
            ->setSecureServicesUrl($secureServicesUrl)
            ->setSecureAuthenticationUrl($secureAuthenticationUrl)
            ->setSecureIdleUrl($secureIdleUrl)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setDeviceTrustMode($deviceTrustMode)
            ->setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall)
            ->setRequireThirdPartyRegistration($requireThirdPartyRegistration)
            ->setBlockIncomingCallsWhenRoaming($blockIncomingCallsWhenRoaming)
            ->setHomeNetworkId($homeNetworkId)
            ->setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp)
            ->setConfidentialAccess($confidentialAccess)
            ->setRequireOffPremiseLocation($requireOffPremiseLocation)
            ->setAllowiXApplicableMedia($allowiXApplicableMedia)
            ->setCgpnIngressDN($cgpnIngressDN)
            ->setUseDevicePoolCgpnIngressDN($useDevicePoolCgpnIngressDN)
            ->setMsisdn($msisdn)
            ->setEnableCallRoutingToRdWhenNoneIsActive($enableCallRoutingToRdWhenNoneIsActive)
            ->setWifiHotspotProfile($wifiHotspotProfile)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RPhone
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RPhone
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return RPhone
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses XModel::valueIsValid()
     * @uses XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return RPhone
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses XClass::valueIsValid()
     * @uses XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return RPhone
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses XDeviceProtocol::valueIsValid()
     * @uses XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return RPhone
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses XProtocolSide::valueIsValid()
     * @uses XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return RPhone
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param XFkType $callingSearchSpaceName
     * @return RPhone
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return RPhone
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param XFkType $commonDeviceConfigName
     * @return RPhone
     */
    public function setCommonDeviceConfigName(XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return XFkType|null
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param XFkType $commonPhoneConfigName
     * @return RPhone
     */
    public function setCommonPhoneConfigName(XFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses XNetworkLocation::valueIsValid()
     * @uses XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return RPhone
     */
    public function setNetworkLocation($networkLocation = null)
    {
        // validation for constraint: enumeration
        if (!XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return RPhone
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param XFkType $mediaResourceListName
     * @return RPhone
     */
    public function setMediaResourceListName(XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @uses XMOHAudioSourceId::valueIsValid()
     * @uses XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return RPhone
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceId, implode(', ', XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses XMOHAudioSourceId::valueIsValid()
     * @uses XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return RPhone
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param XFkType $automatedAlternateRoutingCssName
     * @return RPhone
     */
    public function setAutomatedAlternateRoutingCssName(XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param XFkType $aarNeighborhoodName
     * @return RPhone
     */
    public function setAarNeighborhoodName(XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param XLoadInformation $loadInformation
     * @return RPhone
     */
    public function setLoadInformation(XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param XVendorConfig $vendorConfig
     * @return RPhone
     */
    public function setVendorConfig(XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get versionStamp value
     * @return string|null
     */
    public function getVersionStamp()
    {
        return $this->versionStamp;
    }
    /**
     * Set versionStamp value
     * @param string $versionStamp
     * @return RPhone
     */
    public function setVersionStamp($versionStamp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($versionStamp) && strlen($versionStamp) > 128) || (is_array($versionStamp) && count($versionStamp) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($versionStamp) ? strlen($versionStamp) : count($versionStamp)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($versionStamp) && !is_string($versionStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versionStamp)), __LINE__);
        }
        $this->versionStamp = $versionStamp;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return RPhone
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return RPhone
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return RPhone
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses XPreemption::valueIsValid()
     * @uses XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return RPhone
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return RPhone
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return RPhone
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return XFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param XFkType $securityProfileName
     * @return RPhone
     */
    public function setSecurityProfileName(XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return XFkType|null
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param XFkType $sipProfileName
     * @return RPhone
     */
    public function setSipProfileName(XFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param XFkType $cgpnTransformationCssName
     * @return RPhone
     */
    public function setCgpnTransformationCssName(XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return RPhone
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param XFkType $geoLocationName
     * @return RPhone
     */
    public function setGeoLocationName(XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param XFkType $geoLocationFilterName
     * @return RPhone
     */
    public function setGeoLocationFilterName(XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return RPhone
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendGeoLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendGeoLocation)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get lines value
     * @return Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param Lines $lines
     * @return RPhone
     */
    public function setLines(Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get numberOfButtons value
     * @return string|null
     */
    public function getNumberOfButtons()
    {
        return $this->numberOfButtons;
    }
    /**
     * Set numberOfButtons value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfButtons
     * @return RPhone
     */
    public function setNumberOfButtons($numberOfButtons = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($numberOfButtons)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberOfButtons, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfButtons = $numberOfButtons;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return XFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param XFkType $phoneTemplateName
     * @return RPhone
     */
    public function setPhoneTemplateName(XFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get speeddials value
     * @return Speeddials|null
     */
    public function getSpeeddials()
    {
        return $this->speeddials;
    }
    /**
     * Set speeddials value
     * @param Speeddials $speeddials
     * @return RPhone
     */
    public function setSpeeddials(Speeddials $speeddials = null)
    {
        $this->speeddials = $speeddials;
        return $this;
    }
    /**
     * Get busyLampFields value
     * @return BusyLampFields|null
     */
    public function getBusyLampFields()
    {
        return $this->busyLampFields;
    }
    /**
     * Set busyLampFields value
     * @param BusyLampFields $busyLampFields
     * @return RPhone
     */
    public function setBusyLampFields(BusyLampFields $busyLampFields = null)
    {
        $this->busyLampFields = $busyLampFields;
        return $this;
    }
    /**
     * Get primaryPhoneName value
     * @return XFkType|null
     */
    public function getPrimaryPhoneName()
    {
        return $this->primaryPhoneName;
    }
    /**
     * Set primaryPhoneName value
     * @param XFkType $primaryPhoneName
     * @return RPhone
     */
    public function setPrimaryPhoneName(XFkType $primaryPhoneName = null)
    {
        $this->primaryPhoneName = $primaryPhoneName;
        return $this;
    }
    /**
     * Get ringSettingIdleBlfAudibleAlert value
     * @return string|null
     */
    public function getRingSettingIdleBlfAudibleAlert()
    {
        return $this->ringSettingIdleBlfAudibleAlert;
    }
    /**
     * Set ringSettingIdleBlfAudibleAlert value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingIdleBlfAudibleAlert
     * @return RPhone
     */
    public function setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($ringSettingIdleBlfAudibleAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingIdleBlfAudibleAlert, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->ringSettingIdleBlfAudibleAlert = $ringSettingIdleBlfAudibleAlert;
        return $this;
    }
    /**
     * Get ringSettingBusyBlfAudibleAlert value
     * @return string|null
     */
    public function getRingSettingBusyBlfAudibleAlert()
    {
        return $this->ringSettingBusyBlfAudibleAlert;
    }
    /**
     * Set ringSettingBusyBlfAudibleAlert value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingBusyBlfAudibleAlert
     * @return RPhone
     */
    public function setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($ringSettingBusyBlfAudibleAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingBusyBlfAudibleAlert, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->ringSettingBusyBlfAudibleAlert = $ringSettingBusyBlfAudibleAlert;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param BlfDirectedCallParks $blfDirectedCallParks
     * @return RPhone
     */
    public function setBlfDirectedCallParks(BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param AddOnModules $addOnModules
     * @return RPhone
     */
    public function setAddOnModules(AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return RPhone
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @uses XCountry::valueIsValid()
     * @uses XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return RPhone
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', XCountry::getValidValues())), __LINE__);
        }
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get idleTimeout value
     * @return string|null
     */
    public function getIdleTimeout()
    {
        return $this->idleTimeout;
    }
    /**
     * Set idleTimeout value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idleTimeout
     * @return RPhone
     */
    public function setIdleTimeout($idleTimeout = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($idleTimeout)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $idleTimeout, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->idleTimeout = $idleTimeout;
        return $this;
    }
    /**
     * Get authenticationUrl value
     * @return string|null
     */
    public function getAuthenticationUrl()
    {
        return $this->authenticationUrl;
    }
    /**
     * Set authenticationUrl value
     * @param string $authenticationUrl
     * @return RPhone
     */
    public function setAuthenticationUrl($authenticationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationUrl) && !is_string($authenticationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationUrl)), __LINE__);
        }
        $this->authenticationUrl = $authenticationUrl;
        return $this;
    }
    /**
     * Get directoryUrl value
     * @return string|null
     */
    public function getDirectoryUrl()
    {
        return $this->directoryUrl;
    }
    /**
     * Set directoryUrl value
     * @param string $directoryUrl
     * @return RPhone
     */
    public function setDirectoryUrl($directoryUrl = null)
    {
        // validation for constraint: string
        if (!is_null($directoryUrl) && !is_string($directoryUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryUrl)), __LINE__);
        }
        $this->directoryUrl = $directoryUrl;
        return $this;
    }
    /**
     * Get idleUrl value
     * @return string|null
     */
    public function getIdleUrl()
    {
        return $this->idleUrl;
    }
    /**
     * Set idleUrl value
     * @param string $idleUrl
     * @return RPhone
     */
    public function setIdleUrl($idleUrl = null)
    {
        // validation for constraint: string
        if (!is_null($idleUrl) && !is_string($idleUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idleUrl)), __LINE__);
        }
        $this->idleUrl = $idleUrl;
        return $this;
    }
    /**
     * Get informationUrl value
     * @return string|null
     */
    public function getInformationUrl()
    {
        return $this->informationUrl;
    }
    /**
     * Set informationUrl value
     * @param string $informationUrl
     * @return RPhone
     */
    public function setInformationUrl($informationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($informationUrl) && !is_string($informationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($informationUrl)), __LINE__);
        }
        $this->informationUrl = $informationUrl;
        return $this;
    }
    /**
     * Get messagesUrl value
     * @return string|null
     */
    public function getMessagesUrl()
    {
        return $this->messagesUrl;
    }
    /**
     * Set messagesUrl value
     * @param string $messagesUrl
     * @return RPhone
     */
    public function setMessagesUrl($messagesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($messagesUrl) && !is_string($messagesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messagesUrl)), __LINE__);
        }
        $this->messagesUrl = $messagesUrl;
        return $this;
    }
    /**
     * Get proxyServerUrl value
     * @return string|null
     */
    public function getProxyServerUrl()
    {
        return $this->proxyServerUrl;
    }
    /**
     * Set proxyServerUrl value
     * @param string $proxyServerUrl
     * @return RPhone
     */
    public function setProxyServerUrl($proxyServerUrl = null)
    {
        // validation for constraint: string
        if (!is_null($proxyServerUrl) && !is_string($proxyServerUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyServerUrl)), __LINE__);
        }
        $this->proxyServerUrl = $proxyServerUrl;
        return $this;
    }
    /**
     * Get servicesUrl value
     * @return string|null
     */
    public function getServicesUrl()
    {
        return $this->servicesUrl;
    }
    /**
     * Set servicesUrl value
     * @param string $servicesUrl
     * @return RPhone
     */
    public function setServicesUrl($servicesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($servicesUrl) && !is_string($servicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicesUrl)), __LINE__);
        }
        $this->servicesUrl = $servicesUrl;
        return $this;
    }
    /**
     * Get services value
     * @return Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param Services $services
     * @return RPhone
     */
    public function setServices(Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param XFkType $softkeyTemplateName
     * @return RPhone
     */
    public function setSoftkeyTemplateName(XFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get loginUserId value
     * @return string|null
     */
    public function getLoginUserId()
    {
        return $this->loginUserId;
    }
    /**
     * Set loginUserId value
     * @param string $loginUserId
     * @return RPhone
     */
    public function setLoginUserId($loginUserId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($loginUserId) && strlen($loginUserId) > 255) || (is_array($loginUserId) && count($loginUserId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($loginUserId) ? strlen($loginUserId) : count($loginUserId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($loginUserId) && !is_string($loginUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginUserId)), __LINE__);
        }
        $this->loginUserId = $loginUserId;
        return $this;
    }
    /**
     * Get defaultProfileName value
     * @return XFkType|null
     */
    public function getDefaultProfileName()
    {
        return $this->defaultProfileName;
    }
    /**
     * Set defaultProfileName value
     * @param XFkType $defaultProfileName
     * @return RPhone
     */
    public function setDefaultProfileName(XFkType $defaultProfileName = null)
    {
        $this->defaultProfileName = $defaultProfileName;
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return RPhone
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableExtensionMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableExtensionMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableExtensionMobility) && !is_string($enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableExtensionMobility)), __LINE__);
        }
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get currentProfileName value
     * @return XFkType|null
     */
    public function getCurrentProfileName()
    {
        return $this->currentProfileName;
    }
    /**
     * Set currentProfileName value
     * @param XFkType $currentProfileName
     * @return RPhone
     */
    public function setCurrentProfileName(XFkType $currentProfileName = null)
    {
        $this->currentProfileName = $currentProfileName;
        return $this;
    }
    /**
     * Get loginTime value
     * @return string|null
     */
    public function getLoginTime()
    {
        return $this->loginTime;
    }
    /**
     * Set loginTime value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loginTime
     * @return RPhone
     */
    public function setLoginTime($loginTime = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($loginTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $loginTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->loginTime = $loginTime;
        return $this;
    }
    /**
     * Get loginDuration value
     * @return string|null
     */
    public function getLoginDuration()
    {
        return $this->loginDuration;
    }
    /**
     * Set loginDuration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loginDuration
     * @return RPhone
     */
    public function setLoginDuration($loginDuration = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($loginDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $loginDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->loginDuration = $loginDuration;
        return $this;
    }
    /**
     * Get currentConfig value
     * @return CurrentConfig|null
     */
    public function getCurrentConfig()
    {
        return $this->currentConfig;
    }
    /**
     * Set currentConfig value
     * @param CurrentConfig $currentConfig
     * @return RPhone
     */
    public function setCurrentConfig(CurrentConfig $currentConfig = null)
    {
        $this->currentConfig = $currentConfig;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses XBarge::valueIsValid()
     * @uses XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return RPhone
     */
    public function setSingleButtonBarge($singleButtonBarge = null)
    {
        // validation for constraint: enumeration
        if (!XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return RPhone
     */
    public function setJoinAcrossLines($joinAcrossLines = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get builtInBridgeStatus value
     * @return string|null
     */
    public function getBuiltInBridgeStatus()
    {
        return $this->builtInBridgeStatus;
    }
    /**
     * Set builtInBridgeStatus value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $builtInBridgeStatus
     * @return RPhone
     */
    public function setBuiltInBridgeStatus($builtInBridgeStatus = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($builtInBridgeStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $builtInBridgeStatus, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->builtInBridgeStatus = $builtInBridgeStatus;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return string|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callInfoPrivacyStatus
     * @return RPhone
     */
    public function setCallInfoPrivacyStatus($callInfoPrivacyStatus = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($callInfoPrivacyStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callInfoPrivacyStatus, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get hlogStatus value
     * @return string|null
     */
    public function getHlogStatus()
    {
        return $this->hlogStatus;
    }
    /**
     * Set hlogStatus value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hlogStatus
     * @return RPhone
     */
    public function setHlogStatus($hlogStatus = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($hlogStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hlogStatus, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->hlogStatus = $hlogStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * @return XFkType|null
     */
    public function getOwnerUserName()
    {
        return $this->ownerUserName;
    }
    /**
     * Set ownerUserName value
     * @param XFkType $ownerUserName
     * @return RPhone
     */
    public function setOwnerUserName(XFkType $ownerUserName = null)
    {
        $this->ownerUserName = $ownerUserName;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return RPhone
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignorePresentationIndicators)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses XPacketCaptureMode::valueIsValid()
     * @uses XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return RPhone
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        // validation for constraint: enumeration
        if (!XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return RPhone
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param XFkType $subscribeCallingSearchSpaceName
     * @return RPhone
     */
    public function setSubscribeCallingSearchSpaceName(XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * @return XFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return $this->rerouteCallingSearchSpaceName;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * @param XFkType $rerouteCallingSearchSpaceName
     * @return RPhone
     */
    public function setRerouteCallingSearchSpaceName(XFkType $rerouteCallingSearchSpaceName = null)
    {
        $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get allowCtiControlFlag value
     * @return string|null
     */
    public function getAllowCtiControlFlag()
    {
        return $this->allowCtiControlFlag;
    }
    /**
     * Set allowCtiControlFlag value
     * @param string $allowCtiControlFlag
     * @return RPhone
     */
    public function setAllowCtiControlFlag($allowCtiControlFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowCtiControlFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowCtiControlFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowCtiControlFlag) && !is_string($allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowCtiControlFlag)), __LINE__);
        }
        $this->allowCtiControlFlag = $allowCtiControlFlag;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param XFkType $presenceGroupName
     * @return RPhone
     */
    public function setPresenceGroupName(XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return RPhone
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get requireDtmfReception value
     * @return string|null
     */
    public function getRequireDtmfReception()
    {
        return $this->requireDtmfReception;
    }
    /**
     * Set requireDtmfReception value
     * @param string $requireDtmfReception
     * @return RPhone
     */
    public function setRequireDtmfReception($requireDtmfReception = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requireDtmfReception) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requireDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requireDtmfReception, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireDtmfReception) && !is_string($requireDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireDtmfReception)), __LINE__);
        }
        $this->requireDtmfReception = $requireDtmfReception;
        return $this;
    }
    /**
     * Get rfc2833Disabled value
     * @return string|null
     */
    public function getRfc2833Disabled()
    {
        return $this->rfc2833Disabled;
    }
    /**
     * Set rfc2833Disabled value
     * @param string $rfc2833Disabled
     * @return RPhone
     */
    public function setRfc2833Disabled($rfc2833Disabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rfc2833Disabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rfc2833Disabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rfc2833Disabled) && !is_string($rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rfc2833Disabled)), __LINE__);
        }
        $this->rfc2833Disabled = $rfc2833Disabled;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return string|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @uses XCertificateOperation::valueIsValid()
     * @uses XCertificateOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificateOperation
     * @return RPhone
     */
    public function setCertificateOperation($certificateOperation = null)
    {
        // validation for constraint: enumeration
        if (!XCertificateOperation::valueIsValid($certificateOperation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificateOperation, implode(', ', XCertificateOperation::getValidValues())), __LINE__);
        }
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses XAuthenticationMode::valueIsValid()
     * @uses XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return RPhone
     */
    public function setAuthenticationMode($authenticationMode = null)
    {
        // validation for constraint: enumeration
        if (!XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses XKeySize::valueIsValid()
     * @uses XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return RPhone
     */
    public function setKeySize($keySize = null)
    {
        // validation for constraint: enumeration
        if (!XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return RPhone
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authenticationString) && strlen($authenticationString) > 128) || (is_array($authenticationString) && count($authenticationString) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($authenticationString) ? strlen($authenticationString) : count($authenticationString)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get certificateStatus value
     * @return string|null
     */
    public function getCertificateStatus()
    {
        return $this->certificateStatus;
    }
    /**
     * Set certificateStatus value
     * @uses XCertificateStatus::valueIsValid()
     * @uses XCertificateStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificateStatus
     * @return RPhone
     */
    public function setCertificateStatus($certificateStatus = null)
    {
        // validation for constraint: enumeration
        if (!XCertificateStatus::valueIsValid($certificateStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificateStatus, implode(', ', XCertificateStatus::getValidValues())), __LINE__);
        }
        $this->certificateStatus = $certificateStatus;
        return $this;
    }
    /**
     * Get upgradeFinishTime value
     * @return string|null
     */
    public function getUpgradeFinishTime()
    {
        return $this->upgradeFinishTime;
    }
    /**
     * Set upgradeFinishTime value
     * @param string $upgradeFinishTime
     * @return RPhone
     */
    public function setUpgradeFinishTime($upgradeFinishTime = null)
    {
        // validation for constraint: string
        if (!is_null($upgradeFinishTime) && !is_string($upgradeFinishTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($upgradeFinishTime)), __LINE__);
        }
        $this->upgradeFinishTime = $upgradeFinishTime;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return string|null
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceMobilityMode
     * @return RPhone
     */
    public function setDeviceMobilityMode($deviceMobilityMode = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($deviceMobilityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceMobilityMode, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get roamingDevicePoolName value
     * @return XFkType|null
     */
    public function getRoamingDevicePoolName()
    {
        return $this->roamingDevicePoolName;
    }
    /**
     * Set roamingDevicePoolName value
     * @param XFkType $roamingDevicePoolName
     * @return RPhone
     */
    public function setRoamingDevicePoolName(XFkType $roamingDevicePoolName = null)
    {
        $this->roamingDevicePoolName = $roamingDevicePoolName;
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return RPhone
     */
    public function setRemoteDevice($remoteDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($remoteDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($remoteDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteDevice) && !is_string($remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteDevice)), __LINE__);
        }
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses XDNDOption::valueIsValid()
     * @uses XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return RPhone
     */
    public function setDndOption($dndOption = null)
    {
        // validation for constraint: enumeration
        if (!XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndRingSetting
     * @return RPhone
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($dndRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndRingSetting, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return RPhone
     */
    public function setDndStatus($dndStatus = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dndStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dndStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dndStatus) && !is_string($dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dndStatus)), __LINE__);
        }
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get isActive value
     * @return string|null
     */
    public function getIsActive()
    {
        return $this->isActive;
    }
    /**
     * Set isActive value
     * @param string $isActive
     * @return RPhone
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isActive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActive, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActive) && !is_string($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->isActive = $isActive;
        return $this;
    }
    /**
     * Get isDualMode value
     * @return string|null
     */
    public function getIsDualMode()
    {
        return $this->isDualMode;
    }
    /**
     * Set isDualMode value
     * @param string $isDualMode
     * @return RPhone
     */
    public function setIsDualMode($isDualMode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDualMode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDualMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDualMode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDualMode) && !is_string($isDualMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDualMode)), __LINE__);
        }
        $this->isDualMode = $isDualMode;
        return $this;
    }
    /**
     * Get mobilityUserIdName value
     * @return XFkType|null
     */
    public function getMobilityUserIdName()
    {
        return $this->mobilityUserIdName;
    }
    /**
     * Set mobilityUserIdName value
     * @param XFkType $mobilityUserIdName
     * @return RPhone
     */
    public function setMobilityUserIdName(XFkType $mobilityUserIdName = null)
    {
        $this->mobilityUserIdName = $mobilityUserIdName;
        return $this;
    }
    /**
     * Get phoneSuite value
     * @return string|null
     */
    public function getPhoneSuite()
    {
        return $this->phoneSuite;
    }
    /**
     * Set phoneSuite value
     * @uses XPhonePersonalization::valueIsValid()
     * @uses XPhonePersonalization::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneSuite
     * @return RPhone
     */
    public function setPhoneSuite($phoneSuite = null)
    {
        // validation for constraint: enumeration
        if (!XPhonePersonalization::valueIsValid($phoneSuite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneSuite, implode(', ', XPhonePersonalization::getValidValues())), __LINE__);
        }
        $this->phoneSuite = $phoneSuite;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return string|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @uses XPhoneServiceDisplay::valueIsValid()
     * @uses XPhoneServiceDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneServiceDisplay
     * @return RPhone
     */
    public function setPhoneServiceDisplay($phoneServiceDisplay = null)
    {
        // validation for constraint: enumeration
        if (!XPhoneServiceDisplay::valueIsValid($phoneServiceDisplay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneServiceDisplay, implode(', ', XPhoneServiceDisplay::getValidValues())), __LINE__);
        }
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get isProtected value
     * @return string|null
     */
    public function getIsProtected()
    {
        return $this->isProtected;
    }
    /**
     * Set isProtected value
     * @param string $isProtected
     * @return RPhone
     */
    public function setIsProtected($isProtected = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isProtected) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isProtected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isProtected, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isProtected) && !is_string($isProtected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isProtected)), __LINE__);
        }
        $this->isProtected = $isProtected;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return RPhone
     */
    public function setMtpRequired($mtpRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mtpRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mtpRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mtpRequired) && !is_string($mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mtpRequired)), __LINE__);
        }
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get mtpPreferedCodec value
     * @return string|null
     */
    public function getMtpPreferedCodec()
    {
        return $this->mtpPreferedCodec;
    }
    /**
     * Set mtpPreferedCodec value
     * @uses XSIPCodec::valueIsValid()
     * @uses XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtpPreferedCodec
     * @return RPhone
     */
    public function setMtpPreferedCodec($mtpPreferedCodec = null)
    {
        // validation for constraint: enumeration
        if (!XSIPCodec::valueIsValid($mtpPreferedCodec)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mtpPreferedCodec, implode(', ', XSIPCodec::getValidValues())), __LINE__);
        }
        $this->mtpPreferedCodec = $mtpPreferedCodec;
        return $this;
    }
    /**
     * Get dialRulesName value
     * @return XFkType|null
     */
    public function getDialRulesName()
    {
        return $this->dialRulesName;
    }
    /**
     * Set dialRulesName value
     * @param XFkType $dialRulesName
     * @return RPhone
     */
    public function setDialRulesName(XFkType $dialRulesName = null)
    {
        $this->dialRulesName = $dialRulesName;
        return $this;
    }
    /**
     * Get sshUserId value
     * @return string|null
     */
    public function getSshUserId()
    {
        return $this->sshUserId;
    }
    /**
     * Set sshUserId value
     * @param string $sshUserId
     * @return RPhone
     */
    public function setSshUserId($sshUserId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sshUserId) && strlen($sshUserId) > 50) || (is_array($sshUserId) && count($sshUserId) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($sshUserId) ? strlen($sshUserId) : count($sshUserId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sshUserId) && !is_string($sshUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sshUserId)), __LINE__);
        }
        $this->sshUserId = $sshUserId;
        return $this;
    }
    /**
     * Get sshPwd value
     * @return string|null
     */
    public function getSshPwd()
    {
        return $this->sshPwd;
    }
    /**
     * Set sshPwd value
     * @param string $sshPwd
     * @return RPhone
     */
    public function setSshPwd($sshPwd = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sshPwd) && strlen($sshPwd) > 255) || (is_array($sshPwd) && count($sshPwd) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($sshPwd) ? strlen($sshPwd) : count($sshPwd)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sshPwd) && !is_string($sshPwd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sshPwd)), __LINE__);
        }
        $this->sshPwd = $sshPwd;
        return $this;
    }
    /**
     * Get digestUser value
     * @return string|null
     */
    public function getDigestUser()
    {
        return $this->digestUser;
    }
    /**
     * Set digestUser value
     * @param string $digestUser
     * @return RPhone
     */
    public function setDigestUser($digestUser = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($digestUser) && strlen($digestUser) > 255) || (is_array($digestUser) && count($digestUser) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($digestUser) ? strlen($digestUser) : count($digestUser)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($digestUser) && !is_string($digestUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digestUser)), __LINE__);
        }
        $this->digestUser = $digestUser;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return string|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @uses XOutboundCallRollover::valueIsValid()
     * @uses XOutboundCallRollover::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outboundCallRollover
     * @return RPhone
     */
    public function setOutboundCallRollover($outboundCallRollover = null)
    {
        // validation for constraint: enumeration
        if (!XOutboundCallRollover::valueIsValid($outboundCallRollover)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $outboundCallRollover, implode(', ', XOutboundCallRollover::getValidValues())), __LINE__);
        }
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return RPhone
     */
    public function setHotlineDevice($hotlineDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($hotlineDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($hotlineDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hotlineDevice) && !is_string($hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotlineDevice)), __LINE__);
        }
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get secureInformationUrl value
     * @return string|null
     */
    public function getSecureInformationUrl()
    {
        return $this->secureInformationUrl;
    }
    /**
     * Set secureInformationUrl value
     * @param string $secureInformationUrl
     * @return RPhone
     */
    public function setSecureInformationUrl($secureInformationUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureInformationUrl) && strlen($secureInformationUrl) > 255) || (is_array($secureInformationUrl) && count($secureInformationUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureInformationUrl) ? strlen($secureInformationUrl) : count($secureInformationUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureInformationUrl) && !is_string($secureInformationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureInformationUrl)), __LINE__);
        }
        $this->secureInformationUrl = $secureInformationUrl;
        return $this;
    }
    /**
     * Get secureDirectoryUrl value
     * @return string|null
     */
    public function getSecureDirectoryUrl()
    {
        return $this->secureDirectoryUrl;
    }
    /**
     * Set secureDirectoryUrl value
     * @param string $secureDirectoryUrl
     * @return RPhone
     */
    public function setSecureDirectoryUrl($secureDirectoryUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureDirectoryUrl) && strlen($secureDirectoryUrl) > 255) || (is_array($secureDirectoryUrl) && count($secureDirectoryUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureDirectoryUrl) ? strlen($secureDirectoryUrl) : count($secureDirectoryUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureDirectoryUrl) && !is_string($secureDirectoryUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureDirectoryUrl)), __LINE__);
        }
        $this->secureDirectoryUrl = $secureDirectoryUrl;
        return $this;
    }
    /**
     * Get secureMessageUrl value
     * @return string|null
     */
    public function getSecureMessageUrl()
    {
        return $this->secureMessageUrl;
    }
    /**
     * Set secureMessageUrl value
     * @param string $secureMessageUrl
     * @return RPhone
     */
    public function setSecureMessageUrl($secureMessageUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureMessageUrl) && strlen($secureMessageUrl) > 255) || (is_array($secureMessageUrl) && count($secureMessageUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureMessageUrl) ? strlen($secureMessageUrl) : count($secureMessageUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureMessageUrl) && !is_string($secureMessageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureMessageUrl)), __LINE__);
        }
        $this->secureMessageUrl = $secureMessageUrl;
        return $this;
    }
    /**
     * Get secureServicesUrl value
     * @return string|null
     */
    public function getSecureServicesUrl()
    {
        return $this->secureServicesUrl;
    }
    /**
     * Set secureServicesUrl value
     * @param string $secureServicesUrl
     * @return RPhone
     */
    public function setSecureServicesUrl($secureServicesUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureServicesUrl) && strlen($secureServicesUrl) > 255) || (is_array($secureServicesUrl) && count($secureServicesUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureServicesUrl) ? strlen($secureServicesUrl) : count($secureServicesUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureServicesUrl) && !is_string($secureServicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureServicesUrl)), __LINE__);
        }
        $this->secureServicesUrl = $secureServicesUrl;
        return $this;
    }
    /**
     * Get secureAuthenticationUrl value
     * @return string|null
     */
    public function getSecureAuthenticationUrl()
    {
        return $this->secureAuthenticationUrl;
    }
    /**
     * Set secureAuthenticationUrl value
     * @param string $secureAuthenticationUrl
     * @return RPhone
     */
    public function setSecureAuthenticationUrl($secureAuthenticationUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureAuthenticationUrl) && strlen($secureAuthenticationUrl) > 255) || (is_array($secureAuthenticationUrl) && count($secureAuthenticationUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureAuthenticationUrl) ? strlen($secureAuthenticationUrl) : count($secureAuthenticationUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureAuthenticationUrl) && !is_string($secureAuthenticationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureAuthenticationUrl)), __LINE__);
        }
        $this->secureAuthenticationUrl = $secureAuthenticationUrl;
        return $this;
    }
    /**
     * Get secureIdleUrl value
     * @return string|null
     */
    public function getSecureIdleUrl()
    {
        return $this->secureIdleUrl;
    }
    /**
     * Set secureIdleUrl value
     * @param string $secureIdleUrl
     * @return RPhone
     */
    public function setSecureIdleUrl($secureIdleUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureIdleUrl) && strlen($secureIdleUrl) > 255) || (is_array($secureIdleUrl) && count($secureIdleUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureIdleUrl) ? strlen($secureIdleUrl) : count($secureIdleUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureIdleUrl) && !is_string($secureIdleUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureIdleUrl)), __LINE__);
        }
        $this->secureIdleUrl = $secureIdleUrl;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return RPhone
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return RPhone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param XFkType $featureControlPolicy
     * @return RPhone
     */
    public function setFeatureControlPolicy(XFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get deviceTrustMode value
     * @return string|null
     */
    public function getDeviceTrustMode()
    {
        return $this->deviceTrustMode;
    }
    /**
     * Set deviceTrustMode value
     * @uses XDeviceTrustMode::valueIsValid()
     * @uses XDeviceTrustMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceTrustMode
     * @return RPhone
     */
    public function setDeviceTrustMode($deviceTrustMode = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceTrustMode::valueIsValid($deviceTrustMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceTrustMode, implode(', ', XDeviceTrustMode::getValidValues())), __LINE__);
        }
        $this->deviceTrustMode = $deviceTrustMode;
        return $this;
    }
    /**
     * Get earlyOfferSupportForVoiceCall value
     * @return string|null
     */
    public function getEarlyOfferSupportForVoiceCall()
    {
        return $this->earlyOfferSupportForVoiceCall;
    }
    /**
     * Set earlyOfferSupportForVoiceCall value
     * @param string $earlyOfferSupportForVoiceCall
     * @return RPhone
     */
    public function setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall = null)
    {
        // validation for constraint: pattern
        if (is_scalar($earlyOfferSupportForVoiceCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $earlyOfferSupportForVoiceCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($earlyOfferSupportForVoiceCall, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($earlyOfferSupportForVoiceCall) && !is_string($earlyOfferSupportForVoiceCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($earlyOfferSupportForVoiceCall)), __LINE__);
        }
        $this->earlyOfferSupportForVoiceCall = $earlyOfferSupportForVoiceCall;
        return $this;
    }
    /**
     * Get requireThirdPartyRegistration value
     * @return string|null
     */
    public function getRequireThirdPartyRegistration()
    {
        return $this->requireThirdPartyRegistration;
    }
    /**
     * Set requireThirdPartyRegistration value
     * @param string $requireThirdPartyRegistration
     * @return RPhone
     */
    public function setRequireThirdPartyRegistration($requireThirdPartyRegistration = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requireThirdPartyRegistration) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requireThirdPartyRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requireThirdPartyRegistration, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireThirdPartyRegistration) && !is_string($requireThirdPartyRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireThirdPartyRegistration)), __LINE__);
        }
        $this->requireThirdPartyRegistration = $requireThirdPartyRegistration;
        return $this;
    }
    /**
     * Get blockIncomingCallsWhenRoaming value
     * @return string|null
     */
    public function getBlockIncomingCallsWhenRoaming()
    {
        return $this->blockIncomingCallsWhenRoaming;
    }
    /**
     * Set blockIncomingCallsWhenRoaming value
     * @param string $blockIncomingCallsWhenRoaming
     * @return RPhone
     */
    public function setBlockIncomingCallsWhenRoaming($blockIncomingCallsWhenRoaming = null)
    {
        // validation for constraint: pattern
        if (is_scalar($blockIncomingCallsWhenRoaming) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $blockIncomingCallsWhenRoaming)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($blockIncomingCallsWhenRoaming, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($blockIncomingCallsWhenRoaming) && !is_string($blockIncomingCallsWhenRoaming)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blockIncomingCallsWhenRoaming)), __LINE__);
        }
        $this->blockIncomingCallsWhenRoaming = $blockIncomingCallsWhenRoaming;
        return $this;
    }
    /**
     * Get homeNetworkId value
     * @return string|null
     */
    public function getHomeNetworkId()
    {
        return $this->homeNetworkId;
    }
    /**
     * Set homeNetworkId value
     * @param string $homeNetworkId
     * @return RPhone
     */
    public function setHomeNetworkId($homeNetworkId = null)
    {
        // validation for constraint: string
        if (!is_null($homeNetworkId) && !is_string($homeNetworkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homeNetworkId)), __LINE__);
        }
        $this->homeNetworkId = $homeNetworkId;
        return $this;
    }
    /**
     * Get AllowPresentationSharingUsingBfcp value
     * @return string|null
     */
    public function getAllowPresentationSharingUsingBfcp()
    {
        return $this->AllowPresentationSharingUsingBfcp;
    }
    /**
     * Set AllowPresentationSharingUsingBfcp value
     * @param string $allowPresentationSharingUsingBfcp
     * @return RPhone
     */
    public function setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowPresentationSharingUsingBfcp) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowPresentationSharingUsingBfcp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowPresentationSharingUsingBfcp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowPresentationSharingUsingBfcp) && !is_string($allowPresentationSharingUsingBfcp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowPresentationSharingUsingBfcp)), __LINE__);
        }
        $this->AllowPresentationSharingUsingBfcp = $allowPresentationSharingUsingBfcp;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param ConfidentialAccess $confidentialAccess
     * @return RPhone
     */
    public function setConfidentialAccess(ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get requireOffPremiseLocation value
     * @return string|null
     */
    public function getRequireOffPremiseLocation()
    {
        return $this->requireOffPremiseLocation;
    }
    /**
     * Set requireOffPremiseLocation value
     * @param string $requireOffPremiseLocation
     * @return RPhone
     */
    public function setRequireOffPremiseLocation($requireOffPremiseLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requireOffPremiseLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requireOffPremiseLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireOffPremiseLocation) && !is_string($requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireOffPremiseLocation)), __LINE__);
        }
        $this->requireOffPremiseLocation = $requireOffPremiseLocation;
        return $this;
    }
    /**
     * Get allowiXApplicableMedia value
     * @return string|null
     */
    public function getAllowiXApplicableMedia()
    {
        return $this->allowiXApplicableMedia;
    }
    /**
     * Set allowiXApplicableMedia value
     * @param string $allowiXApplicableMedia
     * @return RPhone
     */
    public function setAllowiXApplicableMedia($allowiXApplicableMedia = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowiXApplicableMedia) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowiXApplicableMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowiXApplicableMedia, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowiXApplicableMedia) && !is_string($allowiXApplicableMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowiXApplicableMedia)), __LINE__);
        }
        $this->allowiXApplicableMedia = $allowiXApplicableMedia;
        return $this;
    }
    /**
     * Get cgpnIngressDN value
     * @return XFkType|null
     */
    public function getCgpnIngressDN()
    {
        return $this->cgpnIngressDN;
    }
    /**
     * Set cgpnIngressDN value
     * @param XFkType $cgpnIngressDN
     * @return RPhone
     */
    public function setCgpnIngressDN(XFkType $cgpnIngressDN = null)
    {
        $this->cgpnIngressDN = $cgpnIngressDN;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnIngressDN value
     * @return string|null
     */
    public function getUseDevicePoolCgpnIngressDN()
    {
        return $this->useDevicePoolCgpnIngressDN;
    }
    /**
     * Set useDevicePoolCgpnIngressDN value
     * @param string $useDevicePoolCgpnIngressDN
     * @return RPhone
     */
    public function setUseDevicePoolCgpnIngressDN($useDevicePoolCgpnIngressDN = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnIngressDN) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnIngressDN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnIngressDN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnIngressDN) && !is_string($useDevicePoolCgpnIngressDN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnIngressDN)), __LINE__);
        }
        $this->useDevicePoolCgpnIngressDN = $useDevicePoolCgpnIngressDN;
        return $this;
    }
    /**
     * Get msisdn value
     * @return string|null
     */
    public function getMsisdn()
    {
        return $this->msisdn;
    }
    /**
     * Set msisdn value
     * @param string $msisdn
     * @return RPhone
     */
    public function setMsisdn($msisdn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($msisdn) && strlen($msisdn) > 128) || (is_array($msisdn) && count($msisdn) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($msisdn) ? strlen($msisdn) : count($msisdn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($msisdn) && !is_string($msisdn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msisdn)), __LINE__);
        }
        $this->msisdn = $msisdn;
        return $this;
    }
    /**
     * Get enableCallRoutingToRdWhenNoneIsActive value
     * @return string|null
     */
    public function getEnableCallRoutingToRdWhenNoneIsActive()
    {
        return $this->enableCallRoutingToRdWhenNoneIsActive;
    }
    /**
     * Set enableCallRoutingToRdWhenNoneIsActive value
     * @param string $enableCallRoutingToRdWhenNoneIsActive
     * @return RPhone
     */
    public function setEnableCallRoutingToRdWhenNoneIsActive($enableCallRoutingToRdWhenNoneIsActive = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableCallRoutingToRdWhenNoneIsActive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCallRoutingToRdWhenNoneIsActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableCallRoutingToRdWhenNoneIsActive, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableCallRoutingToRdWhenNoneIsActive) && !is_string($enableCallRoutingToRdWhenNoneIsActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableCallRoutingToRdWhenNoneIsActive)), __LINE__);
        }
        $this->enableCallRoutingToRdWhenNoneIsActive = $enableCallRoutingToRdWhenNoneIsActive;
        return $this;
    }
    /**
     * Get wifiHotspotProfile value
     * @return XFkType|null
     */
    public function getWifiHotspotProfile()
    {
        return $this->wifiHotspotProfile;
    }
    /**
     * Set wifiHotspotProfile value
     * @param XFkType $wifiHotspotProfile
     * @return RPhone
     */
    public function setWifiHotspotProfile(XFkType $wifiHotspotProfile = null)
    {
        $this->wifiHotspotProfile = $wifiHotspotProfile;
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * @return XFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return $this->wirelessLanProfileGroup;
    }
    /**
     * Set wirelessLanProfileGroup value
     * @param XFkType $wirelessLanProfileGroup
     * @return RPhone
     */
    public function setWirelessLanProfileGroup(XFkType $wirelessLanProfileGroup = null)
    {
        $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return RPhone
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RPhone
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RPhone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
