<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parkMonForwardNoRetrieve StructType
 * @subpackage Structs
 */
class ParkMonForwardNoRetrieve extends AbstractStructBase
{
    /**
     * The usePersonalPreferences
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePersonalPreferences;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $destination;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * Constructor method for parkMonForwardNoRetrieve
     * @uses ParkMonForwardNoRetrieve::setUsePersonalPreferences()
     * @uses ParkMonForwardNoRetrieve::setDestination()
     * @uses ParkMonForwardNoRetrieve::setCallingSearchSpaceName()
     * @param string $usePersonalPreferences
     * @param string $destination
     * @param XFkType $callingSearchSpaceName
     */
    public function __construct($usePersonalPreferences = false, $destination = null, XFkType $callingSearchSpaceName = null)
    {
        $this
            ->setUsePersonalPreferences($usePersonalPreferences)
            ->setDestination($destination)
            ->setCallingSearchSpaceName($callingSearchSpaceName);
    }
    /**
     * Get usePersonalPreferences value
     * @return string|null
     */
    public function getUsePersonalPreferences()
    {
        return $this->usePersonalPreferences;
    }
    /**
     * Set usePersonalPreferences value
     * @param string $usePersonalPreferences
     * @return ParkMonForwardNoRetrieve
     */
    public function setUsePersonalPreferences($usePersonalPreferences = false)
    {
        // validation for constraint: pattern
        if (is_scalar($usePersonalPreferences) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $usePersonalPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($usePersonalPreferences, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($usePersonalPreferences) && !is_string($usePersonalPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usePersonalPreferences)), __LINE__);
        }
        $this->usePersonalPreferences = $usePersonalPreferences;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return ParkMonForwardNoRetrieve
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($destination) && strlen($destination) > 50) || (is_array($destination) && count($destination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($destination) ? strlen($destination) : count($destination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param XFkType $callingSearchSpaceName
     * @return ParkMonForwardNoRetrieve
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ParkMonForwardNoRetrieve
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
