<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pageSections StructType
 * @subpackage Structs
 */
class PageSections extends AbstractStructBase
{
    /**
     * The pageSection
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var PageSection[]
     */
    public $pageSection;
    /**
     * Constructor method for pageSections
     * @uses PageSections::setPageSection()
     * @param PageSection[] $pageSection
     */
    public function __construct(array $pageSection = array())
    {
        $this
            ->setPageSection($pageSection);
    }
    /**
     * Get pageSection value
     * @return PageSection[]|null
     */
    public function getPageSection()
    {
        return $this->pageSection;
    }
    /**
     * Set pageSection value
     * @throws \InvalidArgumentException
     * @param PageSection[] $pageSection
     * @return PageSections
     */
    public function setPageSection(array $pageSection = array())
    {
        foreach ($pageSection as $pageSectionsPageSectionItem) {
            // validation for constraint: itemType
            if (!$pageSectionsPageSectionItem instanceof PageSection) {
                throw new \InvalidArgumentException(sprintf('The pageSection property can only contain items of PageSection, "%s" given', is_object($pageSectionsPageSectionItem) ? get_class($pageSectionsPageSectionItem) : gettype($pageSectionsPageSectionItem)), __LINE__);
            }
        }
        $this->pageSection = $pageSection;
        return $this;
    }
    /**
     * Add item to pageSection value
     * @throws \InvalidArgumentException
     * @param PageSection $item
     * @return PageSections
     */
    public function addToPageSection(PageSection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PageSection) {
            throw new \InvalidArgumentException(sprintf('The pageSection property can only contain items of PageSection, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pageSection[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return PageSections
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
