<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for objectList StructType
 * @subpackage Structs
 */
class ObjectList extends AbstractStructBase
{
    /**
     * The object
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $object;
    /**
     * Constructor method for objectList
     * @uses ObjectList::setObject()
     * @param string[] $object
     */
    public function __construct(array $object = array())
    {
        $this
            ->setObject($object);
    }
    /**
     * Get object value
     * @return string[]|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @uses XChangeType::valueIsValid()
     * @uses XChangeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $object
     * @return ObjectList
     */
    public function setObject(array $object = array())
    {
        $invalidValues = array();
        foreach ($object as $objectListObjectItem) {
            if (!XChangeType::valueIsValid($objectListObjectItem)) {
                $invalidValues[] = var_export($objectListObjectItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', XChangeType::getValidValues())), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Add item to object value
     * @uses XChangeType::valueIsValid()
     * @uses XChangeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return ObjectList
     */
    public function addToObject($item)
    {
        // validation for constraint: enumeration
        if (!XChangeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', XChangeType::getValidValues())), __LINE__);
        }
        $this->object[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ObjectList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
