<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORSipProfile StructType
 * @subpackage Structs
 */
class ORSipProfile extends AbstractStructBase
{
    /**
     * The userInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $userInfo;
    /**
     * The dtmfDbLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $dtmfDbLevel;
    /**
     * The callHoldRingback
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callHoldRingback;
    /**
     * The anonymousCallBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $anonymousCallBlock;
    /**
     * The callerIdBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callerIdBlock;
    /**
     * The dndControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $dndControl;
    /**
     * The telnetLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $telnetLevel;
    /**
     * The rerouteIncomingRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $rerouteIncomingRequest;
    /**
     * The resourcePriorityNamespaceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $resourcePriorityNamespaceListName;
    /**
     * The rsvpOverSip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $rsvpOverSip;
    /**
     * The sipRe11XxEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $sipRe11XxEnabled;
    /**
     * The gClear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $gClear;
    /**
     * The sipBandwidthModifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $sipBandwidthModifier;
    /**
     * The userAgentServerHeaderInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $userAgentServerHeaderInfo;
    /**
     * The sipNormalizationScript
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $sipNormalizationScript;
    /**
     * The dialStringInterpretation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $dialStringInterpretation;
    /**
     * The acceptAudioCodecPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $acceptAudioCodecPreferences;
    /**
     * The resourcePriorityNamespace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $resourcePriorityNamespace;
    /**
     * The callingLineIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $callingLineIdentification;
    /**
     * The videoCallTrafficClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $videoCallTrafficClass;
    /**
     * The sdpTransparency
     * Meta informations extracted from the WSDL
     * - documentation: SDP Transparency Profile for SIP Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $sdpTransparency;
    /**
     * The sipSessionRefreshMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $sipSessionRefreshMethod;
    /**
     * The earlyOfferSuppVoiceCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $earlyOfferSuppVoiceCall;
    /**
     * The cucmVersionInSipHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $cucmVersionInSipHeader;
    /**
     * The confidentialAccessLevelHeaders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $confidentialAccessLevelHeaders;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORSipProfile
     * @uses ORSipProfile::setUserInfo()
     * @uses ORSipProfile::setDtmfDbLevel()
     * @uses ORSipProfile::setCallHoldRingback()
     * @uses ORSipProfile::setAnonymousCallBlock()
     * @uses ORSipProfile::setCallerIdBlock()
     * @uses ORSipProfile::setDndControl()
     * @uses ORSipProfile::setTelnetLevel()
     * @uses ORSipProfile::setRerouteIncomingRequest()
     * @uses ORSipProfile::setResourcePriorityNamespaceListName()
     * @uses ORSipProfile::setRsvpOverSip()
     * @uses ORSipProfile::setSipRe11XxEnabled()
     * @uses ORSipProfile::setGClear()
     * @uses ORSipProfile::setSipBandwidthModifier()
     * @uses ORSipProfile::setUserAgentServerHeaderInfo()
     * @uses ORSipProfile::setSipNormalizationScript()
     * @uses ORSipProfile::setDialStringInterpretation()
     * @uses ORSipProfile::setAcceptAudioCodecPreferences()
     * @uses ORSipProfile::setResourcePriorityNamespace()
     * @uses ORSipProfile::setCallingLineIdentification()
     * @uses ORSipProfile::setVideoCallTrafficClass()
     * @uses ORSipProfile::setSdpTransparency()
     * @uses ORSipProfile::setSipSessionRefreshMethod()
     * @uses ORSipProfile::setEarlyOfferSuppVoiceCall()
     * @uses ORSipProfile::setCucmVersionInSipHeader()
     * @uses ORSipProfile::setConfidentialAccessLevelHeaders()
     * @uses ORSipProfile::setUuid()
     * @param ORFkType $userInfo
     * @param ORFkType $dtmfDbLevel
     * @param ORFkType $callHoldRingback
     * @param ORFkType $anonymousCallBlock
     * @param ORFkType $callerIdBlock
     * @param ORFkType $dndControl
     * @param ORFkType $telnetLevel
     * @param ORFkType $rerouteIncomingRequest
     * @param ORFkType $resourcePriorityNamespaceListName
     * @param ORFkType $rsvpOverSip
     * @param ORFkType $sipRe11XxEnabled
     * @param ORFkType $gClear
     * @param ORFkType $sipBandwidthModifier
     * @param ORFkType $userAgentServerHeaderInfo
     * @param ORFkType $sipNormalizationScript
     * @param ORFkType $dialStringInterpretation
     * @param ORFkType $acceptAudioCodecPreferences
     * @param ORFkType $resourcePriorityNamespace
     * @param ORFkType $callingLineIdentification
     * @param ORFkType $videoCallTrafficClass
     * @param ORFkType $sdpTransparency
     * @param ORFkType $sipSessionRefreshMethod
     * @param ORFkType $earlyOfferSuppVoiceCall
     * @param ORFkType $cucmVersionInSipHeader
     * @param ORFkType $confidentialAccessLevelHeaders
     * @param string $uuid
     */
    public function __construct(ORFkType $userInfo = null, ORFkType $dtmfDbLevel = null, ORFkType $callHoldRingback = null, ORFkType $anonymousCallBlock = null, ORFkType $callerIdBlock = null, ORFkType $dndControl = null, ORFkType $telnetLevel = null, ORFkType $rerouteIncomingRequest = null, ORFkType $resourcePriorityNamespaceListName = null, ORFkType $rsvpOverSip = null, ORFkType $sipRe11XxEnabled = null, ORFkType $gClear = null, ORFkType $sipBandwidthModifier = null, ORFkType $userAgentServerHeaderInfo = null, ORFkType $sipNormalizationScript = null, ORFkType $dialStringInterpretation = null, ORFkType $acceptAudioCodecPreferences = null, ORFkType $resourcePriorityNamespace = null, ORFkType $callingLineIdentification = null, ORFkType $videoCallTrafficClass = null, ORFkType $sdpTransparency = null, ORFkType $sipSessionRefreshMethod = null, ORFkType $earlyOfferSuppVoiceCall = null, ORFkType $cucmVersionInSipHeader = null, ORFkType $confidentialAccessLevelHeaders = null, $uuid = null)
    {
        $this
            ->setUserInfo($userInfo)
            ->setDtmfDbLevel($dtmfDbLevel)
            ->setCallHoldRingback($callHoldRingback)
            ->setAnonymousCallBlock($anonymousCallBlock)
            ->setCallerIdBlock($callerIdBlock)
            ->setDndControl($dndControl)
            ->setTelnetLevel($telnetLevel)
            ->setRerouteIncomingRequest($rerouteIncomingRequest)
            ->setResourcePriorityNamespaceListName($resourcePriorityNamespaceListName)
            ->setRsvpOverSip($rsvpOverSip)
            ->setSipRe11XxEnabled($sipRe11XxEnabled)
            ->setGClear($gClear)
            ->setSipBandwidthModifier($sipBandwidthModifier)
            ->setUserAgentServerHeaderInfo($userAgentServerHeaderInfo)
            ->setSipNormalizationScript($sipNormalizationScript)
            ->setDialStringInterpretation($dialStringInterpretation)
            ->setAcceptAudioCodecPreferences($acceptAudioCodecPreferences)
            ->setResourcePriorityNamespace($resourcePriorityNamespace)
            ->setCallingLineIdentification($callingLineIdentification)
            ->setVideoCallTrafficClass($videoCallTrafficClass)
            ->setSdpTransparency($sdpTransparency)
            ->setSipSessionRefreshMethod($sipSessionRefreshMethod)
            ->setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall)
            ->setCucmVersionInSipHeader($cucmVersionInSipHeader)
            ->setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders)
            ->setUuid($uuid);
    }
    /**
     * Get userInfo value
     * @return ORFkType|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param ORFkType $userInfo
     * @return ORSipProfile
     */
    public function setUserInfo(ORFkType $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get dtmfDbLevel value
     * @return ORFkType|null
     */
    public function getDtmfDbLevel()
    {
        return $this->dtmfDbLevel;
    }
    /**
     * Set dtmfDbLevel value
     * @param ORFkType $dtmfDbLevel
     * @return ORSipProfile
     */
    public function setDtmfDbLevel(ORFkType $dtmfDbLevel = null)
    {
        $this->dtmfDbLevel = $dtmfDbLevel;
        return $this;
    }
    /**
     * Get callHoldRingback value
     * @return ORFkType|null
     */
    public function getCallHoldRingback()
    {
        return $this->callHoldRingback;
    }
    /**
     * Set callHoldRingback value
     * @param ORFkType $callHoldRingback
     * @return ORSipProfile
     */
    public function setCallHoldRingback(ORFkType $callHoldRingback = null)
    {
        $this->callHoldRingback = $callHoldRingback;
        return $this;
    }
    /**
     * Get anonymousCallBlock value
     * @return ORFkType|null
     */
    public function getAnonymousCallBlock()
    {
        return $this->anonymousCallBlock;
    }
    /**
     * Set anonymousCallBlock value
     * @param ORFkType $anonymousCallBlock
     * @return ORSipProfile
     */
    public function setAnonymousCallBlock(ORFkType $anonymousCallBlock = null)
    {
        $this->anonymousCallBlock = $anonymousCallBlock;
        return $this;
    }
    /**
     * Get callerIdBlock value
     * @return ORFkType|null
     */
    public function getCallerIdBlock()
    {
        return $this->callerIdBlock;
    }
    /**
     * Set callerIdBlock value
     * @param ORFkType $callerIdBlock
     * @return ORSipProfile
     */
    public function setCallerIdBlock(ORFkType $callerIdBlock = null)
    {
        $this->callerIdBlock = $callerIdBlock;
        return $this;
    }
    /**
     * Get dndControl value
     * @return ORFkType|null
     */
    public function getDndControl()
    {
        return $this->dndControl;
    }
    /**
     * Set dndControl value
     * @param ORFkType $dndControl
     * @return ORSipProfile
     */
    public function setDndControl(ORFkType $dndControl = null)
    {
        $this->dndControl = $dndControl;
        return $this;
    }
    /**
     * Get telnetLevel value
     * @return ORFkType|null
     */
    public function getTelnetLevel()
    {
        return $this->telnetLevel;
    }
    /**
     * Set telnetLevel value
     * @param ORFkType $telnetLevel
     * @return ORSipProfile
     */
    public function setTelnetLevel(ORFkType $telnetLevel = null)
    {
        $this->telnetLevel = $telnetLevel;
        return $this;
    }
    /**
     * Get rerouteIncomingRequest value
     * @return ORFkType|null
     */
    public function getRerouteIncomingRequest()
    {
        return $this->rerouteIncomingRequest;
    }
    /**
     * Set rerouteIncomingRequest value
     * @param ORFkType $rerouteIncomingRequest
     * @return ORSipProfile
     */
    public function setRerouteIncomingRequest(ORFkType $rerouteIncomingRequest = null)
    {
        $this->rerouteIncomingRequest = $rerouteIncomingRequest;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceListName value
     * @return ORFkType|null
     */
    public function getResourcePriorityNamespaceListName()
    {
        return $this->resourcePriorityNamespaceListName;
    }
    /**
     * Set resourcePriorityNamespaceListName value
     * @param ORFkType $resourcePriorityNamespaceListName
     * @return ORSipProfile
     */
    public function setResourcePriorityNamespaceListName(ORFkType $resourcePriorityNamespaceListName = null)
    {
        $this->resourcePriorityNamespaceListName = $resourcePriorityNamespaceListName;
        return $this;
    }
    /**
     * Get rsvpOverSip value
     * @return ORFkType|null
     */
    public function getRsvpOverSip()
    {
        return $this->rsvpOverSip;
    }
    /**
     * Set rsvpOverSip value
     * @param ORFkType $rsvpOverSip
     * @return ORSipProfile
     */
    public function setRsvpOverSip(ORFkType $rsvpOverSip = null)
    {
        $this->rsvpOverSip = $rsvpOverSip;
        return $this;
    }
    /**
     * Get sipRe11XxEnabled value
     * @return ORFkType|null
     */
    public function getSipRe11XxEnabled()
    {
        return $this->sipRe11XxEnabled;
    }
    /**
     * Set sipRe11XxEnabled value
     * @param ORFkType $sipRe11XxEnabled
     * @return ORSipProfile
     */
    public function setSipRe11XxEnabled(ORFkType $sipRe11XxEnabled = null)
    {
        $this->sipRe11XxEnabled = $sipRe11XxEnabled;
        return $this;
    }
    /**
     * Get gClear value
     * @return ORFkType|null
     */
    public function getGClear()
    {
        return $this->gClear;
    }
    /**
     * Set gClear value
     * @param ORFkType $gClear
     * @return ORSipProfile
     */
    public function setGClear(ORFkType $gClear = null)
    {
        $this->gClear = $gClear;
        return $this;
    }
    /**
     * Get sipBandwidthModifier value
     * @return ORFkType|null
     */
    public function getSipBandwidthModifier()
    {
        return $this->sipBandwidthModifier;
    }
    /**
     * Set sipBandwidthModifier value
     * @param ORFkType $sipBandwidthModifier
     * @return ORSipProfile
     */
    public function setSipBandwidthModifier(ORFkType $sipBandwidthModifier = null)
    {
        $this->sipBandwidthModifier = $sipBandwidthModifier;
        return $this;
    }
    /**
     * Get userAgentServerHeaderInfo value
     * @return ORFkType|null
     */
    public function getUserAgentServerHeaderInfo()
    {
        return $this->userAgentServerHeaderInfo;
    }
    /**
     * Set userAgentServerHeaderInfo value
     * @param ORFkType $userAgentServerHeaderInfo
     * @return ORSipProfile
     */
    public function setUserAgentServerHeaderInfo(ORFkType $userAgentServerHeaderInfo = null)
    {
        $this->userAgentServerHeaderInfo = $userAgentServerHeaderInfo;
        return $this;
    }
    /**
     * Get sipNormalizationScript value
     * @return ORFkType|null
     */
    public function getSipNormalizationScript()
    {
        return $this->sipNormalizationScript;
    }
    /**
     * Set sipNormalizationScript value
     * @param ORFkType $sipNormalizationScript
     * @return ORSipProfile
     */
    public function setSipNormalizationScript(ORFkType $sipNormalizationScript = null)
    {
        $this->sipNormalizationScript = $sipNormalizationScript;
        return $this;
    }
    /**
     * Get dialStringInterpretation value
     * @return ORFkType|null
     */
    public function getDialStringInterpretation()
    {
        return $this->dialStringInterpretation;
    }
    /**
     * Set dialStringInterpretation value
     * @param ORFkType $dialStringInterpretation
     * @return ORSipProfile
     */
    public function setDialStringInterpretation(ORFkType $dialStringInterpretation = null)
    {
        $this->dialStringInterpretation = $dialStringInterpretation;
        return $this;
    }
    /**
     * Get acceptAudioCodecPreferences value
     * @return ORFkType|null
     */
    public function getAcceptAudioCodecPreferences()
    {
        return $this->acceptAudioCodecPreferences;
    }
    /**
     * Set acceptAudioCodecPreferences value
     * @param ORFkType $acceptAudioCodecPreferences
     * @return ORSipProfile
     */
    public function setAcceptAudioCodecPreferences(ORFkType $acceptAudioCodecPreferences = null)
    {
        $this->acceptAudioCodecPreferences = $acceptAudioCodecPreferences;
        return $this;
    }
    /**
     * Get resourcePriorityNamespace value
     * @return ORFkType|null
     */
    public function getResourcePriorityNamespace()
    {
        return $this->resourcePriorityNamespace;
    }
    /**
     * Set resourcePriorityNamespace value
     * @param ORFkType $resourcePriorityNamespace
     * @return ORSipProfile
     */
    public function setResourcePriorityNamespace(ORFkType $resourcePriorityNamespace = null)
    {
        $this->resourcePriorityNamespace = $resourcePriorityNamespace;
        return $this;
    }
    /**
     * Get callingLineIdentification value
     * @return ORFkType|null
     */
    public function getCallingLineIdentification()
    {
        return $this->callingLineIdentification;
    }
    /**
     * Set callingLineIdentification value
     * @param ORFkType $callingLineIdentification
     * @return ORSipProfile
     */
    public function setCallingLineIdentification(ORFkType $callingLineIdentification = null)
    {
        $this->callingLineIdentification = $callingLineIdentification;
        return $this;
    }
    /**
     * Get videoCallTrafficClass value
     * @return ORFkType|null
     */
    public function getVideoCallTrafficClass()
    {
        return $this->videoCallTrafficClass;
    }
    /**
     * Set videoCallTrafficClass value
     * @param ORFkType $videoCallTrafficClass
     * @return ORSipProfile
     */
    public function setVideoCallTrafficClass(ORFkType $videoCallTrafficClass = null)
    {
        $this->videoCallTrafficClass = $videoCallTrafficClass;
        return $this;
    }
    /**
     * Get sdpTransparency value
     * @return ORFkType|null
     */
    public function getSdpTransparency()
    {
        return $this->sdpTransparency;
    }
    /**
     * Set sdpTransparency value
     * @param ORFkType $sdpTransparency
     * @return ORSipProfile
     */
    public function setSdpTransparency(ORFkType $sdpTransparency = null)
    {
        $this->sdpTransparency = $sdpTransparency;
        return $this;
    }
    /**
     * Get sipSessionRefreshMethod value
     * @return ORFkType|null
     */
    public function getSipSessionRefreshMethod()
    {
        return $this->sipSessionRefreshMethod;
    }
    /**
     * Set sipSessionRefreshMethod value
     * @param ORFkType $sipSessionRefreshMethod
     * @return ORSipProfile
     */
    public function setSipSessionRefreshMethod(ORFkType $sipSessionRefreshMethod = null)
    {
        $this->sipSessionRefreshMethod = $sipSessionRefreshMethod;
        return $this;
    }
    /**
     * Get earlyOfferSuppVoiceCall value
     * @return ORFkType|null
     */
    public function getEarlyOfferSuppVoiceCall()
    {
        return $this->earlyOfferSuppVoiceCall;
    }
    /**
     * Set earlyOfferSuppVoiceCall value
     * @param ORFkType $earlyOfferSuppVoiceCall
     * @return ORSipProfile
     */
    public function setEarlyOfferSuppVoiceCall(ORFkType $earlyOfferSuppVoiceCall = null)
    {
        $this->earlyOfferSuppVoiceCall = $earlyOfferSuppVoiceCall;
        return $this;
    }
    /**
     * Get cucmVersionInSipHeader value
     * @return ORFkType|null
     */
    public function getCucmVersionInSipHeader()
    {
        return $this->cucmVersionInSipHeader;
    }
    /**
     * Set cucmVersionInSipHeader value
     * @param ORFkType $cucmVersionInSipHeader
     * @return ORSipProfile
     */
    public function setCucmVersionInSipHeader(ORFkType $cucmVersionInSipHeader = null)
    {
        $this->cucmVersionInSipHeader = $cucmVersionInSipHeader;
        return $this;
    }
    /**
     * Get confidentialAccessLevelHeaders value
     * @return ORFkType|null
     */
    public function getConfidentialAccessLevelHeaders()
    {
        return $this->confidentialAccessLevelHeaders;
    }
    /**
     * Set confidentialAccessLevelHeaders value
     * @param ORFkType $confidentialAccessLevelHeaders
     * @return ORSipProfile
     */
    public function setConfidentialAccessLevelHeaders(ORFkType $confidentialAccessLevelHeaders = null)
    {
        $this->confidentialAccessLevelHeaders = $confidentialAccessLevelHeaders;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return ORSipProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ORSipProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
