<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORPhoneLine StructType
 * @subpackage Structs
 */
class ORPhoneLine extends AbstractStructBase
{
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORDirn
     */
    public $dirn;
    /**
     * The ringSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $ringSetting;
    /**
     * The consecutiveRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: Consecutive Rings Setting. Replaces the consective ring setting on IPPhone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $consecutiveRingSetting;
    /**
     * The ringSettingIdlePickupAlert
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $ringSettingIdlePickupAlert;
    /**
     * The ringSettingActivePickupAlert
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $ringSettingActivePickupAlert;
    /**
     * The mwlPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $mwlPolicy;
    /**
     * The recordingProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta informations extracted from the WSDL
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $audibleMwi;
    /**
     * The partitionUsage
     * Meta informations extracted from the WSDL
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $partitionUsage;
    /**
     * The recordingMediaSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $recordingMediaSource;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORPhoneLine
     * @uses ORPhoneLine::setDirn()
     * @uses ORPhoneLine::setRingSetting()
     * @uses ORPhoneLine::setConsecutiveRingSetting()
     * @uses ORPhoneLine::setRingSettingIdlePickupAlert()
     * @uses ORPhoneLine::setRingSettingActivePickupAlert()
     * @uses ORPhoneLine::setMwlPolicy()
     * @uses ORPhoneLine::setRecordingProfileName()
     * @uses ORPhoneLine::setMonitoringCssName()
     * @uses ORPhoneLine::setRecordingFlag()
     * @uses ORPhoneLine::setAudibleMwi()
     * @uses ORPhoneLine::setPartitionUsage()
     * @uses ORPhoneLine::setRecordingMediaSource()
     * @uses ORPhoneLine::setCtiid()
     * @uses ORPhoneLine::setUuid()
     * @param ORDirn $dirn
     * @param ORFkType $ringSetting
     * @param ORFkType $consecutiveRingSetting
     * @param ORFkType $ringSettingIdlePickupAlert
     * @param ORFkType $ringSettingActivePickupAlert
     * @param ORFkType $mwlPolicy
     * @param ORFkType $recordingProfileName
     * @param ORFkType $monitoringCssName
     * @param ORFkType $recordingFlag
     * @param ORFkType $audibleMwi
     * @param ORFkType $partitionUsage
     * @param ORFkType $recordingMediaSource
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(ORDirn $dirn = null, ORFkType $ringSetting = null, ORFkType $consecutiveRingSetting = null, ORFkType $ringSettingIdlePickupAlert = null, ORFkType $ringSettingActivePickupAlert = null, ORFkType $mwlPolicy = null, ORFkType $recordingProfileName = null, ORFkType $monitoringCssName = null, ORFkType $recordingFlag = null, ORFkType $audibleMwi = null, ORFkType $partitionUsage = null, ORFkType $recordingMediaSource = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setDirn($dirn)
            ->setRingSetting($ringSetting)
            ->setConsecutiveRingSetting($consecutiveRingSetting)
            ->setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert)
            ->setRingSettingActivePickupAlert($ringSettingActivePickupAlert)
            ->setMwlPolicy($mwlPolicy)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setPartitionUsage($partitionUsage)
            ->setRecordingMediaSource($recordingMediaSource)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get dirn value
     * @return ORDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param ORDirn $dirn
     * @return ORPhoneLine
     */
    public function setDirn(ORDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get ringSetting value
     * @return ORFkType|null
     */
    public function getRingSetting()
    {
        return $this->ringSetting;
    }
    /**
     * Set ringSetting value
     * @param ORFkType $ringSetting
     * @return ORPhoneLine
     */
    public function setRingSetting(ORFkType $ringSetting = null)
    {
        $this->ringSetting = $ringSetting;
        return $this;
    }
    /**
     * Get consecutiveRingSetting value
     * @return ORFkType|null
     */
    public function getConsecutiveRingSetting()
    {
        return $this->consecutiveRingSetting;
    }
    /**
     * Set consecutiveRingSetting value
     * @param ORFkType $consecutiveRingSetting
     * @return ORPhoneLine
     */
    public function setConsecutiveRingSetting(ORFkType $consecutiveRingSetting = null)
    {
        $this->consecutiveRingSetting = $consecutiveRingSetting;
        return $this;
    }
    /**
     * Get ringSettingIdlePickupAlert value
     * @return ORFkType|null
     */
    public function getRingSettingIdlePickupAlert()
    {
        return $this->ringSettingIdlePickupAlert;
    }
    /**
     * Set ringSettingIdlePickupAlert value
     * @param ORFkType $ringSettingIdlePickupAlert
     * @return ORPhoneLine
     */
    public function setRingSettingIdlePickupAlert(ORFkType $ringSettingIdlePickupAlert = null)
    {
        $this->ringSettingIdlePickupAlert = $ringSettingIdlePickupAlert;
        return $this;
    }
    /**
     * Get ringSettingActivePickupAlert value
     * @return ORFkType|null
     */
    public function getRingSettingActivePickupAlert()
    {
        return $this->ringSettingActivePickupAlert;
    }
    /**
     * Set ringSettingActivePickupAlert value
     * @param ORFkType $ringSettingActivePickupAlert
     * @return ORPhoneLine
     */
    public function setRingSettingActivePickupAlert(ORFkType $ringSettingActivePickupAlert = null)
    {
        $this->ringSettingActivePickupAlert = $ringSettingActivePickupAlert;
        return $this;
    }
    /**
     * Get mwlPolicy value
     * @return ORFkType|null
     */
    public function getMwlPolicy()
    {
        return $this->mwlPolicy;
    }
    /**
     * Set mwlPolicy value
     * @param ORFkType $mwlPolicy
     * @return ORPhoneLine
     */
    public function setMwlPolicy(ORFkType $mwlPolicy = null)
    {
        $this->mwlPolicy = $mwlPolicy;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * @return ORFkType|null
     */
    public function getRecordingProfileName()
    {
        return $this->recordingProfileName;
    }
    /**
     * Set recordingProfileName value
     * @param ORFkType $recordingProfileName
     * @return ORPhoneLine
     */
    public function setRecordingProfileName(ORFkType $recordingProfileName = null)
    {
        $this->recordingProfileName = $recordingProfileName;
        return $this;
    }
    /**
     * Get monitoringCssName value
     * @return ORFkType|null
     */
    public function getMonitoringCssName()
    {
        return $this->monitoringCssName;
    }
    /**
     * Set monitoringCssName value
     * @param ORFkType $monitoringCssName
     * @return ORPhoneLine
     */
    public function setMonitoringCssName(ORFkType $monitoringCssName = null)
    {
        $this->monitoringCssName = $monitoringCssName;
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return ORFkType|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @param ORFkType $recordingFlag
     * @return ORPhoneLine
     */
    public function setRecordingFlag(ORFkType $recordingFlag = null)
    {
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return ORFkType|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @param ORFkType $audibleMwi
     * @return ORPhoneLine
     */
    public function setAudibleMwi(ORFkType $audibleMwi = null)
    {
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return ORFkType|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @param ORFkType $partitionUsage
     * @return ORPhoneLine
     */
    public function setPartitionUsage(ORFkType $partitionUsage = null)
    {
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get recordingMediaSource value
     * @return ORFkType|null
     */
    public function getRecordingMediaSource()
    {
        return $this->recordingMediaSource;
    }
    /**
     * Set recordingMediaSource value
     * @param ORFkType $recordingMediaSource
     * @return ORPhoneLine
     */
    public function setRecordingMediaSource(ORFkType $recordingMediaSource = null)
    {
        $this->recordingMediaSource = $recordingMediaSource;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return ORPhoneLine
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return ORPhoneLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ORPhoneLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
