<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORDirectoryUri StructType
 * @subpackage Structs
 */
class ORDirectoryUri extends AbstractStructBase
{
    /**
     * The partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ORFkType
     */
    public $partition;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORDirectoryUri
     * @uses ORDirectoryUri::setPartition()
     * @uses ORDirectoryUri::setUuid()
     * @param ORFkType $partition
     * @param string $uuid
     */
    public function __construct(ORFkType $partition = null, $uuid = null)
    {
        $this
            ->setPartition($partition)
            ->setUuid($uuid);
    }
    /**
     * Get partition value
     * @return ORFkType|null
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param ORFkType $partition
     * @return ORDirectoryUri
     */
    public function setPartition(ORFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return ORDirectoryUri
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ORDirectoryUri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
