<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORBLFDirectedCallPark StructType
 * @subpackage Structs
 */
class ORBLFDirectedCallPark extends AbstractStructBase
{
    /**
     * The directedCallParkId
     * Meta informations extracted from the WSDL
     * - documentation: Only the uuid attribute is read
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $directedCallParkId;
    /**
     * The directedCallParkDnAndPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DirectedCallParkDnAndPartition
     */
    public $directedCallParkDnAndPartition;
    /**
     * Constructor method for ORBLFDirectedCallPark
     * @uses ORBLFDirectedCallPark::setDirectedCallParkId()
     * @uses ORBLFDirectedCallPark::setDirectedCallParkDnAndPartition()
     * @param string $directedCallParkId
     * @param DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     */
    public function __construct($directedCallParkId = null, DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null)
    {
        $this
            ->setDirectedCallParkId($directedCallParkId)
            ->setDirectedCallParkDnAndPartition($directedCallParkDnAndPartition);
    }
    /**
     * Get directedCallParkId value
     * @return string|null
     */
    public function getDirectedCallParkId()
    {
        return $this->directedCallParkId;
    }
    /**
     * Set directedCallParkId value
     * @param string $directedCallParkId
     * @return ORBLFDirectedCallPark
     */
    public function setDirectedCallParkId($directedCallParkId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($directedCallParkId) && !preg_match('/\{........-....-....-....-............\}/', $directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($directedCallParkId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($directedCallParkId) && !is_string($directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directedCallParkId)), __LINE__);
        }
        $this->directedCallParkId = $directedCallParkId;
        return $this;
    }
    /**
     * Get directedCallParkDnAndPartition value
     * @return DirectedCallParkDnAndPartition|null
     */
    public function getDirectedCallParkDnAndPartition()
    {
        return $this->directedCallParkDnAndPartition;
    }
    /**
     * Set directedCallParkDnAndPartition value
     * @param DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     * @return ORBLFDirectedCallPark
     */
    public function setDirectedCallParkDnAndPartition(DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null)
    {
        $this->directedCallParkDnAndPartition = $directedCallParkDnAndPartition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ORBLFDirectedCallPark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
