<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LVpnGatewayMember StructType
 * @subpackage Structs
 */
class LVpnGatewayMember extends AbstractStructBase
{
    /**
     * The issuerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $issuerName;
    /**
     * The serialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $serialNumber;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LVpnGatewayMember
     * @uses LVpnGatewayMember::setIssuerName()
     * @uses LVpnGatewayMember::setSerialNumber()
     * @uses LVpnGatewayMember::setUuid()
     * @param string $issuerName
     * @param string $serialNumber
     * @param string $uuid
     */
    public function __construct($issuerName = null, $serialNumber = null, $uuid = null)
    {
        $this
            ->setIssuerName($issuerName)
            ->setSerialNumber($serialNumber)
            ->setUuid($uuid);
    }
    /**
     * Get issuerName value
     * @return string|null
     */
    public function getIssuerName()
    {
        return $this->issuerName;
    }
    /**
     * Set issuerName value
     * @param string $issuerName
     * @return LVpnGatewayMember
     */
    public function setIssuerName($issuerName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($issuerName) && strlen($issuerName) > 255) || (is_array($issuerName) && count($issuerName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($issuerName) ? strlen($issuerName) : count($issuerName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issuerName) && !is_string($issuerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerName)), __LINE__);
        }
        $this->issuerName = $issuerName;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return LVpnGatewayMember
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serialNumber) && strlen($serialNumber) > 50) || (is_array($serialNumber) && count($serialNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($serialNumber) ? strlen($serialNumber) : count($serialNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LVpnGatewayMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LVpnGatewayMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
