<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSyslogConfiguration StructType
 * @subpackage Structs
 */
class LSyslogConfiguration extends AbstractStructBase
{
    /**
     * The alarmConfigs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 1
     * @var LSyslogConfig[]
     */
    public $alarmConfigs;
    /**
     * The serverName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serverName;
    /**
     * The serviceGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceGroup;
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $service;
    /**
     * The EndPointAlarm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $EndPointAlarm;
    /**
     * Constructor method for LSyslogConfiguration
     * @uses LSyslogConfiguration::setAlarmConfigs()
     * @uses LSyslogConfiguration::setServerName()
     * @uses LSyslogConfiguration::setServiceGroup()
     * @uses LSyslogConfiguration::setService()
     * @uses LSyslogConfiguration::setEndPointAlarm()
     * @param LSyslogConfig[] $alarmConfigs
     * @param string $serverName
     * @param string $serviceGroup
     * @param string $service
     * @param string $endPointAlarm
     */
    public function __construct(array $alarmConfigs = array(), $serverName = null, $serviceGroup = null, $service = null, $endPointAlarm = null)
    {
        $this
            ->setAlarmConfigs($alarmConfigs)
            ->setServerName($serverName)
            ->setServiceGroup($serviceGroup)
            ->setService($service)
            ->setEndPointAlarm($endPointAlarm);
    }
    /**
     * Get alarmConfigs value
     * @return LSyslogConfig[]
     */
    public function getAlarmConfigs()
    {
        return $this->alarmConfigs;
    }
    /**
     * Set alarmConfigs value
     * @throws \InvalidArgumentException
     * @param LSyslogConfig[] $alarmConfigs
     * @return LSyslogConfiguration
     */
    public function setAlarmConfigs(array $alarmConfigs = array())
    {
        foreach ($alarmConfigs as $lSyslogConfigurationAlarmConfigsItem) {
            // validation for constraint: itemType
            if (!$lSyslogConfigurationAlarmConfigsItem instanceof LSyslogConfig) {
                throw new \InvalidArgumentException(sprintf('The alarmConfigs property can only contain items of LSyslogConfig, "%s" given', is_object($lSyslogConfigurationAlarmConfigsItem) ? get_class($lSyslogConfigurationAlarmConfigsItem) : gettype($lSyslogConfigurationAlarmConfigsItem)), __LINE__);
            }
        }
        $this->alarmConfigs = $alarmConfigs;
        return $this;
    }
    /**
     * Add item to alarmConfigs value
     * @throws \InvalidArgumentException
     * @param LSyslogConfig $item
     * @return LSyslogConfiguration
     */
    public function addToAlarmConfigs(LSyslogConfig $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof LSyslogConfig) {
            throw new \InvalidArgumentException(sprintf('The alarmConfigs property can only contain items of LSyslogConfig, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->alarmConfigs[] = $item;
        return $this;
    }
    /**
     * Get serverName value
     * @return string|null
     */
    public function getServerName()
    {
        return $this->serverName;
    }
    /**
     * Set serverName value
     * @param string $serverName
     * @return LSyslogConfiguration
     */
    public function setServerName($serverName = null)
    {
        // validation for constraint: string
        if (!is_null($serverName) && !is_string($serverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serverName)), __LINE__);
        }
        $this->serverName = $serverName;
        return $this;
    }
    /**
     * Get serviceGroup value
     * @return string|null
     */
    public function getServiceGroup()
    {
        return $this->serviceGroup;
    }
    /**
     * Set serviceGroup value
     * @uses XServiceGrouping::valueIsValid()
     * @uses XServiceGrouping::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceGroup
     * @return LSyslogConfiguration
     */
    public function setServiceGroup($serviceGroup = null)
    {
        // validation for constraint: enumeration
        if (!XServiceGrouping::valueIsValid($serviceGroup)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceGroup, implode(', ', XServiceGrouping::getValidValues())), __LINE__);
        }
        $this->serviceGroup = $serviceGroup;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return LSyslogConfiguration
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get EndPointAlarm value
     * @return string|null
     */
    public function getEndPointAlarm()
    {
        return $this->EndPointAlarm;
    }
    /**
     * Set EndPointAlarm value
     * @param string $endPointAlarm
     * @return LSyslogConfiguration
     */
    public function setEndPointAlarm($endPointAlarm = null)
    {
        // validation for constraint: pattern
        if (is_scalar($endPointAlarm) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $endPointAlarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($endPointAlarm, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endPointAlarm) && !is_string($endPointAlarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endPointAlarm)), __LINE__);
        }
        $this->EndPointAlarm = $endPointAlarm;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LSyslogConfiguration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
