<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLineGroupMember StructType
 * @subpackage Structs
 */
class LLineGroupMember extends AbstractStructBase
{
    /**
     * The lineSelectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lineSelectionOrder;
    /**
     * The directoryNumber
     * Meta informations extracted from the WSDL
     * - documentation: The uuid attribute is read here
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LDirn
     */
    public $directoryNumber;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLineGroupMember
     * @uses LLineGroupMember::setLineSelectionOrder()
     * @uses LLineGroupMember::setDirectoryNumber()
     * @uses LLineGroupMember::setUuid()
     * @param string $lineSelectionOrder
     * @param LDirn $directoryNumber
     * @param string $uuid
     */
    public function __construct($lineSelectionOrder = null, LDirn $directoryNumber = null, $uuid = null)
    {
        $this
            ->setLineSelectionOrder($lineSelectionOrder)
            ->setDirectoryNumber($directoryNumber)
            ->setUuid($uuid);
    }
    /**
     * Get lineSelectionOrder value
     * @return string|null
     */
    public function getLineSelectionOrder()
    {
        return $this->lineSelectionOrder;
    }
    /**
     * Set lineSelectionOrder value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineSelectionOrder
     * @return LLineGroupMember
     */
    public function setLineSelectionOrder($lineSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($lineSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lineSelectionOrder, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->lineSelectionOrder = $lineSelectionOrder;
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return LDirn|null
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param LDirn $directoryNumber
     * @return LLineGroupMember
     */
    public function setDirectoryNumber(LDirn $directoryNumber = null)
    {
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LLineGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LLineGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
