<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LGeoLocationFilter StructType
 * @subpackage Structs
 */
class LGeoLocationFilter extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The useCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCountry;
    /**
     * The useNationalSubDivision
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useNationalSubDivision;
    /**
     * The useDistrict
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDistrict;
    /**
     * The useCommunityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCommunityName;
    /**
     * The useCityDivision
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCityDivision;
    /**
     * The useNeighbourhood
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useNeighbourhood;
    /**
     * The useStreet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useStreet;
    /**
     * The useLeadingStreetDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useLeadingStreetDirection;
    /**
     * The useTrailingStreetSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useTrailingStreetSuffix;
    /**
     * The useStreetSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useStreetSuffix;
    /**
     * The useHouseNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useHouseNumber;
    /**
     * The useHouseNumberSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useHouseNumberSuffix;
    /**
     * The useLandmark
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useLandmark;
    /**
     * The useLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useLocation;
    /**
     * The useFloor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useFloor;
    /**
     * The useOccupantName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useOccupantName;
    /**
     * The usePostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePostalCode;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LGeoLocationFilter
     * @uses LGeoLocationFilter::setName()
     * @uses LGeoLocationFilter::setDescription()
     * @uses LGeoLocationFilter::setUseCountry()
     * @uses LGeoLocationFilter::setUseNationalSubDivision()
     * @uses LGeoLocationFilter::setUseDistrict()
     * @uses LGeoLocationFilter::setUseCommunityName()
     * @uses LGeoLocationFilter::setUseCityDivision()
     * @uses LGeoLocationFilter::setUseNeighbourhood()
     * @uses LGeoLocationFilter::setUseStreet()
     * @uses LGeoLocationFilter::setUseLeadingStreetDirection()
     * @uses LGeoLocationFilter::setUseTrailingStreetSuffix()
     * @uses LGeoLocationFilter::setUseStreetSuffix()
     * @uses LGeoLocationFilter::setUseHouseNumber()
     * @uses LGeoLocationFilter::setUseHouseNumberSuffix()
     * @uses LGeoLocationFilter::setUseLandmark()
     * @uses LGeoLocationFilter::setUseLocation()
     * @uses LGeoLocationFilter::setUseFloor()
     * @uses LGeoLocationFilter::setUseOccupantName()
     * @uses LGeoLocationFilter::setUsePostalCode()
     * @uses LGeoLocationFilter::setUuid()
     * @param string $name
     * @param string $description
     * @param string $useCountry
     * @param string $useNationalSubDivision
     * @param string $useDistrict
     * @param string $useCommunityName
     * @param string $useCityDivision
     * @param string $useNeighbourhood
     * @param string $useStreet
     * @param string $useLeadingStreetDirection
     * @param string $useTrailingStreetSuffix
     * @param string $useStreetSuffix
     * @param string $useHouseNumber
     * @param string $useHouseNumberSuffix
     * @param string $useLandmark
     * @param string $useLocation
     * @param string $useFloor
     * @param string $useOccupantName
     * @param string $usePostalCode
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $useCountry = null, $useNationalSubDivision = null, $useDistrict = null, $useCommunityName = null, $useCityDivision = null, $useNeighbourhood = null, $useStreet = null, $useLeadingStreetDirection = null, $useTrailingStreetSuffix = null, $useStreetSuffix = null, $useHouseNumber = null, $useHouseNumberSuffix = null, $useLandmark = null, $useLocation = null, $useFloor = null, $useOccupantName = null, $usePostalCode = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setUseCountry($useCountry)
            ->setUseNationalSubDivision($useNationalSubDivision)
            ->setUseDistrict($useDistrict)
            ->setUseCommunityName($useCommunityName)
            ->setUseCityDivision($useCityDivision)
            ->setUseNeighbourhood($useNeighbourhood)
            ->setUseStreet($useStreet)
            ->setUseLeadingStreetDirection($useLeadingStreetDirection)
            ->setUseTrailingStreetSuffix($useTrailingStreetSuffix)
            ->setUseStreetSuffix($useStreetSuffix)
            ->setUseHouseNumber($useHouseNumber)
            ->setUseHouseNumberSuffix($useHouseNumberSuffix)
            ->setUseLandmark($useLandmark)
            ->setUseLocation($useLocation)
            ->setUseFloor($useFloor)
            ->setUseOccupantName($useOccupantName)
            ->setUsePostalCode($usePostalCode)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LGeoLocationFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return LGeoLocationFilter
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get useCountry value
     * @return string|null
     */
    public function getUseCountry()
    {
        return $this->useCountry;
    }
    /**
     * Set useCountry value
     * @param string $useCountry
     * @return LGeoLocationFilter
     */
    public function setUseCountry($useCountry = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useCountry) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useCountry, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useCountry) && !is_string($useCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useCountry)), __LINE__);
        }
        $this->useCountry = $useCountry;
        return $this;
    }
    /**
     * Get useNationalSubDivision value
     * @return string|null
     */
    public function getUseNationalSubDivision()
    {
        return $this->useNationalSubDivision;
    }
    /**
     * Set useNationalSubDivision value
     * @param string $useNationalSubDivision
     * @return LGeoLocationFilter
     */
    public function setUseNationalSubDivision($useNationalSubDivision = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useNationalSubDivision) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useNationalSubDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useNationalSubDivision, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useNationalSubDivision) && !is_string($useNationalSubDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useNationalSubDivision)), __LINE__);
        }
        $this->useNationalSubDivision = $useNationalSubDivision;
        return $this;
    }
    /**
     * Get useDistrict value
     * @return string|null
     */
    public function getUseDistrict()
    {
        return $this->useDistrict;
    }
    /**
     * Set useDistrict value
     * @param string $useDistrict
     * @return LGeoLocationFilter
     */
    public function setUseDistrict($useDistrict = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDistrict) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDistrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDistrict, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDistrict) && !is_string($useDistrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDistrict)), __LINE__);
        }
        $this->useDistrict = $useDistrict;
        return $this;
    }
    /**
     * Get useCommunityName value
     * @return string|null
     */
    public function getUseCommunityName()
    {
        return $this->useCommunityName;
    }
    /**
     * Set useCommunityName value
     * @param string $useCommunityName
     * @return LGeoLocationFilter
     */
    public function setUseCommunityName($useCommunityName = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useCommunityName) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCommunityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useCommunityName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useCommunityName) && !is_string($useCommunityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useCommunityName)), __LINE__);
        }
        $this->useCommunityName = $useCommunityName;
        return $this;
    }
    /**
     * Get useCityDivision value
     * @return string|null
     */
    public function getUseCityDivision()
    {
        return $this->useCityDivision;
    }
    /**
     * Set useCityDivision value
     * @param string $useCityDivision
     * @return LGeoLocationFilter
     */
    public function setUseCityDivision($useCityDivision = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useCityDivision) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCityDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useCityDivision, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useCityDivision) && !is_string($useCityDivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useCityDivision)), __LINE__);
        }
        $this->useCityDivision = $useCityDivision;
        return $this;
    }
    /**
     * Get useNeighbourhood value
     * @return string|null
     */
    public function getUseNeighbourhood()
    {
        return $this->useNeighbourhood;
    }
    /**
     * Set useNeighbourhood value
     * @param string $useNeighbourhood
     * @return LGeoLocationFilter
     */
    public function setUseNeighbourhood($useNeighbourhood = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useNeighbourhood) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useNeighbourhood)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useNeighbourhood, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useNeighbourhood) && !is_string($useNeighbourhood)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useNeighbourhood)), __LINE__);
        }
        $this->useNeighbourhood = $useNeighbourhood;
        return $this;
    }
    /**
     * Get useStreet value
     * @return string|null
     */
    public function getUseStreet()
    {
        return $this->useStreet;
    }
    /**
     * Set useStreet value
     * @param string $useStreet
     * @return LGeoLocationFilter
     */
    public function setUseStreet($useStreet = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useStreet) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useStreet, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useStreet) && !is_string($useStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useStreet)), __LINE__);
        }
        $this->useStreet = $useStreet;
        return $this;
    }
    /**
     * Get useLeadingStreetDirection value
     * @return string|null
     */
    public function getUseLeadingStreetDirection()
    {
        return $this->useLeadingStreetDirection;
    }
    /**
     * Set useLeadingStreetDirection value
     * @param string $useLeadingStreetDirection
     * @return LGeoLocationFilter
     */
    public function setUseLeadingStreetDirection($useLeadingStreetDirection = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useLeadingStreetDirection) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useLeadingStreetDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useLeadingStreetDirection, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useLeadingStreetDirection) && !is_string($useLeadingStreetDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useLeadingStreetDirection)), __LINE__);
        }
        $this->useLeadingStreetDirection = $useLeadingStreetDirection;
        return $this;
    }
    /**
     * Get useTrailingStreetSuffix value
     * @return string|null
     */
    public function getUseTrailingStreetSuffix()
    {
        return $this->useTrailingStreetSuffix;
    }
    /**
     * Set useTrailingStreetSuffix value
     * @param string $useTrailingStreetSuffix
     * @return LGeoLocationFilter
     */
    public function setUseTrailingStreetSuffix($useTrailingStreetSuffix = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useTrailingStreetSuffix) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useTrailingStreetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useTrailingStreetSuffix, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useTrailingStreetSuffix) && !is_string($useTrailingStreetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useTrailingStreetSuffix)), __LINE__);
        }
        $this->useTrailingStreetSuffix = $useTrailingStreetSuffix;
        return $this;
    }
    /**
     * Get useStreetSuffix value
     * @return string|null
     */
    public function getUseStreetSuffix()
    {
        return $this->useStreetSuffix;
    }
    /**
     * Set useStreetSuffix value
     * @param string $useStreetSuffix
     * @return LGeoLocationFilter
     */
    public function setUseStreetSuffix($useStreetSuffix = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useStreetSuffix) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useStreetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useStreetSuffix, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useStreetSuffix) && !is_string($useStreetSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useStreetSuffix)), __LINE__);
        }
        $this->useStreetSuffix = $useStreetSuffix;
        return $this;
    }
    /**
     * Get useHouseNumber value
     * @return string|null
     */
    public function getUseHouseNumber()
    {
        return $this->useHouseNumber;
    }
    /**
     * Set useHouseNumber value
     * @param string $useHouseNumber
     * @return LGeoLocationFilter
     */
    public function setUseHouseNumber($useHouseNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useHouseNumber) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useHouseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useHouseNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useHouseNumber) && !is_string($useHouseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useHouseNumber)), __LINE__);
        }
        $this->useHouseNumber = $useHouseNumber;
        return $this;
    }
    /**
     * Get useHouseNumberSuffix value
     * @return string|null
     */
    public function getUseHouseNumberSuffix()
    {
        return $this->useHouseNumberSuffix;
    }
    /**
     * Set useHouseNumberSuffix value
     * @param string $useHouseNumberSuffix
     * @return LGeoLocationFilter
     */
    public function setUseHouseNumberSuffix($useHouseNumberSuffix = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useHouseNumberSuffix) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useHouseNumberSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useHouseNumberSuffix, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useHouseNumberSuffix) && !is_string($useHouseNumberSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useHouseNumberSuffix)), __LINE__);
        }
        $this->useHouseNumberSuffix = $useHouseNumberSuffix;
        return $this;
    }
    /**
     * Get useLandmark value
     * @return string|null
     */
    public function getUseLandmark()
    {
        return $this->useLandmark;
    }
    /**
     * Set useLandmark value
     * @param string $useLandmark
     * @return LGeoLocationFilter
     */
    public function setUseLandmark($useLandmark = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useLandmark) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useLandmark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useLandmark, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useLandmark) && !is_string($useLandmark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useLandmark)), __LINE__);
        }
        $this->useLandmark = $useLandmark;
        return $this;
    }
    /**
     * Get useLocation value
     * @return string|null
     */
    public function getUseLocation()
    {
        return $this->useLocation;
    }
    /**
     * Set useLocation value
     * @param string $useLocation
     * @return LGeoLocationFilter
     */
    public function setUseLocation($useLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useLocation) && !is_string($useLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useLocation)), __LINE__);
        }
        $this->useLocation = $useLocation;
        return $this;
    }
    /**
     * Get useFloor value
     * @return string|null
     */
    public function getUseFloor()
    {
        return $this->useFloor;
    }
    /**
     * Set useFloor value
     * @param string $useFloor
     * @return LGeoLocationFilter
     */
    public function setUseFloor($useFloor = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useFloor) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useFloor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useFloor, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useFloor) && !is_string($useFloor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useFloor)), __LINE__);
        }
        $this->useFloor = $useFloor;
        return $this;
    }
    /**
     * Get useOccupantName value
     * @return string|null
     */
    public function getUseOccupantName()
    {
        return $this->useOccupantName;
    }
    /**
     * Set useOccupantName value
     * @param string $useOccupantName
     * @return LGeoLocationFilter
     */
    public function setUseOccupantName($useOccupantName = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useOccupantName) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useOccupantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useOccupantName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useOccupantName) && !is_string($useOccupantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useOccupantName)), __LINE__);
        }
        $this->useOccupantName = $useOccupantName;
        return $this;
    }
    /**
     * Get usePostalCode value
     * @return string|null
     */
    public function getUsePostalCode()
    {
        return $this->usePostalCode;
    }
    /**
     * Set usePostalCode value
     * @param string $usePostalCode
     * @return LGeoLocationFilter
     */
    public function setUsePostalCode($usePostalCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($usePostalCode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $usePostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($usePostalCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($usePostalCode) && !is_string($usePostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usePostalCode)), __LINE__);
        }
        $this->usePostalCode = $usePostalCode;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LGeoLocationFilter
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LGeoLocationFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
