<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LGatewayEndpointAnalog StructType
 * @subpackage Structs
 */
class LGatewayEndpointAnalog extends AbstractStructBase
{
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XVendorConfig
     */
    public $vendorConfig;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $geoLocationFilterName;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LAnalogPort
     */
    public $port;
    /**
     * The trunkSelectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkSelectionOrder;
    /**
     * The transmitUtf8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The callingPartyNumberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $callingPartyNumberPrefix;
    /**
     * The callingPartyStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyStripDigits;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCssUnknown
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnknown;
    /**
     * The hotlineDevice
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable for MGCP FXS ports,which supports PLAR.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $imeE164TransformationName;
    /**
     * The imeE164DirectoryNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $imeE164DirectoryNumber;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LGatewayEndpointAnalog
     * @uses LGatewayEndpointAnalog::setIndex()
     * @uses LGatewayEndpointAnalog::setName()
     * @uses LGatewayEndpointAnalog::setDescription()
     * @uses LGatewayEndpointAnalog::setProduct()
     * @uses LGatewayEndpointAnalog::setModel()
     * @uses LGatewayEndpointAnalog::setClass()
     * @uses LGatewayEndpointAnalog::setProtocol()
     * @uses LGatewayEndpointAnalog::setProtocolSide()
     * @uses LGatewayEndpointAnalog::setCallingSearchSpaceName()
     * @uses LGatewayEndpointAnalog::setDevicePoolName()
     * @uses LGatewayEndpointAnalog::setCommonDeviceConfigName()
     * @uses LGatewayEndpointAnalog::setNetworkLocale()
     * @uses LGatewayEndpointAnalog::setLocationName()
     * @uses LGatewayEndpointAnalog::setMediaResourceListName()
     * @uses LGatewayEndpointAnalog::setAutomatedAlternateRoutingCssName()
     * @uses LGatewayEndpointAnalog::setAarNeighborhoodName()
     * @uses LGatewayEndpointAnalog::setVendorConfig()
     * @uses LGatewayEndpointAnalog::setMlppDomainId()
     * @uses LGatewayEndpointAnalog::setUseTrustedRelayPoint()
     * @uses LGatewayEndpointAnalog::setRetryVideoCallAsAudio()
     * @uses LGatewayEndpointAnalog::setCgpnTransformationCssName()
     * @uses LGatewayEndpointAnalog::setUseDevicePoolCgpnTransformCss()
     * @uses LGatewayEndpointAnalog::setGeoLocationName()
     * @uses LGatewayEndpointAnalog::setGeoLocationFilterName()
     * @uses LGatewayEndpointAnalog::setPort()
     * @uses LGatewayEndpointAnalog::setTrunkSelectionOrder()
     * @uses LGatewayEndpointAnalog::setTransmitUtf8()
     * @uses LGatewayEndpointAnalog::setCdpnTransformationCssName()
     * @uses LGatewayEndpointAnalog::setUseDevicePoolCdpnTransformCss()
     * @uses LGatewayEndpointAnalog::setCallingPartyNumberPrefix()
     * @uses LGatewayEndpointAnalog::setCallingPartyStripDigits()
     * @uses LGatewayEndpointAnalog::setCallingPartyUnknownTransformationCssName()
     * @uses LGatewayEndpointAnalog::setUseDevicePoolCgpnTransformCssUnknown()
     * @uses LGatewayEndpointAnalog::setHotlineDevice()
     * @uses LGatewayEndpointAnalog::setPacketCaptureMode()
     * @uses LGatewayEndpointAnalog::setPacketCaptureDuration()
     * @uses LGatewayEndpointAnalog::setPstnAccess()
     * @uses LGatewayEndpointAnalog::setImeE164TransformationName()
     * @uses LGatewayEndpointAnalog::setImeE164DirectoryNumber()
     * @uses LGatewayEndpointAnalog::setConfidentialAccess()
     * @uses LGatewayEndpointAnalog::setCtiid()
     * @uses LGatewayEndpointAnalog::setUuid()
     * @param string $index
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param XFkType $callingSearchSpaceName
     * @param XFkType $devicePoolName
     * @param XFkType $commonDeviceConfigName
     * @param string $networkLocale
     * @param XFkType $locationName
     * @param XFkType $mediaResourceListName
     * @param XFkType $automatedAlternateRoutingCssName
     * @param XFkType $aarNeighborhoodName
     * @param XVendorConfig $vendorConfig
     * @param string $mlppDomainId
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param XFkType $geoLocationName
     * @param XFkType $geoLocationFilterName
     * @param LAnalogPort $port
     * @param string $trunkSelectionOrder
     * @param string $transmitUtf8
     * @param XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $callingPartyNumberPrefix
     * @param string $callingPartyStripDigits
     * @param XFkType $callingPartyUnknownTransformationCssName
     * @param string $useDevicePoolCgpnTransformCssUnknown
     * @param string $hotlineDevice
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $pstnAccess
     * @param XFkType $imeE164TransformationName
     * @param string $imeE164DirectoryNumber
     * @param ConfidentialAccess $confidentialAccess
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($index = null, $name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, XFkType $callingSearchSpaceName = null, XFkType $devicePoolName = null, XFkType $commonDeviceConfigName = null, $networkLocale = null, XFkType $locationName = null, XFkType $mediaResourceListName = null, XFkType $automatedAlternateRoutingCssName = null, XFkType $aarNeighborhoodName = null, XVendorConfig $vendorConfig = null, $mlppDomainId = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, XFkType $geoLocationName = null, XFkType $geoLocationFilterName = null, LAnalogPort $port = null, $trunkSelectionOrder = null, $transmitUtf8 = null, XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = null, $callingPartyNumberPrefix = null, $callingPartyStripDigits = null, XFkType $callingPartyUnknownTransformationCssName = null, $useDevicePoolCgpnTransformCssUnknown = null, $hotlineDevice = null, $packetCaptureMode = null, $packetCaptureDuration = null, $pstnAccess = null, XFkType $imeE164TransformationName = null, $imeE164DirectoryNumber = null, ConfidentialAccess $confidentialAccess = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setIndex($index)
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocale($networkLocale)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setVendorConfig($vendorConfig)
            ->setMlppDomainId($mlppDomainId)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setPort($port)
            ->setTrunkSelectionOrder($trunkSelectionOrder)
            ->setTransmitUtf8($transmitUtf8)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setCallingPartyNumberPrefix($callingPartyNumberPrefix)
            ->setCallingPartyStripDigits($callingPartyStripDigits)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setUseDevicePoolCgpnTransformCssUnknown($useDevicePoolCgpnTransformCssUnknown)
            ->setHotlineDevice($hotlineDevice)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setImeE164DirectoryNumber($imeE164DirectoryNumber)
            ->setConfidentialAccess($confidentialAccess)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return LGatewayEndpointAnalog
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LGatewayEndpointAnalog
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return LGatewayEndpointAnalog
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return LGatewayEndpointAnalog
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses XModel::valueIsValid()
     * @uses XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return LGatewayEndpointAnalog
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses XClass::valueIsValid()
     * @uses XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return LGatewayEndpointAnalog
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses XDeviceProtocol::valueIsValid()
     * @uses XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return LGatewayEndpointAnalog
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses XProtocolSide::valueIsValid()
     * @uses XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return LGatewayEndpointAnalog
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param XFkType $callingSearchSpaceName
     * @return LGatewayEndpointAnalog
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return LGatewayEndpointAnalog
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param XFkType $commonDeviceConfigName
     * @return LGatewayEndpointAnalog
     */
    public function setCommonDeviceConfigName(XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @uses XCountry::valueIsValid()
     * @uses XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return LGatewayEndpointAnalog
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', XCountry::getValidValues())), __LINE__);
        }
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return LGatewayEndpointAnalog
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param XFkType $mediaResourceListName
     * @return LGatewayEndpointAnalog
     */
    public function setMediaResourceListName(XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param XFkType $automatedAlternateRoutingCssName
     * @return LGatewayEndpointAnalog
     */
    public function setAutomatedAlternateRoutingCssName(XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param XFkType $aarNeighborhoodName
     * @return LGatewayEndpointAnalog
     */
    public function setAarNeighborhoodName(XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param XVendorConfig $vendorConfig
     * @return LGatewayEndpointAnalog
     */
    public function setVendorConfig(XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return LGatewayEndpointAnalog
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return LGatewayEndpointAnalog
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return LGatewayEndpointAnalog
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param XFkType $cgpnTransformationCssName
     * @return LGatewayEndpointAnalog
     */
    public function setCgpnTransformationCssName(XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return LGatewayEndpointAnalog
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param XFkType $geoLocationName
     * @return LGatewayEndpointAnalog
     */
    public function setGeoLocationName(XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param XFkType $geoLocationFilterName
     * @return LGatewayEndpointAnalog
     */
    public function setGeoLocationFilterName(XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get port value
     * @return LAnalogPort|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param LAnalogPort $port
     * @return LGatewayEndpointAnalog
     */
    public function setPort(LAnalogPort $port = null)
    {
        $this->port = $port;
        return $this;
    }
    /**
     * Get trunkSelectionOrder value
     * @return string|null
     */
    public function getTrunkSelectionOrder()
    {
        return $this->trunkSelectionOrder;
    }
    /**
     * Set trunkSelectionOrder value
     * @uses XTrunkSelectionOrder::valueIsValid()
     * @uses XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkSelectionOrder
     * @return LGatewayEndpointAnalog
     */
    public function setTrunkSelectionOrder($trunkSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!XTrunkSelectionOrder::valueIsValid($trunkSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkSelectionOrder, implode(', ', XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->trunkSelectionOrder = $trunkSelectionOrder;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return LGatewayEndpointAnalog
     */
    public function setTransmitUtf8($transmitUtf8 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitUtf8)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param XFkType $cdpnTransformationCssName
     * @return LGatewayEndpointAnalog
     */
    public function setCdpnTransformationCssName(XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return LGatewayEndpointAnalog
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get callingPartyNumberPrefix value
     * @return string|null
     */
    public function getCallingPartyNumberPrefix()
    {
        return $this->callingPartyNumberPrefix;
    }
    /**
     * Set callingPartyNumberPrefix value
     * @param string $callingPartyNumberPrefix
     * @return LGatewayEndpointAnalog
     */
    public function setCallingPartyNumberPrefix($callingPartyNumberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyNumberPrefix) && strlen($callingPartyNumberPrefix) > 16) || (is_array($callingPartyNumberPrefix) && count($callingPartyNumberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyNumberPrefix) ? strlen($callingPartyNumberPrefix) : count($callingPartyNumberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyNumberPrefix) && !is_string($callingPartyNumberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyNumberPrefix)), __LINE__);
        }
        $this->callingPartyNumberPrefix = $callingPartyNumberPrefix;
        return $this;
    }
    /**
     * Get callingPartyStripDigits value
     * @return string|null
     */
    public function getCallingPartyStripDigits()
    {
        return $this->callingPartyStripDigits;
    }
    /**
     * Set callingPartyStripDigits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyStripDigits
     * @return LGatewayEndpointAnalog
     */
    public function setCallingPartyStripDigits($callingPartyStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($callingPartyStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->callingPartyStripDigits = $callingPartyStripDigits;
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * @return XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return $this->callingPartyUnknownTransformationCssName;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * @param XFkType $callingPartyUnknownTransformationCssName
     * @return LGatewayEndpointAnalog
     */
    public function setCallingPartyUnknownTransformationCssName(XFkType $callingPartyUnknownTransformationCssName = null)
    {
        $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnknown value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnknown()
    {
        return $this->useDevicePoolCgpnTransformCssUnknown;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnknown value
     * @param string $useDevicePoolCgpnTransformCssUnknown
     * @return LGatewayEndpointAnalog
     */
    public function setUseDevicePoolCgpnTransformCssUnknown($useDevicePoolCgpnTransformCssUnknown = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssUnknown) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnknown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssUnknown, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnknown) && !is_string($useDevicePoolCgpnTransformCssUnknown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssUnknown)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnknown = $useDevicePoolCgpnTransformCssUnknown;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return LGatewayEndpointAnalog
     */
    public function setHotlineDevice($hotlineDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($hotlineDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($hotlineDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hotlineDevice) && !is_string($hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotlineDevice)), __LINE__);
        }
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses XPacketCaptureMode::valueIsValid()
     * @uses XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return LGatewayEndpointAnalog
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        // validation for constraint: enumeration
        if (!XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return LGatewayEndpointAnalog
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return LGatewayEndpointAnalog
     */
    public function setPstnAccess($pstnAccess = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * @return XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return $this->imeE164TransformationName;
    }
    /**
     * Set imeE164TransformationName value
     * @param XFkType $imeE164TransformationName
     * @return LGatewayEndpointAnalog
     */
    public function setImeE164TransformationName(XFkType $imeE164TransformationName = null)
    {
        $this->imeE164TransformationName = $imeE164TransformationName;
        return $this;
    }
    /**
     * Get imeE164DirectoryNumber value
     * @return string|null
     */
    public function getImeE164DirectoryNumber()
    {
        return $this->imeE164DirectoryNumber;
    }
    /**
     * Set imeE164DirectoryNumber value
     * @param string $imeE164DirectoryNumber
     * @return LGatewayEndpointAnalog
     */
    public function setImeE164DirectoryNumber($imeE164DirectoryNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($imeE164DirectoryNumber) && strlen($imeE164DirectoryNumber) > 16) || (is_array($imeE164DirectoryNumber) && count($imeE164DirectoryNumber) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($imeE164DirectoryNumber) ? strlen($imeE164DirectoryNumber) : count($imeE164DirectoryNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($imeE164DirectoryNumber) && !is_string($imeE164DirectoryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imeE164DirectoryNumber)), __LINE__);
        }
        $this->imeE164DirectoryNumber = $imeE164DirectoryNumber;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param ConfidentialAccess $confidentialAccess
     * @return LGatewayEndpointAnalog
     */
    public function setConfidentialAccess(ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return LGatewayEndpointAnalog
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LGatewayEndpointAnalog
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LGatewayEndpointAnalog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
