<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LFixedMohAudioSource StructType
 * @subpackage Structs
 */
class LFixedMohAudioSource extends AbstractStructBase
{
    /**
     * The sourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sourceId;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The multicast
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The enable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enable;
    /**
     * The initialAnnouncement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $initialAnnouncement;
    /**
     * The periodicAnnouncement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $periodicAnnouncement;
    /**
     * The periodicAnnouncementInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $periodicAnnouncementInterval;
    /**
     * The localeAnnouncement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $localeAnnouncement;
    /**
     * The initialAnnouncementPlayed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $initialAnnouncementPlayed;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LFixedMohAudioSource
     * @uses LFixedMohAudioSource::setSourceId()
     * @uses LFixedMohAudioSource::setName()
     * @uses LFixedMohAudioSource::setMulticast()
     * @uses LFixedMohAudioSource::setEnable()
     * @uses LFixedMohAudioSource::setInitialAnnouncement()
     * @uses LFixedMohAudioSource::setPeriodicAnnouncement()
     * @uses LFixedMohAudioSource::setPeriodicAnnouncementInterval()
     * @uses LFixedMohAudioSource::setLocaleAnnouncement()
     * @uses LFixedMohAudioSource::setInitialAnnouncementPlayed()
     * @uses LFixedMohAudioSource::setUuid()
     * @param string $sourceId
     * @param string $name
     * @param string $multicast
     * @param string $enable
     * @param XFkType $initialAnnouncement
     * @param XFkType $periodicAnnouncement
     * @param string $periodicAnnouncementInterval
     * @param string $localeAnnouncement
     * @param string $initialAnnouncementPlayed
     * @param string $uuid
     */
    public function __construct($sourceId = null, $name = null, $multicast = null, $enable = null, XFkType $initialAnnouncement = null, XFkType $periodicAnnouncement = null, $periodicAnnouncementInterval = null, $localeAnnouncement = null, $initialAnnouncementPlayed = null, $uuid = null)
    {
        $this
            ->setSourceId($sourceId)
            ->setName($name)
            ->setMulticast($multicast)
            ->setEnable($enable)
            ->setInitialAnnouncement($initialAnnouncement)
            ->setPeriodicAnnouncement($periodicAnnouncement)
            ->setPeriodicAnnouncementInterval($periodicAnnouncementInterval)
            ->setLocaleAnnouncement($localeAnnouncement)
            ->setInitialAnnouncementPlayed($initialAnnouncementPlayed)
            ->setUuid($uuid);
    }
    /**
     * Get sourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->sourceId;
    }
    /**
     * Set sourceId value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceId
     * @return LFixedMohAudioSource
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sourceId, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->sourceId = $sourceId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LFixedMohAudioSource
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get multicast value
     * @return string|null
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return LFixedMohAudioSource
     */
    public function setMulticast($multicast = null)
    {
        // validation for constraint: pattern
        if (is_scalar($multicast) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($multicast, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($multicast) && !is_string($multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multicast)), __LINE__);
        }
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->enable;
    }
    /**
     * Set enable value
     * @param string $enable
     * @return LFixedMohAudioSource
     */
    public function setEnable($enable = null)
    {
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enable)), __LINE__);
        }
        $this->enable = $enable;
        return $this;
    }
    /**
     * Get initialAnnouncement value
     * @return XFkType|null
     */
    public function getInitialAnnouncement()
    {
        return $this->initialAnnouncement;
    }
    /**
     * Set initialAnnouncement value
     * @param XFkType $initialAnnouncement
     * @return LFixedMohAudioSource
     */
    public function setInitialAnnouncement(XFkType $initialAnnouncement = null)
    {
        $this->initialAnnouncement = $initialAnnouncement;
        return $this;
    }
    /**
     * Get periodicAnnouncement value
     * @return XFkType|null
     */
    public function getPeriodicAnnouncement()
    {
        return $this->periodicAnnouncement;
    }
    /**
     * Set periodicAnnouncement value
     * @param XFkType $periodicAnnouncement
     * @return LFixedMohAudioSource
     */
    public function setPeriodicAnnouncement(XFkType $periodicAnnouncement = null)
    {
        $this->periodicAnnouncement = $periodicAnnouncement;
        return $this;
    }
    /**
     * Get periodicAnnouncementInterval value
     * @return string|null
     */
    public function getPeriodicAnnouncementInterval()
    {
        return $this->periodicAnnouncementInterval;
    }
    /**
     * Set periodicAnnouncementInterval value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicAnnouncementInterval
     * @return LFixedMohAudioSource
     */
    public function setPeriodicAnnouncementInterval($periodicAnnouncementInterval = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($periodicAnnouncementInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $periodicAnnouncementInterval, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->periodicAnnouncementInterval = $periodicAnnouncementInterval;
        return $this;
    }
    /**
     * Get localeAnnouncement value
     * @return string|null
     */
    public function getLocaleAnnouncement()
    {
        return $this->localeAnnouncement;
    }
    /**
     * Set localeAnnouncement value
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $localeAnnouncement
     * @return LFixedMohAudioSource
     */
    public function setLocaleAnnouncement($localeAnnouncement = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($localeAnnouncement)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $localeAnnouncement, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        $this->localeAnnouncement = $localeAnnouncement;
        return $this;
    }
    /**
     * Get initialAnnouncementPlayed value
     * @return string|null
     */
    public function getInitialAnnouncementPlayed()
    {
        return $this->initialAnnouncementPlayed;
    }
    /**
     * Set initialAnnouncementPlayed value
     * @param string $initialAnnouncementPlayed
     * @return LFixedMohAudioSource
     */
    public function setInitialAnnouncementPlayed($initialAnnouncementPlayed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($initialAnnouncementPlayed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $initialAnnouncementPlayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($initialAnnouncementPlayed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($initialAnnouncementPlayed) && !is_string($initialAnnouncementPlayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($initialAnnouncementPlayed)), __LINE__);
        }
        $this->initialAnnouncementPlayed = $initialAnnouncementPlayed;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LFixedMohAudioSource
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LFixedMohAudioSource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
