<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDialPlanTag StructType
 * @subpackage Structs
 */
class LDialPlanTag extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Actually called "tag" in database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $dialPlanName;
    /**
     * The operator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $operator;
    /**
     * The suppressFromRouteFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $suppressFromRouteFilter;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDialPlanTag
     * @uses LDialPlanTag::setName()
     * @uses LDialPlanTag::setDialPlanName()
     * @uses LDialPlanTag::setOperator()
     * @uses LDialPlanTag::setSuppressFromRouteFilter()
     * @uses LDialPlanTag::setUuid()
     * @param string $name
     * @param XFkType $dialPlanName
     * @param string $operator
     * @param string $suppressFromRouteFilter
     * @param string $uuid
     */
    public function __construct($name = null, XFkType $dialPlanName = null, $operator = null, $suppressFromRouteFilter = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDialPlanName($dialPlanName)
            ->setOperator($operator)
            ->setSuppressFromRouteFilter($suppressFromRouteFilter)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LDialPlanTag
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param XFkType $dialPlanName
     * @return LDialPlanTag
     */
    public function setDialPlanName(XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses XOperator::valueIsValid()
     * @uses XOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return LDialPlanTag
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!XOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operator, implode(', ', XOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get suppressFromRouteFilter value
     * @return string|null
     */
    public function getSuppressFromRouteFilter()
    {
        return $this->suppressFromRouteFilter;
    }
    /**
     * Set suppressFromRouteFilter value
     * @param string $suppressFromRouteFilter
     * @return LDialPlanTag
     */
    public function setSuppressFromRouteFilter($suppressFromRouteFilter = null)
    {
        // validation for constraint: pattern
        if (is_scalar($suppressFromRouteFilter) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $suppressFromRouteFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($suppressFromRouteFilter, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($suppressFromRouteFilter) && !is_string($suppressFromRouteFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suppressFromRouteFilter)), __LINE__);
        }
        $this->suppressFromRouteFilter = $suppressFromRouteFilter;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LDialPlanTag
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LDialPlanTag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
